#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>

#include "qmrtg-utils.h"

/* up to hundred of megabytes supported */
#define MAX_BYTESTR_LEN     10

#define NEEDLE              "status: "
#define NEEDLE_LEN          8


int main() {
    char line[MAX_LOGLINE_LEN];
    char *startptr, *endptr;
    char val[MAX_BYTESTR_LEN];
    unsigned long integral = 0;
    unsigned int numentries = 0;
    unsigned int currval;
    float meanval = 0;
    unsigned int intmeanval;
    unsigned int maxval = 0;
    
    
    while ( fgets(line, MAX_LOGLINE_LEN, stdin) != NULL ) {
        /* do we care about this line? */
        if ((startptr = strstr(line, NEEDLE)) == NULL) continue;
        /* "status: " is contained in this string. Is it a useless 0 entry? */
        if (startptr[NEEDLE_LEN] == '0') continue;

        /* so, extracting the actual value */
        numentries++;
        startptr += NEEDLE_LEN;
        endptr = strchr(startptr, '/');
        if (endptr == NULL) continue;
        memcpy(val, startptr, endptr - startptr);
        val[endptr - startptr] = '\0';
        
        currval = (unsigned int)strtol(val, (char **)NULL, 10);
        integral += currval;
        maxval = (currval > maxval ? currval : maxval);
    }

    if (numentries != 0)
        meanval = (float)integral / (float)numentries;
   
    intmeanval = (unsigned int)meanval;
    if (meanval - (float)intmeanval > 0.5)
        intmeanval++;

    printf("%u\n%u\n", maxval, intmeanval);
    
    
    return 0;
}

