/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.writer;

import java.io.IOException;
import java.io.Writer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.AbstractPrerequisiteWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

public class PreAbilityWriter
extends AbstractPrerequisiteWriter
implements PrerequisiteWriterInterface {
    @Override
    public String kindHandled() {
        return "ability";
    }

    @Override
    public PrerequisiteOperator[] operatorsHandled() {
        return new PrerequisiteOperator[]{PrerequisiteOperator.GTEQ, PrerequisiteOperator.LT};
    }

    @Override
    public void write(Writer writer, Prerequisite prereq) throws PersistenceLayerException {
        this.checkValidOperator(prereq, this.operatorsHandled());
        try {
            String cat;
            if (prereq.getOperator().equals((Object)PrerequisiteOperator.LT)) {
                writer.write(33);
            }
            writer.write("PREABILITY:" + (prereq.isOverrideQualify() ? "Q:" : ""));
            writer.write(prereq.getOperand());
            writer.write(44);
            if (prereq.isOriginalCheckMult()) {
                writer.write("CHECKMULT,");
            }
            if ((cat = prereq.getCategoryName()) == null) {
                writer.write("CATEGORY=ANY,");
            } else {
                writer.write("CATEGORY=" + cat + ",");
            }
            writer.write(prereq.getKey());
            if (prereq.getSubKey() != null) {
                writer.write(" (");
                writer.write(prereq.getSubKey());
                writer.write(")");
            }
        }
        catch (IOException e) {
            throw new PersistenceLayerException(e.getMessage());
        }
    }

    @Override
    public boolean specialCase(Writer writer, Prerequisite prereq) throws IOException {
        PrerequisiteOperator po = this.getConsolidateMethod(this.kindHandled(), prereq, false);
        if (po == null) {
            return false;
        }
        if (this.hasSubordinateCheckMult(prereq)) {
            return false;
        }
        String cat = null;
        boolean foundCat = false;
        for (Prerequisite p : prereq.getPrerequisites()) {
            if (foundCat) {
                String thiscat = p.getCategoryName();
                if (!(thiscat == null ? cat != null : !thiscat.equals(cat))) continue;
                return false;
            }
            cat = p.getCategoryName();
            foundCat = true;
        }
        if (!po.equals((Object)prereq.getOperator())) {
            writer.write(33);
        }
        writer.write("PRE" + this.kindHandled().toUpperCase() + ":" + (prereq.isOverrideQualify() ? "Q:" : ""));
        writer.write(po.equals((Object)PrerequisiteOperator.GTEQ) ? prereq.getOperand() : "1");
        if (prereq.isOriginalCheckMult()) {
            writer.write(",CHECKMULT");
        }
        if (cat == null) {
            writer.write(",CATEGORY=ANY");
        } else {
            writer.write(",CATEGORY=" + cat);
        }
        for (Prerequisite p : prereq.getPrerequisites()) {
            writer.write(44);
            writer.write(p.getKey());
            if (p.getSubKey() == null) continue;
            writer.write(" (");
            writer.write(p.getSubKey());
            writer.write(")");
        }
        return true;
    }

    private boolean hasSubordinateCheckMult(Prerequisite prereq) {
        for (Prerequisite p : prereq.getPrerequisites()) {
            if (p.isOriginalCheckMult()) {
                return true;
            }
            for (Prerequisite sub : p.getPrerequisites()) {
                if (!this.hasSubordinateCheckMult(sub)) continue;
                return true;
            }
        }
        return false;
    }
}

