/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.skill;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Language;
import pcgen.core.kit.KitSkill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SelectionToken
extends AbstractTokenWithSeparator<KitSkill>
implements CDOMPrimaryToken<KitSkill> {
    private static final Class<Language> LANGUAGE_CLASS = Language.class;

    @Override
    public String getTokenName() {
        return "SELECTION";
    }

    @Override
    public Class<KitSkill> getTokenClass() {
        return KitSkill.class;
    }

    @Override
    protected char separator() {
        return ',';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, KitSkill kitSkill, String value) {
        StringTokenizer tok = new StringTokenizer(value, ",");
        while (tok.hasMoreTokens()) {
            kitSkill.addSelection(context.getReferenceContext().getCDOMReference(LANGUAGE_CLASS, tok.nextToken()));
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitSkill kitSkill) {
        List<CDOMSingleRef<Language>> ref = kitSkill.getSelections();
        if (ref == null || ref.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(ref, ",")};
    }
}

