/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens.deprecated;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class ClassToken
extends Token {
    public static final String TOKENNAME = "CLASS";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int i = 0;
        if (aTok.hasMoreTokens()) {
            i = Integer.parseInt(aTok.nextToken());
        }
        CharacterDisplay display = pc.getDisplay();
        if (aTok.hasMoreTokens()) {
            String subToken = aTok.nextToken();
            if ("LEVEL".equals(subToken)) {
                int level = ClassToken.getLevelToken(display, i);
                if (level > 0) {
                    return Integer.toString(level);
                }
                return "";
            }
            if ("SALIST".equals(subToken)) {
                return ClassToken.getSAListToken(pc, i);
            }
            if ("TYPE".equals(subToken)) {
                return ClassToken.getType(display, i);
            }
            if ("CLASSTYPE".equals(subToken)) {
                return ClassToken.getClassType(display, i);
            }
            if ("ISMONSTER".equals(subToken)) {
                return ClassToken.isMonster(display, i);
            }
        }
        return ClassToken.getClassToken(display, i);
    }

    public static String getClassToken(CharacterDisplay display, int classNumber) {
        String retString = "";
        if (display.getClassCount() > classNumber) {
            PCClass pcClass = display.getClassList().get(classNumber);
            String subClassKey = display.getSubClassName(pcClass);
            retString = subClassKey == null || "None".equals(subClassKey) || "".equals(subClassKey) ? OutputNameFormatting.getOutputName(pcClass) : pcClass.getSubClassKeyed(subClassKey).getDisplayName();
        }
        return retString;
    }

    public static int getLevelToken(CharacterDisplay display, int classNumber) {
        if (display.getClassCount() > classNumber) {
            PCClass pcClass = display.getClassList().get(classNumber);
            return display.getLevel(pcClass);
        }
        return 0;
    }

    public static String getSAListToken(PlayerCharacter pc, int classNumber) {
        if (pc.getDisplay().getClassCount() > classNumber) {
            PCClass pcClass = pc.getDisplay().getClassList().get(classNumber);
            List<String> saList = ClassToken.getClassSpecialAbilityList(pcClass, pc);
            return StringUtil.join(saList, (String)", ");
        }
        return "";
    }

    public static List<String> getClassSpecialAbilityList(PCClass pcclass, PlayerCharacter aPC) {
        CharacterDisplay display = aPC.getDisplay();
        ArrayList<String> formattedList = new ArrayList<String>();
        ArrayList<SpecialAbility> saList = new ArrayList<SpecialAbility>();
        saList.addAll(display.getResolvedUserSpecialAbilities(pcclass));
        saList.addAll(display.getResolvedSpecialAbilities(pcclass));
        for (int i = 1; i <= display.getLevel(pcclass); ++i) {
            PCClassLevel pcl = display.getActiveClassLevel(pcclass, i);
            saList.addAll(display.getResolvedUserSpecialAbilities(pcl));
            saList.addAll(display.getResolvedSpecialAbilities(pcl));
        }
        if (saList.isEmpty()) {
            return formattedList;
        }
        Collections.sort(saList);
        for (SpecialAbility sa : saList) {
            String str = sa.getDisplayName();
            if (str == null || str.length() == 0) continue;
            StringTokenizer varTok = new StringTokenizer(str, "|");
            String aString = varTok.nextToken();
            int[] varValue = null;
            int varCount = varTok.countTokens();
            if (varCount != 0) {
                varValue = new int[varCount];
                for (int j = 0; j < varCount; ++j) {
                    String vString = varTok.nextToken();
                    varValue[j] = aPC.getVariable(vString, true).intValue();
                }
            }
            StringBuilder newAbility = new StringBuilder();
            varTok = new StringTokenizer(aString, "%", true);
            varCount = 0;
            boolean isZero = false;
            while (varTok.hasMoreTokens()) {
                String nextTok = varTok.nextToken();
                if ("%".equals(nextTok)) {
                    if (varCount == 0) {
                        isZero = true;
                    }
                    if (varValue != null && varCount < varValue.length) {
                        int thisVar;
                        isZero &= (thisVar = varValue[varCount++]) == 0;
                        newAbility.append(thisVar);
                        continue;
                    }
                    newAbility.append('%');
                    continue;
                }
                newAbility.append(nextTok);
            }
            if (isZero) continue;
            formattedList.add(newAbility.toString());
        }
        return formattedList;
    }

    public static String getType(CharacterDisplay display, int classNumber) {
        if (display.getClassCount() > classNumber) {
            return display.getClassList().get(classNumber).getType();
        }
        return "";
    }

    public static String getClassType(CharacterDisplay display, int classNumber) {
        if (display.getClassCount() > classNumber) {
            return display.getClassList().get(classNumber).getClassType();
        }
        return "";
    }

    public static String isMonster(CharacterDisplay display, int classNumber) {
        if (display.getClassCount() > classNumber) {
            return display.getClassList().get(classNumber).isMonster() ? "Y" : "N";
        }
        return "";
    }
}

