/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import pcgen.base.lang.UnreachableError;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.SourceEntry;
import pcgen.rules.context.LoadContext;

public final class GenericLoader<T extends CDOMObject>
extends LstObjectFileLoader<T> {
    private final Class<T> baseClass;

    public GenericLoader(Class<T> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Class for GenericLoader cannot be null");
        }
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw new IllegalArgumentException("Class for GenericLoader must not be abstract");
        }
        try {
            if (!Modifier.isPublic(cl.getConstructor(new Class[0]).getModifiers())) {
                throw new IllegalArgumentException("Class for GenericLoader must have public zero-argument constructor");
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Class for GenericLoader must have public zero-argument constructor");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class for GenericLoader must have zero-argument constructor");
        }
        this.baseClass = cl;
    }

    @Override
    public T parseLine(LoadContext context, T object, String lstLine, SourceEntry source) throws PersistenceLayerException {
        Object po;
        boolean isnew = false;
        if (object == null) {
            try {
                po = (CDOMObject)this.baseClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new UnreachableError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnreachableError((Throwable)e);
            }
            isnew = true;
        } else {
            po = object;
        }
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        if (colToken.hasMoreTokens()) {
            ((CDOMObject)po).setName(colToken.nextToken().intern());
            ((CDOMObject)po).put(ObjectKey.SOURCE_CAMPAIGN, source.getCampaign());
            ((CDOMObject)po).setSourceURI(source.getURI());
            if (isnew) {
                context.addStatefulInformation((CDOMObject)po);
                context.getReferenceContext().importObject(po);
            }
        }
        while (colToken.hasMoreTokens()) {
            LstUtils.processToken(context, (Loadable)po, source, colToken.nextToken());
        }
        this.completeObject(context, source, po);
        return null;
    }

    @Override
    protected T getObjectKeyed(LoadContext context, String aKey) {
        return (T)((CDOMObject)context.getReferenceContext().silentlyGetConstructedCDOMObject(this.baseClass, aKey));
    }
}

