/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import pcgen.core.GameMode;
import pcgen.core.PlayerCharacter;
import pcgen.facade.core.CampaignFacade;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public abstract class IOHandler {
    public final void read(PlayerCharacter aPC, String path) {
        this.internalRead(aPC, path, true);
    }

    public final void readForPreview(PlayerCharacter aPC, String path) {
        this.internalRead(aPC, path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRead(PlayerCharacter aPC, String path, boolean validate) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            this.read(aPC, in, validate);
        }
        catch (IOException ex) {
            Logging.errorPrint("Exception in IOHandler::read when reading", ex);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    Logging.errorPrint("Exception in IOHandler::read", e);
                }
                catch (NullPointerException e) {
                    Logging.errorPrint("Could not create file inputStream IOHandler::read", e);
                }
            }
        }
    }

    public final void write(PlayerCharacter aPC, String filename) throws IOException, NullPointerException {
        this.write(aPC, null, null, filename);
    }

    public final void write(PlayerCharacter aPC, GameMode mode, List<CampaignFacade> campaigns, String filename) throws IOException, NullPointerException {
        OutputStream out = null;
        try {
            File outFile = new File(filename);
            this.createBackupForFile(outFile);
            out = new FileOutputStream(filename);
            this.write(aPC, mode, campaigns, out);
        }
        catch (IOException ex) {
            Logging.errorPrint("Exception in IOHandler::write when writing", ex);
            throw ex;
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    Logging.errorPrint("Exception in IOHandler::write", e);
                    throw e;
                }
                catch (NullPointerException e) {
                    Logging.errorPrint("Could not create FileOutputStream in IOHandler::write", e);
                    throw e;
                }
            }
        }
    }

    public void createBackupForFile(File outFile) {
        String BAK_PREFIX = ".bak";
        if (PCGenSettings.getCreatePcgBackup() && outFile.exists() && outFile.length() > 0L) {
            File bakFile;
            String file = outFile.getName();
            String backupPcgPath = PCGenSettings.getBackupPcgDir();
            if (backupPcgPath == null || backupPcgPath.isEmpty()) {
                backupPcgPath = outFile.getParent();
            }
            if ((bakFile = new File(backupPcgPath, file + ".bak")).exists() && outFile.exists() && outFile.length() > 0L) {
                bakFile.delete();
            }
            outFile.renameTo(bakFile);
        }
    }

    protected abstract void read(PlayerCharacter var1, InputStream var2, boolean var3);

    protected abstract void write(PlayerCharacter var1, GameMode var2, List<CampaignFacade> var3, OutputStream var4);
}

