/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.model;

import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ItemFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.BonusChangeFacet;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.base.AbstractDataFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.SizeAdjustment;
import pcgen.core.analysis.SizeUtilities;
import pcgen.output.publish.OutputDB;

public class SizeFacet
extends AbstractDataFacet<CharID, SizeAdjustment>
implements DataFacetChangeListener<CharID, CDOMObject>,
LevelFacet.LevelChangeListener,
BonusChangeFacet.BonusChangeListener,
ItemFacet<CharID, SizeAdjustment> {
    private static final Class<SizeAdjustment> SIZEADJUSTMENT_CLASS = SizeAdjustment.class;
    private TemplateFacet templateFacet;
    private RaceFacet raceFacet;
    private FormulaResolvingFacet formulaResolvingFacet;
    private BonusCheckingFacet bonusCheckingFacet;
    private LevelFacet levelFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    public int racialSizeInt(CharID id) {
        SizeFacetInfo info = this.getInfo(id);
        if (info == null) {
            return SizeUtilities.getDefaultSizeAdjustment().get(IntegerKey.SIZEORDER);
        }
        return info.racialSizeInt;
    }

    private int calcRacialSizeInt(CharID id) {
        SizeFacetInfo info = this.getConstructingInfo(id);
        int iSize = SizeUtilities.getDefaultSizeAdjustment().get(IntegerKey.SIZEORDER);
        Race race = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        if (race != null) {
            Formula size = race.getSafe(FormulaKey.SIZE);
            iSize = this.formulaResolvingFacet.resolve(id, size, "").intValue();
            for (PCTemplate template : this.templateFacet.getSet(id)) {
                Formula sizeFormula = template.get(FormulaKey.SIZE);
                if (sizeFormula == null) continue;
                iSize = this.formulaResolvingFacet.resolve(id, sizeFormula, template.getKeyName()).intValue();
            }
        }
        info.racialSizeInt = iSize;
        return iSize;
    }

    public int sizeInt(CharID id) {
        SizeFacetInfo info = this.getInfo(id);
        if (info == null) {
            return SizeUtilities.getDefaultSizeAdjustment().get(IntegerKey.SIZEORDER);
        }
        return info.sizeInt;
    }

    public void update(CharID id) {
        SizeAdjustment newSize;
        SizeFacetInfo info = this.getConstructingInfo(id);
        int iSize = this.calcRacialSizeInt(id);
        Race race = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        if (race != null) {
            iSize += (int)this.bonusCheckingFacet.getBonus(id, "SIZEMOD", "NUMBER");
            iSize += this.sizesToAdvance(id, race);
            int maxIndex = Globals.getContext().getReferenceContext().getConstructedObjectCount(SIZEADJUSTMENT_CLASS) - 1;
            iSize = Math.min(maxIndex, Math.max(0, iSize));
        }
        info.sizeInt = iSize;
        SizeAdjustment oldSize = info.sizeAdj;
        info.sizeAdj = newSize = Globals.getContext().getReferenceContext().getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER).get(this.sizeInt(id));
        if (oldSize != newSize) {
            if (oldSize != null) {
                this.fireDataFacetChangeEvent(id, oldSize, 1);
            }
            this.fireDataFacetChangeEvent(id, newSize, 0);
        }
    }

    private int sizesToAdvance(CharID id, Race race) {
        return this.sizesToAdvance(race, this.levelFacet.getMonsterLevelCount(id));
    }

    int sizesToAdvance(Race race, int monsterLevelCount) {
        List<Integer> hda = race.getListFor(ListKey.HITDICE_ADVANCEMENT);
        int steps = 0;
        if (hda != null) {
            int limit = race.maxHitDiceAdvancement();
            for (Integer hitDie : hda) {
                if (monsterLevelCount <= hitDie) break;
                if (hitDie >= limit) continue;
                ++steps;
            }
        }
        return steps;
    }

    @Override
    public SizeAdjustment get(CharID id) {
        SizeFacetInfo info = this.getInfo(id);
        return info == null ? SizeUtilities.getDefaultSizeAdjustment() : info.sizeAdj;
    }

    public String getSizeAbb(CharID id) {
        return this.get(id).getKeyName();
    }

    private SizeFacetInfo getConstructingInfo(CharID id) {
        SizeFacetInfo rci = this.getInfo(id);
        if (rci == null) {
            rci = new SizeFacetInfo();
            this.setCache(id, rci);
        }
        return rci;
    }

    private SizeFacetInfo getInfo(CharID id) {
        return (SizeFacetInfo)this.getCache(id);
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.update(dfce.getCharID());
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.update(dfce.getCharID());
    }

    @Override
    public void levelChanged(LevelFacet.LevelChangeEvent lce) {
        this.update(lce.getCharID());
    }

    @Override
    public void bonusChange(BonusChangeFacet.BonusChangeEvent bce) {
        this.update(bce.getCharID());
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void setLevelFacet(LevelFacet levelFacet) {
        this.levelFacet = levelFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
        OutputDB.register("sizeadjustment", this);
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        SizeFacetInfo si = this.getInfo(source);
        if (si != null) {
            SizeFacetInfo copysfi = this.getConstructingInfo(copy);
            copysfi.racialSizeInt = si.racialSizeInt;
            copysfi.sizeAdj = si.sizeAdj;
            copysfi.sizeInt = si.sizeInt;
        }
    }

    private static class SizeFacetInfo {
        public int sizeInt;
        public int racialSizeInt;
        public SizeAdjustment sizeAdj;

        private SizeFacetInfo() {
        }

        public int hashCode() {
            return this.sizeInt ^ this.racialSizeInt * 29;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SizeFacetInfo) {
                SizeFacetInfo sfi = (SizeFacetInfo)o;
                return this.sizeInt == sfi.sizeInt && this.racialSizeInt == sfi.racialSizeInt && this.sizeAdj.equals(this.sizeAdj);
            }
            return false;
        }
    }
}

