/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.list.ClassSpellList;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;

public class KnownSpellIdentifier
extends ConcretePrereqObject {
    private final CDOMReference<Spell> ref;
    private final Integer spellLevel;

    public KnownSpellIdentifier(CDOMReference<Spell> spellRef, Integer levelLimit) {
        if (spellRef == null) {
            throw new IllegalArgumentException("Known Spell Identifier cannot have null spell reference");
        }
        if (levelLimit != null && levelLimit < 0) {
            throw new IllegalArgumentException("Known Spell Identifier level limit cannot be negative");
        }
        this.ref = spellRef;
        this.spellLevel = levelLimit;
    }

    public boolean matchesFilter(Spell spell, int testSpellLevel) {
        return !(this.ref != null && !this.ref.contains(spell) || this.spellLevel != null && testSpellLevel != this.spellLevel);
    }

    public CDOMReference<Spell> getSpellReference() {
        return this.ref;
    }

    public Integer getSpellLevel() {
        return this.spellLevel;
    }

    public Collection<Spell> getContainedSpells(PlayerCharacter pc, List<ClassSpellList> classSpellLists) {
        if (this.ref == null) {
            ArrayList<Spell> returnList = new ArrayList<Spell>();
            for (CDOMList cDOMList : classSpellLists) {
                returnList.addAll(pc.getSpellsIn(cDOMList, this.spellLevel));
            }
            return returnList;
        }
        ArrayList<Spell> spellList = new ArrayList<Spell>();
        for (Spell spell : this.ref.getContainedObjects()) {
            HashMapToList<CDOMList<Spell>, Integer> hml = pc.getSpellLevelInfo(spell);
            for (CDOMList cdomList : hml.getKeySet()) {
                if (!classSpellLists.contains(cdomList) || this.spellLevel != null && !hml.getListFor((Object)cdomList).contains(this.spellLevel)) continue;
                spellList.add(spell);
            }
        }
        return spellList;
    }

    public int hashCode() {
        return this.spellLevel == null ? this.ref.hashCode() : this.spellLevel * this.ref.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KnownSpellIdentifier)) {
            return false;
        }
        KnownSpellIdentifier other = (KnownSpellIdentifier)obj;
        if (this.spellLevel == null) {
            return other.spellLevel == null && this.ref.equals(other.ref);
        }
        if (this.ref == null) {
            return other.ref == null && this.spellLevel.equals(other.spellLevel);
        }
        return this.spellLevel.equals(other.spellLevel) && this.ref.equals(other.ref);
    }

    public String getLSTformat() {
        return this.ref.getLSTformat(false);
    }
}

