/*
 * Decompiled with CFR 0.152.
 */
package gmgen;

import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesDialog;
import gmgen.gui.PreferencesRootTreeNode;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.EditMenuCopySelectionMessage;
import gmgen.pluginmgr.messages.EditMenuCutSelectionMessage;
import gmgen.pluginmgr.messages.EditMenuPasteSelectionMessage;
import gmgen.pluginmgr.messages.FileMenuNewMessage;
import gmgen.pluginmgr.messages.FileMenuOpenMessage;
import gmgen.pluginmgr.messages.FileMenuSaveMessage;
import gmgen.pluginmgr.messages.GMGenBeingClosedMessage;
import gmgen.pluginmgr.messages.RequestAddPreferencesPanelMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.reflect.Method;
import java.util.EventObject;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.lang.SystemUtils;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.CommonMenuText;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.PluginManager;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.pluginmgr.messages.RequestFileOpenedMessageForCurrentlyOpenedPCsMessage;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenPropBundle;
import pcgen.util.Logging;
import pcgen.util.SwingWorker;

public final class GMGenSystem
extends JFrame
implements ChangeListener,
MenuListener,
ActionListener,
PCGenMessageHandler {
    private static final long serialVersionUID = -7372446160499882872L;
    private static final String MNU_SAVE = "mnuSave";
    private static final String MNU_OPEN = "mnuOpen";
    private static final String MNU_EXIT = "mnuClose";
    private static final String MNU_NEW = "mnuNew";
    private static final String MNU_CUT = "mnuCut";
    private static final String MNU_COPY = "mnuCopy";
    private static final String MNU_PASTE = "mnuPaste";
    private static final String SETTING_WINDOW_STATE = "WindowState";
    private static final String SETTING_WINDOW_HEIGHT = "WindowHeight";
    private static final String SETTING_WINDOW_WIDTH = "WindowWidth";
    private static final String WINDOW_Y = "WindowY";
    private static final String SETTING_WINDOW_X = "WindowX";
    private static final String SETTING_LOGGING_ON = "Logging.On";
    public static GMGenSystem inst;
    private GMGenSystemView theView;
    private static final boolean MAC_OS_X;
    public static final String APPLICATION_NAME = "GMGen";
    private JMenuBar systemMenuBar;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JMenu toolsMenu;
    private JMenuItem copyEditItem;
    private JMenuItem cutEditItem;
    private JMenuItem pasteEditItem;
    private JMenuItem preferencesEditItem;
    private JMenuItem exitFileItem;
    private JMenuItem versionToolsItem;
    public JMenuItem newFileItem;
    public JMenuItem openFileItem;
    public JMenuItem saveFileItem;
    private JSeparator editSeparator1;
    private JSeparator fileSeparator1;
    private JSeparator fileSeparator2;
    private JSeparator toolsSeparator1;
    private PreferencesRootTreeNode rootNode = new PreferencesRootTreeNode();
    private final PCGenMessageHandler messageHandler;
    private PluginManager pluginManager = PluginManager.getInstance();

    public GMGenSystem() {
        super(LanguageBundle.getFormattedString("in_gmgen_frameTitle", APPLICATION_NAME));
        this.messageHandler = this.pluginManager.getPostbox();
        new Renderer().start();
    }

    private void initialize() {
        if (MAC_OS_X) {
            this.initialiseMacOS();
        }
        Utility.setApplicationTitle(APPLICATION_NAME);
        inst = this;
        this.initLogger();
        this.createMenuBar();
        this.theView = new GMGenSystemView();
        this.pluginManager.addMember(this);
        PluginManager.getInstance().startAllPlugins();
        this.initComponents();
        this.initSettings();
        this.messageHandler.handleMessage(new RequestFileOpenedMessageForCurrentlyOpenedPCsMessage(this));
        this.messageHandler.handleMessage(new FocusOrStateChangeOccurredMessage(this, this.editMenu));
        inst.setVisible(true);
    }

    private void initialiseMacOS() {
        System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        System.setProperty("com.apple.mrj.application.live-resize", "false");
        System.setProperty("com.apple.macos.smallTabs", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", APPLICATION_NAME);
        this.macOSXRegistration();
    }

    public static String getVersion() {
        return PCGenPropBundle.getVersionNumber();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.openFileItem) {
            this.messageHandler.handleMessage(new FileMenuOpenMessage(this));
        } else if (event.getSource() == this.exitFileItem) {
            this.messageHandler.handleMessage(new GMGenBeingClosedMessage(this));
        } else if (event.getSource() == this.newFileItem) {
            this.messageHandler.handleMessage(new FileMenuNewMessage(this));
        } else if (event.getSource() == this.saveFileItem) {
            this.messageHandler.handleMessage(new FileMenuSaveMessage(this));
        } else if (event.getSource() == this.cutEditItem) {
            this.messageHandler.handleMessage(new EditMenuCutSelectionMessage(this));
        } else if (event.getSource() == this.copyEditItem) {
            this.messageHandler.handleMessage(new EditMenuCopySelectionMessage(this));
        } else if (event.getSource() == this.pasteEditItem) {
            this.messageHandler.handleMessage(new EditMenuPasteSelectionMessage(this));
        }
    }

    public void clearEditMenu() {
        this.editMenu.removeAll();
        if (!MAC_OS_X) {
            this.editMenu.add(this.editSeparator1);
            CommonMenuText.name(this.preferencesEditItem, "mnuToolsPreferences", new Object[0]);
            this.editMenu.add(this.preferencesEditItem);
            this.preferencesEditItem.setEnabled(true);
            ActionListener[] listenerArray = this.preferencesEditItem.getActionListeners();
            for (int i = 0; i < listenerArray.length; ++i) {
                this.preferencesEditItem.removeActionListener(listenerArray[i]);
            }
            this.preferencesEditItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GMGenSystem.this.mPreferencesActionPerformed(evt);
                }
            });
        }
    }

    public void exitFormMac() {
        this.setVisible(false);
    }

    @Override
    public void handleMessage(PCGenMessage message) {
        if (message instanceof RequestAddTabToGMGenMessage) {
            RequestAddTabToGMGenMessage tmessage = (RequestAddTabToGMGenMessage)message;
            Logging.debugPrint("Creating Tab " + GMGenSystemView.getTabPane().getTabCount());
            this.theView.insertPane(tmessage.getName(), tmessage.getPane(), GMGenSystemView.getTabPane().getTabCount());
        } else if (message instanceof RequestAddPreferencesPanelMessage) {
            RequestAddPreferencesPanelMessage pmessage = (RequestAddPreferencesPanelMessage)message;
            Logging.debugPrint("Creating Preferences Panel");
            this.rootNode.addPanel(pmessage.getName(), pmessage.getPrefsPanel());
        } else if (message instanceof AddMenuItemToGMGenToolsMenuMessage) {
            AddMenuItemToGMGenToolsMenuMessage mmessage = (AddMenuItemToGMGenToolsMenuMessage)message;
            this.toolsMenu.add(mmessage.getMenuItem());
        } else if (message instanceof GMGenBeingClosedMessage) {
            this.setCloseSettings();
            this.exitForm(null);
        }
    }

    public void handleToolsMenu() {
    }

    public void mPreferencesActionPerformedMac() {
        PreferencesDialog dialog = new PreferencesDialog((JFrame)this, true, this.rootNode);
        dialog.setVisible(true);
    }

    private void macOSXRegistration() {
        try {
            Class<?> osxAdapter = Class.forName("gmgen.util.OSXAdapter");
            Class[] defArgs = new Class[]{GMGenSystem.class};
            Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
            if (registerMethod != null) {
                Object[] args = new Object[]{this};
                registerMethod.invoke(osxAdapter, args);
            }
            defArgs[0] = Boolean.TYPE;
            Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
            if (prefsEnableMethod != null) {
                Object[] args = new Object[]{Boolean.TRUE};
                prefsEnableMethod.invoke(osxAdapter, args);
            }
        }
        catch (NoClassDefFoundError e) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
        }
        catch (ClassNotFoundException e) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
        }
        catch (Exception e) {
            System.err.println("Exception while loading the OSXAdapter = [" + e.getMessage() + "]");
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        if (e.getSource() == this.toolsMenu) {
            this.handleToolsMenu();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.stateUpdate(event);
    }

    private void stateUpdate(EventObject event) {
        this.newFileItem.setEnabled(false);
        this.openFileItem.setEnabled(false);
        this.saveFileItem.setEnabled(false);
        this.clearEditMenu();
        this.messageHandler.handleMessage(new FocusOrStateChangeOccurredMessage(this, this.editMenu));
    }

    private void setCloseSettings() {
        SettingsHandler.setGMGenOption(SETTING_WINDOW_X, this.getX());
        SettingsHandler.setGMGenOption(WINDOW_Y, this.getY());
        SettingsHandler.setGMGenOption(SETTING_WINDOW_WIDTH, this.getSize().width);
        SettingsHandler.setGMGenOption(SETTING_WINDOW_HEIGHT, this.getSize().height);
        if ((this.getExtendedState() & 6) != 0) {
            SettingsHandler.setGMGenOption(SETTING_WINDOW_STATE, 6);
        } else if ((this.getExtendedState() & 2) != 0) {
            SettingsHandler.setGMGenOption(SETTING_WINDOW_STATE, 2);
        } else if ((this.getExtendedState() & 4) != 0) {
            SettingsHandler.setGMGenOption(SETTING_WINDOW_STATE, 4);
        } else {
            SettingsHandler.setGMGenOption(SETTING_WINDOW_STATE, 0);
        }
    }

    private void setTabbedPanes() {
        try {
            GMGenSystemView.getTabPane().setSelectedIndex(0);
            this.theView.showPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createMenuBar() {
        this.systemMenuBar = new JMenuBar();
        this.createFileMenu();
        this.createEditMenu();
        this.createToolsMenu();
        this.setJMenuBar(this.systemMenuBar);
        this.setDefaultEnablementOfMenuItems();
        this.pack();
    }

    private void setDefaultEnablementOfMenuItems() {
        this.openFileItem.setEnabled(true);
        this.saveFileItem.setEnabled(false);
        this.newFileItem.setEnabled(false);
        this.cutEditItem.setEnabled(false);
        this.copyEditItem.setEnabled(false);
        this.pasteEditItem.setEnabled(false);
        this.preferencesEditItem.setEnabled(true);
        this.versionToolsItem.setEnabled(false);
    }

    private void createToolsMenu() {
        this.toolsMenu = new JMenu();
        this.toolsSeparator1 = new JSeparator();
        this.versionToolsItem = new JMenuItem();
        CommonMenuText.name(this.toolsMenu, "mnuTools", new Object[0]);
        this.toolsMenu.addMenuListener(this);
        CommonMenuText.name(this.versionToolsItem, "mnuGetNew", new Object[0]);
        this.toolsMenu.add(this.versionToolsItem);
        this.toolsMenu.add(this.toolsSeparator1);
        this.systemMenuBar.add(this.toolsMenu);
    }

    private void createEditMenu() {
        this.editMenu = new JMenu();
        this.cutEditItem = new JMenuItem();
        this.copyEditItem = new JMenuItem();
        this.pasteEditItem = new JMenuItem();
        this.editSeparator1 = new JSeparator();
        this.preferencesEditItem = new JMenuItem();
        CommonMenuText.name(this.editMenu, "mnuEdit", new Object[0]);
        this.editMenu.addMenuListener(this);
        CommonMenuText.name(this.cutEditItem, MNU_CUT, new Object[0]);
        this.editMenu.add(this.cutEditItem);
        CommonMenuText.name(this.copyEditItem, MNU_COPY, new Object[0]);
        this.editMenu.add(this.copyEditItem);
        CommonMenuText.name(this.pasteEditItem, MNU_PASTE, new Object[0]);
        this.editMenu.add(this.pasteEditItem);
        if (!MAC_OS_X) {
            this.editMenu.add(this.editSeparator1);
            CommonMenuText.name(this.preferencesEditItem, "mnuToolsPreferences", new Object[0]);
            this.editMenu.add(this.preferencesEditItem);
            this.preferencesEditItem.setEnabled(true);
            ActionListener[] listenerArray = this.preferencesEditItem.getActionListeners();
            for (int i = 0; i < listenerArray.length; ++i) {
                this.preferencesEditItem.removeActionListener(listenerArray[i]);
            }
            this.preferencesEditItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GMGenSystem.this.mPreferencesActionPerformed(evt);
                }
            });
        }
        this.systemMenuBar.add(this.editMenu);
    }

    private void createFileMenu() {
        this.fileMenu = new JMenu();
        this.newFileItem = new JMenuItem();
        this.openFileItem = new JMenuItem();
        this.fileSeparator1 = new JSeparator();
        this.saveFileItem = new JMenuItem();
        this.fileSeparator2 = new JSeparator();
        this.exitFileItem = new JMenuItem();
        CommonMenuText.name(this.fileMenu, "mnuFile", new Object[0]);
        this.fileMenu.addMenuListener(this);
        this.createFileNewMenuItem();
        this.createFileOpenMenuItem();
        this.fileMenu.add(this.fileSeparator1);
        this.createFileSaveMenuItem();
        if (!MAC_OS_X) {
            this.exitForMacOSX();
        }
        this.systemMenuBar.add(this.fileMenu);
    }

    private void createFileSaveMenuItem() {
        CommonMenuText.name(this.saveFileItem, MNU_SAVE, new Object[0]);
        this.fileMenu.add(this.saveFileItem);
        this.saveFileItem.addActionListener(this);
    }

    private void createFileOpenMenuItem() {
        CommonMenuText.name(this.openFileItem, MNU_OPEN, new Object[0]);
        this.fileMenu.add(this.openFileItem);
        this.openFileItem.addActionListener(this);
    }

    private void createFileNewMenuItem() {
        CommonMenuText.name(this.newFileItem, MNU_NEW, new Object[0]);
        this.newFileItem.addActionListener(this);
        this.fileMenu.add(this.newFileItem);
    }

    private void exitForMacOSX() {
        this.fileMenu.add(this.fileSeparator2);
        CommonMenuText.name(this.exitFileItem, MNU_EXIT, new Object[0]);
        this.fileMenu.add(this.exitFileItem);
        this.exitFileItem.addActionListener(this);
    }

    private void exitForm(WindowEvent event) {
        this.setVisible(false);
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTabbedPanes();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GMGenSystem.this.exitForm(evt);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                GMGenSystem.this.stateUpdate(e);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        GMGenSystemView.getTabPane().addChangeListener(this);
        this.getContentPane().add((Component)this.theView, "Center");
        this.setIconImage(Icons.gmgen_icon.getImageIcon().getImage());
    }

    private void initLogger() {
        boolean logging = SettingsHandler.getGMGenOption(SETTING_LOGGING_ON, false);
        LogUtilities.inst().setLogging(logging);
    }

    private void initSettings() {
        int iWinX = SettingsHandler.getGMGenOption(SETTING_WINDOW_X, 0);
        int iWinY = SettingsHandler.getGMGenOption(WINDOW_Y, 0);
        this.setLocation(iWinX, iWinY);
        int iWinWidth = SettingsHandler.getGMGenOption(SETTING_WINDOW_WIDTH, 750);
        int iWinHeight = SettingsHandler.getGMGenOption(SETTING_WINDOW_HEIGHT, 580);
        this.setSize(iWinWidth, iWinHeight);
        int windowState = SettingsHandler.getGMGenOption(SETTING_WINDOW_STATE, 0);
        if (windowState != 0) {
            this.setExtendedState(windowState);
        }
    }

    private void mPreferencesActionPerformed(ActionEvent event) {
        PreferencesDialog dialog = new PreferencesDialog((JFrame)this, true, this.rootNode);
        dialog.setVisible(true);
    }

    static {
        MAC_OS_X = SystemUtils.IS_OS_MAC_OSX;
    }

    private class Renderer
    extends SwingWorker {
        private Renderer() {
        }

        @Override
        public Object construct() {
            return "";
        }

        @Override
        public void finished() {
            GMGenSystem.this.initialize();
        }
    }
}

