/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import java.util.StringTokenizer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreLevelParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"LEVEL"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        StringTokenizer tok = new StringTokenizer(formula, ",");
        Prerequisite maxPrereq = new Prerequisite();
        Prerequisite minPrereq = new Prerequisite();
        boolean hasMin = false;
        boolean hasMax = false;
        while (tok.hasMoreTokens()) {
            String value = tok.nextToken();
            String[] vals = value.split("=");
            if (vals.length != 2) {
                throw new PersistenceLayerException("PRELEVEL must be either 'MIN=x', 'MAX=y' or 'MIN=x,MAX=y' where 'x' and 'y' are integers. '" + formula + "' is not valid. ");
            }
            String token = vals[0];
            String hdVal = vals[1];
            try {
                Integer.parseInt(hdVal);
            }
            catch (NumberFormatException nfe) {
                throw new PersistenceLayerException("PRELEVEL must be either 'MIN=x', 'MAX=y' or 'MIN=x,MAX=y' where 'x' and 'y' are integers. '" + formula + "' is not valid: " + hdVal + " is not an integer");
            }
            if (token.equals("MIN")) {
                minPrereq.setKind("level");
                minPrereq.setOperator(PrerequisiteOperator.GTEQ);
                minPrereq.setOperand(hdVal);
                hasMin = true;
            }
            if (!token.equals("MAX")) continue;
            maxPrereq.setKind("level");
            maxPrereq.setOperator(PrerequisiteOperator.LTEQ);
            maxPrereq.setOperand(hdVal);
            hasMax = true;
        }
        if (hasMin && hasMax) {
            prereq.setKind(null);
            prereq.setOperand("2");
            prereq.addPrerequisite(minPrereq);
            prereq.addPrerequisite(maxPrereq);
        } else if (hasMin) {
            prereq = minPrereq;
        } else if (hasMax) {
            prereq = maxPrereq;
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }
}

