/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AltcritrangeToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "ALTCRITRANGE";
    }

    public ParseResult parseToken(LoadContext context, Equipment eq, String value) {
        try {
            Integer cr = Integer.valueOf(value);
            if (cr < 0) {
                return new ParseResult.Fail(this.getTokenName() + " cannot be < 0", context);
            }
            context.getObjectContext().put((CDOMObject)eq.getEquipmentHead(2), IntegerKey.CRIT_RANGE, cr);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer. " + "Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
    }

    public String[] unparse(LoadContext context, Equipment eq) {
        EquipmentHead head = eq.getEquipmentHeadReference(2);
        if (head == null) {
            return null;
        }
        Integer mult = context.getObjectContext().getInteger((CDOMObject)head, IntegerKey.CRIT_RANGE);
        if (mult == null) {
            return null;
        }
        if (mult < 0) {
            context.addWriteMessage(this.getTokenName() + " cannot be negative: " + mult);
            return null;
        }
        return new String[]{mult.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

