/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreSkillSitTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) {
        CharacterDisplay display = character.getDisplay();
        int requiredRanks = Integer.parseInt(prereq.getOperand());
        String requiredSkill = prereq.getCategoryName();
        String situation = prereq.getKey();
        Map<Skill, Set<Skill>> serveAsSkills = this.getImitators(display);
        int runningTotal = 0;
        boolean foundMatch = false;
        boolean foundSkill = false;
        for (Skill aSkill : display.getSkillSet()) {
            String aSkillKey = aSkill.getKeyName().toUpperCase();
            if (aSkillKey.equals(requiredSkill)) {
                foundMatch = true;
                foundSkill = true;
                runningTotal = this.getRunningTotal(aSkill, character, prereq, foundMatch, runningTotal, requiredRanks, situation);
            }
            if (prereq.isCountMultiples() || prereq.isTotalValues()) {
                foundMatch = false;
            }
            if (!foundMatch) continue;
            break;
        }
        if (!foundSkill) {
            block1: for (Skill mock : serveAsSkills.keySet()) {
                Set<Skill> targets = serveAsSkills.get(mock);
                for (Skill target : targets) {
                    if (foundSkill) continue block1;
                    String aSkillKey = target.getKeyName().toUpperCase();
                    if (!aSkillKey.equals(requiredSkill)) continue;
                    foundSkill = true;
                    foundMatch = true;
                    int theTotal = this.getRunningTotal(mock, character, prereq, foundMatch, runningTotal, requiredRanks, situation);
                    runningTotal += theTotal;
                }
            }
        }
        if (!foundSkill && prereq.getOperator() == PrerequisiteOperator.LT) {
            ++runningTotal;
        }
        return this.countedTotal(prereq, runningTotal);
    }

    private Map<Skill, Set<Skill>> getImitators(CharacterDisplay display) {
        HashMap<Skill, Set<Skill>> serveAsSkills = new HashMap<Skill, Set<Skill>>();
        HashSet skillSet = new HashSet(display.getSkillSet());
        for (Skill aSkill : skillSet) {
            HashSet servesAs = new HashSet();
            for (CDOMReference ref : aSkill.getSafeListFor(ListKey.SERVES_AS_SKILL)) {
                servesAs.addAll(ref.getContainedObjects());
            }
            if (servesAs.size() <= 0) continue;
            serveAsSkills.put(aSkill, servesAs);
        }
        return serveAsSkills;
    }

    public String kindHandled() {
        return "SKILLSIT";
    }

    public String toHtmlString(Prerequisite prereq) {
        String skillName = prereq.getKey();
        if (prereq.getSubKey() != null && !prereq.getSubKey().equals("")) {
            skillName = skillName + " (" + prereq.getSubKey() + ")";
        }
        String foo = LanguageBundle.getFormattedString((String)"PreSkill.toHtml", (Object[])new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand(), skillName});
        return foo;
    }

    private int getRunningTotal(Skill aSkill, PlayerCharacter character, Prerequisite prereq, boolean foundMatch, int runningTotal, int requiredRanks, String situation) {
        if (foundMatch) {
            int rank = SkillRankControl.getTotalRank((PlayerCharacter)character, (Skill)aSkill).intValue();
            rank = (int)((double)rank + character.getTotalBonusTo("SITUATION", aSkill.getKeyName() + "=" + situation));
            if (prereq.isTotalValues()) {
                runningTotal += rank;
            } else if (prereq.getOperator().compare(rank, requiredRanks) > 0) {
                ++runningTotal;
            }
        }
        return runningTotal;
    }
}

