/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.DoubleKeyMap;

public class TripleKeyMap<K1, K2, K3, V>
implements Cloneable {
    private final Class<? extends Map> thirdClass;
    private DoubleKeyMap<K1, K2, Map<K3, V>> map;

    public TripleKeyMap() {
        this.thirdClass = HashMap.class;
        this.map = new DoubleKeyMap(HashMap.class, HashMap.class);
    }

    public TripleKeyMap(Class<? extends Map> cl1, Class<? extends Map> cl2, Class<? extends Map> cl3) {
        this.map = new DoubleKeyMap(cl1, cl2);
        if (cl3 == null) {
            throw new IllegalArgumentException("Third underlying Class cannot be null for TripleKeyMap");
        }
        this.thirdClass = cl3;
        this.createLocalMap();
    }

    public V put(K1 key1, K2 key2, K3 key3, V value) {
        Map<K3, V> localMap = this.map.get(key1, key2);
        if (localMap == null) {
            localMap = this.createLocalMap();
            this.map.put(key1, key2, localMap);
        }
        return localMap.put(key3, value);
    }

    public V get(K1 key1, K2 key2, K3 key3) {
        Map<K3, V> localMap = this.map.get(key1, key2);
        if (localMap == null) {
            return null;
        }
        return localMap.get(key3);
    }

    public boolean containsKey(K1 key1, K2 key2, K3 key3) {
        Map<K3, V> localMap = this.map.get(key1, key2);
        if (localMap == null) {
            return false;
        }
        return localMap.containsKey(key3);
    }

    public V remove(K1 key1, K2 key2, K3 key3) {
        Map<K3, V> localMap = this.map.get(key1, key2);
        if (localMap == null) {
            return null;
        }
        V removed = localMap.remove(key3);
        if (localMap.isEmpty()) {
            this.map.remove(key1, key2);
        }
        return removed;
    }

    public Set<K1> getKeySet() {
        return this.map.getKeySet();
    }

    public Set<K2> getSecondaryKeySet(K1 key1) {
        return this.map.getSecondaryKeySet(key1);
    }

    public Set<K3> getTertiaryKeySet(K1 key1, K2 key2) {
        Map<K3, V> localMap = this.map.get(key1, key2);
        if (localMap == null) {
            return Collections.emptySet();
        }
        return new HashSet<K3>(localMap.keySet());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int firstKeyCount() {
        return this.map.primaryKeyCount();
    }

    public TripleKeyMap<K1, K2, K3, V> clone() throws CloneNotSupportedException {
        TripleKeyMap tkm = (TripleKeyMap)super.clone();
        tkm.map = new DoubleKeyMap();
        for (K1 key1 : this.map.getKeySet()) {
            for (K2 key2 : this.map.getSecondaryKeySet(key1)) {
                Map<K3, V> local = this.map.get(key1, key2);
                for (Map.Entry<K3, V> me : local.entrySet()) {
                    tkm.put(key1, key2, me.getKey(), me.getValue());
                }
            }
        }
        return tkm;
    }

    public Set<V> values(K1 key1, K2 key2) {
        Map<K3, V> localMap = this.map.get(key1, key2);
        if (localMap == null) {
            return Collections.emptySet();
        }
        return new HashSet<V>(localMap.values());
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TripleKeyMap && this.map.equals(((TripleKeyMap)obj).map);
    }

    private Map<K3, V> createLocalMap() {
        try {
            return this.thirdClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class for TripleKeyMap must possess a zero-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class for TripleKeyMap must possess a public zero-argument constructor", e);
        }
    }
}

