# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.Container do
  @moduledoc "An OCI-compatible container, also known as a Docker container."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  @derive Dagger.Sync
  defstruct [:selection, :client]

  (
    @doc "Turn the container into a Service.\n\nBe sure to set any exposed ports before this conversion."
    @spec as_service(t()) :: Dagger.Service.t()
    def as_service(%__MODULE__{} = container) do
      selection = select(container.selection, "asService")
      %Dagger.Service{selection: selection, client: container.client}
    end
  )

  (
    @doc "Returns a File representing the container serialized to a tarball.\n\n\n\n## Optional Arguments\n\n* `platform_variants` - Identifiers for other platform specific containers.\n\nUsed for multi-platform images.\n* `forced_compression` - Force each layer of the image to use the specified compression algorithm.\n\nIf this is unset, then if a layer already has a compressed blob in the engine's cache, that will be used (this can result in a mix of compression algorithms for different layers). If this is unset and a layer has no compressed blob in the engine's cache, then it will be compressed using Gzip.\n* `media_types` - Use the specified media types for the image's layers.\n\nDefaults to OCI, which is largely compatible with most recent container runtimes, but Docker may be needed for older runtimes without OCI support."
    @spec as_tarball(t(), keyword()) :: Dagger.File.t()
    def as_tarball(%__MODULE__{} = container, optional_args \\ []) do
      selection = select(container.selection, "asTarball")

      selection =
        if is_nil(optional_args[:platform_variants]) do
          selection
        else
          ids =
            optional_args[:platform_variants]
            |> Enum.map(fn value ->
              {:ok, id} = Dagger.Container.id(value)
              id
            end)

          arg(selection, "platformVariants", ids)
        end

      selection =
        if is_nil(optional_args[:forced_compression]) do
          selection
        else
          arg(selection, "forcedCompression", optional_args[:forced_compression])
        end

      selection =
        if is_nil(optional_args[:media_types]) do
          selection
        else
          arg(selection, "mediaTypes", optional_args[:media_types])
        end

      %Dagger.File{selection: selection, client: container.client}
    end
  )

  (
    @doc "Initializes this container from a Dockerfile build.\n\n## Required Arguments\n\n* `context` - Directory context used by the Dockerfile.\n\n## Optional Arguments\n\n* `dockerfile` - Path to the Dockerfile to use.\n* `target` - Target build stage to build.\n* `build_args` - Additional build arguments.\n* `secrets` - Secrets to pass to the build.\n\nThey will be mounted at /run/secrets/[secret-name] in the build container\n\nThey can be accessed in the Dockerfile using the \"secret\" mount type and mount path /run/secrets/[secret-name], e.g. RUN --mount=type=secret,id=my-secret curl http://example.com?token=$(cat /run/secrets/my-secret)"
    @spec build(t(), Dagger.Directory.t(), keyword()) :: Dagger.Container.t()
    def build(%__MODULE__{} = container, context, optional_args \\ []) do
      selection = select(container.selection, "build")

      (
        {:ok, id} = Dagger.Directory.id(context)
        selection = arg(selection, "context", id)
      )

      selection =
        if is_nil(optional_args[:dockerfile]) do
          selection
        else
          arg(selection, "dockerfile", optional_args[:dockerfile])
        end

      selection =
        if is_nil(optional_args[:target]) do
          selection
        else
          arg(selection, "target", optional_args[:target])
        end

      selection =
        if is_nil(optional_args[:build_args]) do
          selection
        else
          arg(selection, "buildArgs", optional_args[:build_args])
        end

      selection =
        if is_nil(optional_args[:secrets]) do
          selection
        else
          ids =
            optional_args[:secrets]
            |> Enum.map(fn value ->
              {:ok, id} = Dagger.Secret.id(value)
              id
            end)

          arg(selection, "secrets", ids)
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves default arguments for future commands."
    @spec default_args(t()) :: {:ok, [Dagger.String.t()]} | {:error, term()}
    def default_args(%__MODULE__{} = container) do
      selection = select(container.selection, "defaultArgs")
      execute(selection, container.client)
    end
  )

  (
    @doc "Retrieves a directory at the given path.\n\nMounts are included.\n\n## Required Arguments\n\n* `path` - The path of the directory to retrieve (e.g., \"./src\")."
    @spec directory(t(), Dagger.String.t()) :: Dagger.Directory.t()
    def directory(%__MODULE__{} = container, path) do
      selection = select(container.selection, "directory")
      selection = arg(selection, "path", path)
      %Dagger.Directory{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves entrypoint to be prepended to the arguments of all commands."
    @spec entrypoint(t()) :: {:ok, [Dagger.String.t()]} | {:error, term()}
    def entrypoint(%__MODULE__{} = container) do
      selection = select(container.selection, "entrypoint")
      execute(selection, container.client)
    end
  )

  (
    @doc "Retrieves the value of the specified environment variable.\n\n## Required Arguments\n\n* `name` - The name of the environment variable to retrieve (e.g., \"PATH\")."
    @spec env_variable(t(), Dagger.String.t()) ::
            {:ok, Dagger.String.t() | nil} | {:error, term()}
    def env_variable(%__MODULE__{} = container, name) do
      selection = select(container.selection, "envVariable")
      selection = arg(selection, "name", name)
      execute(selection, container.client)
    end
  )

  (
    @doc "Retrieves the list of environment variables passed to commands."
    @spec env_variables(t()) :: {:ok, [Dagger.EnvVariable.t()]} | {:error, term()}
    def env_variables(%__MODULE__{} = container) do
      selection = select(container.selection, "envVariables")
      selection = select(selection, "id name value")

      with {:ok, data} <- execute(selection, container.client) do
        {:ok,
         data
         |> Enum.map(fn value ->
           elem_selection = Dagger.QueryBuilder.Selection.query()
           elem_selection = select(elem_selection, "loadEnvVariableFromID")
           elem_selection = arg(elem_selection, "id", value["id"])
           %Dagger.EnvVariable{selection: elem_selection, client: container.client}
         end)}
      end
    end
  )

  (
    @doc "EXPERIMENTAL API! Subject to change/removal at any time.\n\nConfigures all available GPUs on the host to be accessible to this container.\n\nThis currently works for Nvidia devices only."
    @spec experimental_with_all_gp_us(t()) :: Dagger.Container.t()
    def experimental_with_all_gp_us(%__MODULE__{} = container) do
      selection = select(container.selection, "experimentalWithAllGPUs")
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "EXPERIMENTAL API! Subject to change/removal at any time.\n\nConfigures the provided list of devices to be accesible to this container.\n\nThis currently works for Nvidia devices only.\n\n## Required Arguments\n\n* `devices` - List of devices to be accessible to this container."
    @spec experimental_with_gpu(t(), [Dagger.String.t()]) :: Dagger.Container.t()
    def experimental_with_gpu(%__MODULE__{} = container, devices) do
      selection = select(container.selection, "experimentalWithGPU")
      selection = arg(selection, "devices", devices)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Writes the container as an OCI tarball to the destination file path on the host.\n\nReturn true on success.\n\nIt can also export platform variants.\n\n## Required Arguments\n\n* `path` - Host's destination path (e.g., \"./tarball\").\n\nPath can be relative to the engine's workdir or absolute.\n\n## Optional Arguments\n\n* `platform_variants` - Identifiers for other platform specific containers.\n\nUsed for multi-platform image.\n* `forced_compression` - Force each layer of the exported image to use the specified compression algorithm.\n\nIf this is unset, then if a layer already has a compressed blob in the engine's cache, that will be used (this can result in a mix of compression algorithms for different layers). If this is unset and a layer has no compressed blob in the engine's cache, then it will be compressed using Gzip.\n* `media_types` - Use the specified media types for the exported image's layers.\n\nDefaults to OCI, which is largely compatible with most recent container runtimes, but Docker may be needed for older runtimes without OCI support."
    @spec export(t(), Dagger.String.t(), keyword()) ::
            {:ok, Dagger.Boolean.t()} | {:error, term()}
    def export(%__MODULE__{} = container, path, optional_args \\ []) do
      selection = select(container.selection, "export")
      selection = arg(selection, "path", path)

      selection =
        if is_nil(optional_args[:platform_variants]) do
          selection
        else
          ids =
            optional_args[:platform_variants]
            |> Enum.map(fn value ->
              {:ok, id} = Dagger.Container.id(value)
              id
            end)

          arg(selection, "platformVariants", ids)
        end

      selection =
        if is_nil(optional_args[:forced_compression]) do
          selection
        else
          arg(selection, "forcedCompression", optional_args[:forced_compression])
        end

      selection =
        if is_nil(optional_args[:media_types]) do
          selection
        else
          arg(selection, "mediaTypes", optional_args[:media_types])
        end

      execute(selection, container.client)
    end
  )

  (
    @doc "Retrieves the list of exposed ports.\n\nThis includes ports already exposed by the image, even if not explicitly added with dagger."
    @spec exposed_ports(t()) :: {:ok, [Dagger.Port.t()]} | {:error, term()}
    def exposed_ports(%__MODULE__{} = container) do
      selection = select(container.selection, "exposedPorts")
      selection = select(selection, "description experimentalSkipHealthcheck id port protocol")

      with {:ok, data} <- execute(selection, container.client) do
        {:ok,
         data
         |> Enum.map(fn value ->
           elem_selection = Dagger.QueryBuilder.Selection.query()
           elem_selection = select(elem_selection, "loadPortFromID")
           elem_selection = arg(elem_selection, "id", value["id"])
           %Dagger.Port{selection: elem_selection, client: container.client}
         end)}
      end
    end
  )

  (
    @doc "Retrieves a file at the given path.\n\nMounts are included.\n\n## Required Arguments\n\n* `path` - The path of the file to retrieve (e.g., \"./README.md\")."
    @spec file(t(), Dagger.String.t()) :: Dagger.File.t()
    def file(%__MODULE__{} = container, path) do
      selection = select(container.selection, "file")
      selection = arg(selection, "path", path)
      %Dagger.File{selection: selection, client: container.client}
    end
  )

  (
    @doc "Initializes this container from a pulled base image.\n\n## Required Arguments\n\n* `address` - Image's address from its registry.\n\nFormatted as [host]/[user]/[repo]:[tag] (e.g., \"docker.io/dagger/dagger:main\")."
    @spec from(t(), Dagger.String.t()) :: Dagger.Container.t()
    def from(%__MODULE__{} = container, address) do
      selection = select(container.selection, "from")
      selection = arg(selection, "address", address)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "A unique identifier for this Container."
    @spec id(t()) :: {:ok, Dagger.ContainerID.t()} | {:error, term()}
    def id(%__MODULE__{} = container) do
      selection = select(container.selection, "id")
      execute(selection, container.client)
    end
  )

  (
    @doc "The unique image reference which can only be retrieved immediately after the 'Container.From' call."
    @spec image_ref(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def image_ref(%__MODULE__{} = container) do
      selection = select(container.selection, "imageRef")
      execute(selection, container.client)
    end
  )

  (
    @doc "Reads the container from an OCI tarball.\n\n## Required Arguments\n\n* `source` - File to read the container from.\n\n## Optional Arguments\n\n* `tag` - Identifies the tag to import from the archive, if the archive bundles multiple tags."
    @spec import(t(), Dagger.File.t(), keyword()) :: Dagger.Container.t()
    def import(%__MODULE__{} = container, source, optional_args \\ []) do
      selection = select(container.selection, "import")

      (
        {:ok, id} = Dagger.File.id(source)
        selection = arg(selection, "source", id)
      )

      selection =
        if is_nil(optional_args[:tag]) do
          selection
        else
          arg(selection, "tag", optional_args[:tag])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves the value of the specified label.\n\n## Required Arguments\n\n* `name` - The name of the label (e.g., \"org.opencontainers.artifact.created\")."
    @spec label(t(), Dagger.String.t()) :: {:ok, Dagger.String.t() | nil} | {:error, term()}
    def label(%__MODULE__{} = container, name) do
      selection = select(container.selection, "label")
      selection = arg(selection, "name", name)
      execute(selection, container.client)
    end
  )

  (
    @doc "Retrieves the list of labels passed to container."
    @spec labels(t()) :: {:ok, [Dagger.Label.t()]} | {:error, term()}
    def labels(%__MODULE__{} = container) do
      selection = select(container.selection, "labels")
      selection = select(selection, "id name value")

      with {:ok, data} <- execute(selection, container.client) do
        {:ok,
         data
         |> Enum.map(fn value ->
           elem_selection = Dagger.QueryBuilder.Selection.query()
           elem_selection = select(elem_selection, "loadLabelFromID")
           elem_selection = arg(elem_selection, "id", value["id"])
           %Dagger.Label{selection: elem_selection, client: container.client}
         end)}
      end
    end
  )

  (
    @doc "Retrieves the list of paths where a directory is mounted."
    @spec mounts(t()) :: {:ok, [Dagger.String.t()]} | {:error, term()}
    def mounts(%__MODULE__{} = container) do
      selection = select(container.selection, "mounts")
      execute(selection, container.client)
    end
  )

  (
    @doc "Creates a named sub-pipeline.\n\n## Required Arguments\n\n* `name` - Name of the sub-pipeline.\n\n## Optional Arguments\n\n* `description` - Description of the sub-pipeline.\n* `labels` - Labels to apply to the sub-pipeline."
    @spec pipeline(t(), Dagger.String.t(), keyword()) :: Dagger.Container.t()
    def pipeline(%__MODULE__{} = container, name, optional_args \\ []) do
      selection = select(container.selection, "pipeline")
      selection = arg(selection, "name", name)

      selection =
        if is_nil(optional_args[:description]) do
          selection
        else
          arg(selection, "description", optional_args[:description])
        end

      selection =
        if is_nil(optional_args[:labels]) do
          selection
        else
          arg(selection, "labels", optional_args[:labels])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "The platform this container executes and publishes as."
    @spec platform(t()) :: {:ok, Dagger.Platform.t()} | {:error, term()}
    def platform(%__MODULE__{} = container) do
      selection = select(container.selection, "platform")
      execute(selection, container.client)
    end
  )

  (
    @doc "Publishes this container as a new image to the specified address.\n\nPublish returns a fully qualified ref.\n\nIt can also publish platform variants.\n\n## Required Arguments\n\n* `address` - Registry's address to publish the image to.\n\nFormatted as [host]/[user]/[repo]:[tag] (e.g. \"docker.io/dagger/dagger:main\").\n\n## Optional Arguments\n\n* `platform_variants` - Identifiers for other platform specific containers.\n\nUsed for multi-platform image.\n* `forced_compression` - Force each layer of the published image to use the specified compression algorithm.\n\nIf this is unset, then if a layer already has a compressed blob in the engine's cache, that will be used (this can result in a mix of compression algorithms for different layers). If this is unset and a layer has no compressed blob in the engine's cache, then it will be compressed using Gzip.\n* `media_types` - Use the specified media types for the published image's layers.\n\nDefaults to OCI, which is largely compatible with most recent registries, but Docker may be needed for older registries without OCI support."
    @spec publish(t(), Dagger.String.t(), keyword()) ::
            {:ok, Dagger.String.t()} | {:error, term()}
    def publish(%__MODULE__{} = container, address, optional_args \\ []) do
      selection = select(container.selection, "publish")
      selection = arg(selection, "address", address)

      selection =
        if is_nil(optional_args[:platform_variants]) do
          selection
        else
          ids =
            optional_args[:platform_variants]
            |> Enum.map(fn value ->
              {:ok, id} = Dagger.Container.id(value)
              id
            end)

          arg(selection, "platformVariants", ids)
        end

      selection =
        if is_nil(optional_args[:forced_compression]) do
          selection
        else
          arg(selection, "forcedCompression", optional_args[:forced_compression])
        end

      selection =
        if is_nil(optional_args[:media_types]) do
          selection
        else
          arg(selection, "mediaTypes", optional_args[:media_types])
        end

      execute(selection, container.client)
    end
  )

  (
    @doc "Retrieves this container's root filesystem. Mounts are not included."
    @spec rootfs(t()) :: Dagger.Directory.t()
    def rootfs(%__MODULE__{} = container) do
      selection = select(container.selection, "rootfs")
      %Dagger.Directory{selection: selection, client: container.client}
    end
  )

  (
    @doc "Return an interactive terminal for this container using its configured shell if not overridden by args (or sh as a fallback default).\n\n\n\n## Optional Arguments\n\n* `args` - If set, override the container's default shell and invoke these arguments instead."
    @spec shell(t(), keyword()) :: Dagger.Terminal.t()
    def shell(%__MODULE__{} = container, optional_args \\ []) do
      selection = select(container.selection, "shell")

      selection =
        if is_nil(optional_args[:args]) do
          selection
        else
          arg(selection, "args", optional_args[:args])
        end

      %Dagger.Terminal{selection: selection, client: container.client}
    end
  )

  (
    @doc "The error stream of the last executed command.\n\nWill execute default command if none is set, or error if there's no default."
    @spec stderr(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def stderr(%__MODULE__{} = container) do
      selection = select(container.selection, "stderr")
      execute(selection, container.client)
    end
  )

  (
    @doc "The output stream of the last executed command.\n\nWill execute default command if none is set, or error if there's no default."
    @spec stdout(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def stdout(%__MODULE__{} = container) do
      selection = select(container.selection, "stdout")
      execute(selection, container.client)
    end
  )

  (
    @doc "Forces evaluation of the pipeline in the engine.\n\nIt doesn't run the default command if no exec has been set."
    @spec sync(t()) :: {:ok, Dagger.ContainerID.t()} | {:error, term()}
    def sync(%__MODULE__{} = container) do
      selection = select(container.selection, "sync")
      execute(selection, container.client)
    end
  )

  (
    @doc "Retrieves the user to be set for all commands."
    @spec user(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def user(%__MODULE__{} = container) do
      selection = select(container.selection, "user")
      execute(selection, container.client)
    end
  )

  (
    @doc "Configures default arguments for future commands.\n\n## Required Arguments\n\n* `args` - Arguments to prepend to future executions (e.g., [\"-v\", \"--no-cache\"])."
    @spec with_default_args(t(), [Dagger.String.t()]) :: Dagger.Container.t()
    def with_default_args(%__MODULE__{} = container, args) do
      selection = select(container.selection, "withDefaultArgs")
      selection = arg(selection, "args", args)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Set the default command to invoke for the \"shell\" API.\n\n## Required Arguments\n\n* `args` - The args of the command to set the default shell to."
    @spec with_default_shell(t(), [Dagger.String.t()]) :: Dagger.Container.t()
    def with_default_shell(%__MODULE__{} = container, args) do
      selection = select(container.selection, "withDefaultShell")
      selection = arg(selection, "args", args)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a directory written at the given path.\n\n## Required Arguments\n\n* `path` - Location of the written directory (e.g., \"/tmp/directory\").\n* `directory` - Identifier of the directory to write\n\n## Optional Arguments\n\n* `exclude` - Patterns to exclude in the written directory (e.g. [\"node_modules/**\", \".gitignore\", \".git/\"]).\n* `include` - Patterns to include in the written directory (e.g. [\"*.go\", \"go.mod\", \"go.sum\"]).\n* `owner` - A user:group to set for the directory and its contents.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user."
    @spec with_directory(t(), Dagger.String.t(), Dagger.Directory.t(), keyword()) ::
            Dagger.Container.t()
    def with_directory(%__MODULE__{} = container, path, directory, optional_args \\ []) do
      selection = select(container.selection, "withDirectory")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.Directory.id(directory)
        selection = arg(selection, "directory", id)
      )

      selection =
        if is_nil(optional_args[:exclude]) do
          selection
        else
          arg(selection, "exclude", optional_args[:exclude])
        end

      selection =
        if is_nil(optional_args[:include]) do
          selection
        else
          arg(selection, "include", optional_args[:include])
        end

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container but with a different command entrypoint.\n\n## Required Arguments\n\n* `args` - Entrypoint to use for future executions (e.g., [\"go\", \"run\"]).\n\n## Optional Arguments\n\n* `keep_default_args` - Don't remove the default arguments when setting the entrypoint."
    @spec with_entrypoint(t(), [Dagger.String.t()], keyword()) :: Dagger.Container.t()
    def with_entrypoint(%__MODULE__{} = container, args, optional_args \\ []) do
      selection = select(container.selection, "withEntrypoint")
      selection = arg(selection, "args", args)

      selection =
        if is_nil(optional_args[:keep_default_args]) do
          selection
        else
          arg(selection, "keepDefaultArgs", optional_args[:keep_default_args])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus the given environment variable.\n\n## Required Arguments\n\n* `name` - The name of the environment variable (e.g., \"HOST\").\n* `value` - The value of the environment variable. (e.g., \"localhost\").\n\n## Optional Arguments\n\n* `expand` - Replace `${VAR}` or `$VAR` in the value according to the current environment variables defined in the container (e.g., \"/opt/bin:$PATH\")."
    @spec with_env_variable(t(), Dagger.String.t(), Dagger.String.t(), keyword()) ::
            Dagger.Container.t()
    def with_env_variable(%__MODULE__{} = container, name, value, optional_args \\ []) do
      selection = select(container.selection, "withEnvVariable")
      selection = arg(selection, "name", name)
      selection = arg(selection, "value", value)

      selection =
        if is_nil(optional_args[:expand]) do
          selection
        else
          arg(selection, "expand", optional_args[:expand])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container after executing the specified command inside it.\n\n## Required Arguments\n\n* `args` - Command to run instead of the container's default command (e.g., [\"run\", \"main.go\"]).\n\nIf empty, the container's default command is used.\n\n## Optional Arguments\n\n* `skip_entrypoint` - If the container has an entrypoint, ignore it for args rather than using it to wrap them.\n* `stdin` - Content to write to the command's standard input before closing (e.g., \"Hello world\").\n* `redirect_stdout` - Redirect the command's standard output to a file in the container (e.g., \"/tmp/stdout\").\n* `redirect_stderr` - Redirect the command's standard error to a file in the container (e.g., \"/tmp/stderr\").\n* `experimental_privileged_nesting` - Provides dagger access to the executed command.\n\nDo not use this option unless you trust the command being executed; the command being executed WILL BE GRANTED FULL ACCESS TO YOUR HOST FILESYSTEM.\n* `insecure_root_capabilities` - Execute the command with all root capabilities. This is similar to running a command with \"sudo\" or executing \"docker run\" with the \"--privileged\" flag. Containerization does not provide any security guarantees when using this option. It should only be used when absolutely necessary and only with trusted commands."
    @spec with_exec(t(), [Dagger.String.t()], keyword()) :: Dagger.Container.t()
    def with_exec(%__MODULE__{} = container, args, optional_args \\ []) do
      selection = select(container.selection, "withExec")
      selection = arg(selection, "args", args)

      selection =
        if is_nil(optional_args[:skip_entrypoint]) do
          selection
        else
          arg(selection, "skipEntrypoint", optional_args[:skip_entrypoint])
        end

      selection =
        if is_nil(optional_args[:stdin]) do
          selection
        else
          arg(selection, "stdin", optional_args[:stdin])
        end

      selection =
        if is_nil(optional_args[:redirect_stdout]) do
          selection
        else
          arg(selection, "redirectStdout", optional_args[:redirect_stdout])
        end

      selection =
        if is_nil(optional_args[:redirect_stderr]) do
          selection
        else
          arg(selection, "redirectStderr", optional_args[:redirect_stderr])
        end

      selection =
        if is_nil(optional_args[:experimental_privileged_nesting]) do
          selection
        else
          arg(
            selection,
            "experimentalPrivilegedNesting",
            optional_args[:experimental_privileged_nesting]
          )
        end

      selection =
        if is_nil(optional_args[:insecure_root_capabilities]) do
          selection
        else
          arg(selection, "insecureRootCapabilities", optional_args[:insecure_root_capabilities])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Expose a network port.\n\nExposed ports serve two purposes:\n\n- For health checks and introspection, when running services\n\n- For setting the EXPOSE OCI field when publishing the container\n\n## Required Arguments\n\n* `port` - Port number to expose\n\n## Optional Arguments\n\n* `protocol` - Transport layer network protocol\n* `description` - Optional port description\n* `experimental_skip_healthcheck` - Skip the health check when run as a service."
    @spec with_exposed_port(t(), Dagger.Int.t(), keyword()) :: Dagger.Container.t()
    def with_exposed_port(%__MODULE__{} = container, port, optional_args \\ []) do
      selection = select(container.selection, "withExposedPort")
      selection = arg(selection, "port", port)

      selection =
        if is_nil(optional_args[:protocol]) do
          selection
        else
          arg(selection, "protocol", optional_args[:protocol])
        end

      selection =
        if is_nil(optional_args[:description]) do
          selection
        else
          arg(selection, "description", optional_args[:description])
        end

      selection =
        if is_nil(optional_args[:experimental_skip_healthcheck]) do
          selection
        else
          arg(
            selection,
            "experimentalSkipHealthcheck",
            optional_args[:experimental_skip_healthcheck]
          )
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus the contents of the given file copied to the given path.\n\n## Required Arguments\n\n* `path` - Location of the copied file (e.g., \"/tmp/file.txt\").\n* `source` - Identifier of the file to copy.\n\n## Optional Arguments\n\n* `permissions` - Permission given to the copied file (e.g., 0600).\n* `owner` - A user:group to set for the file.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user."
    @spec with_file(t(), Dagger.String.t(), Dagger.File.t(), keyword()) :: Dagger.Container.t()
    def with_file(%__MODULE__{} = container, path, source, optional_args \\ []) do
      selection = select(container.selection, "withFile")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.File.id(source)
        selection = arg(selection, "source", id)
      )

      selection =
        if is_nil(optional_args[:permissions]) do
          selection
        else
          arg(selection, "permissions", optional_args[:permissions])
        end

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Indicate that subsequent operations should be featured more prominently in the UI."
    @spec with_focus(t()) :: Dagger.Container.t()
    def with_focus(%__MODULE__{} = container) do
      selection = select(container.selection, "withFocus")
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus the given label.\n\n## Required Arguments\n\n* `name` - The name of the label (e.g., \"org.opencontainers.artifact.created\").\n* `value` - The value of the label (e.g., \"2023-01-01T00:00:00Z\")."
    @spec with_label(t(), Dagger.String.t(), Dagger.String.t()) :: Dagger.Container.t()
    def with_label(%__MODULE__{} = container, name, value) do
      selection = select(container.selection, "withLabel")
      selection = arg(selection, "name", name)
      selection = arg(selection, "value", value)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a cache volume mounted at the given path.\n\n## Required Arguments\n\n* `path` - Location of the cache directory (e.g., \"/cache/node_modules\").\n* `cache` - Identifier of the cache volume to mount.\n\n## Optional Arguments\n\n* `source` - Identifier of the directory to use as the cache volume's root.\n* `sharing` - Sharing mode of the cache volume.\n* `owner` - A user:group to set for the mounted cache directory.\n\nNote that this changes the ownership of the specified mount along with the initial filesystem provided by source (if any). It does not have any effect if/when the cache has already been created.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user."
    @spec with_mounted_cache(t(), Dagger.String.t(), Dagger.CacheVolume.t(), keyword()) ::
            Dagger.Container.t()
    def with_mounted_cache(%__MODULE__{} = container, path, cache, optional_args \\ []) do
      selection = select(container.selection, "withMountedCache")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.CacheVolume.id(cache)
        selection = arg(selection, "cache", id)
      )

      selection =
        if is_nil(optional_args[:source]) do
          selection
        else
          {:ok, id} = Dagger.Directory.id(optional_args[:source])
          arg(selection, "source", id)
        end

      selection =
        if is_nil(optional_args[:sharing]) do
          selection
        else
          arg(selection, "sharing", optional_args[:sharing])
        end

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a directory mounted at the given path.\n\n## Required Arguments\n\n* `path` - Location of the mounted directory (e.g., \"/mnt/directory\").\n* `source` - Identifier of the mounted directory.\n\n## Optional Arguments\n\n* `owner` - A user:group to set for the mounted directory and its contents.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user."
    @spec with_mounted_directory(t(), Dagger.String.t(), Dagger.Directory.t(), keyword()) ::
            Dagger.Container.t()
    def with_mounted_directory(%__MODULE__{} = container, path, source, optional_args \\ []) do
      selection = select(container.selection, "withMountedDirectory")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.Directory.id(source)
        selection = arg(selection, "source", id)
      )

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a file mounted at the given path.\n\n## Required Arguments\n\n* `path` - Location of the mounted file (e.g., \"/tmp/file.txt\").\n* `source` - Identifier of the mounted file.\n\n## Optional Arguments\n\n* `owner` - A user or user:group to set for the mounted file.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user."
    @spec with_mounted_file(t(), Dagger.String.t(), Dagger.File.t(), keyword()) ::
            Dagger.Container.t()
    def with_mounted_file(%__MODULE__{} = container, path, source, optional_args \\ []) do
      selection = select(container.selection, "withMountedFile")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.File.id(source)
        selection = arg(selection, "source", id)
      )

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a secret mounted into a file at the given path.\n\n## Required Arguments\n\n* `path` - Location of the secret file (e.g., \"/tmp/secret.txt\").\n* `source` - Identifier of the secret to mount.\n\n## Optional Arguments\n\n* `owner` - A user:group to set for the mounted secret.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user.\n* `mode` - Permission given to the mounted secret (e.g., 0600).\n\nThis option requires an owner to be set to be active."
    @spec with_mounted_secret(t(), Dagger.String.t(), Dagger.Secret.t(), keyword()) ::
            Dagger.Container.t()
    def with_mounted_secret(%__MODULE__{} = container, path, source, optional_args \\ []) do
      selection = select(container.selection, "withMountedSecret")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.Secret.id(source)
        selection = arg(selection, "source", id)
      )

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      selection =
        if is_nil(optional_args[:mode]) do
          selection
        else
          arg(selection, "mode", optional_args[:mode])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a temporary directory mounted at the given path.\n\n## Required Arguments\n\n* `path` - Location of the temporary directory (e.g., \"/tmp/temp_dir\")."
    @spec with_mounted_temp(t(), Dagger.String.t()) :: Dagger.Container.t()
    def with_mounted_temp(%__MODULE__{} = container, path) do
      selection = select(container.selection, "withMountedTemp")
      selection = arg(selection, "path", path)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a new file written at the given path.\n\n## Required Arguments\n\n* `path` - Location of the written file (e.g., \"/tmp/file.txt\").\n\n## Optional Arguments\n\n* `contents` - Content of the file to write (e.g., \"Hello world!\").\n* `permissions` - Permission given to the written file (e.g., 0600).\n* `owner` - A user:group to set for the file.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user."
    @spec with_new_file(t(), Dagger.String.t(), keyword()) :: Dagger.Container.t()
    def with_new_file(%__MODULE__{} = container, path, optional_args \\ []) do
      selection = select(container.selection, "withNewFile")
      selection = arg(selection, "path", path)

      selection =
        if is_nil(optional_args[:contents]) do
          selection
        else
          arg(selection, "contents", optional_args[:contents])
        end

      selection =
        if is_nil(optional_args[:permissions]) do
          selection
        else
          arg(selection, "permissions", optional_args[:permissions])
        end

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with a registry authentication for a given address.\n\n## Required Arguments\n\n* `address` - Registry's address to bind the authentication to.\n\nFormatted as [host]/[user]/[repo]:[tag] (e.g. docker.io/dagger/dagger:main).\n* `username` - The username of the registry's account (e.g., \"Dagger\").\n* `secret` - The API key, password or token to authenticate to this registry."
    @spec with_registry_auth(t(), Dagger.String.t(), Dagger.String.t(), Dagger.Secret.t()) ::
            Dagger.Container.t()
    def with_registry_auth(%__MODULE__{} = container, address, username, secret) do
      selection = select(container.selection, "withRegistryAuth")
      selection = arg(selection, "address", address)
      selection = arg(selection, "username", username)

      (
        {:ok, id} = Dagger.Secret.id(secret)
        selection = arg(selection, "secret", id)
      )

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves the container with the given directory mounted to /.\n\n## Required Arguments\n\n* `directory` - Directory to mount."
    @spec with_rootfs(t(), Dagger.Directory.t()) :: Dagger.Container.t()
    def with_rootfs(%__MODULE__{} = container, directory) do
      selection = select(container.selection, "withRootfs")

      (
        {:ok, id} = Dagger.Directory.id(directory)
        selection = arg(selection, "directory", id)
      )

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus an env variable containing the given secret.\n\n## Required Arguments\n\n* `name` - The name of the secret variable (e.g., \"API_SECRET\").\n* `secret` - The identifier of the secret value."
    @spec with_secret_variable(t(), Dagger.String.t(), Dagger.Secret.t()) :: Dagger.Container.t()
    def with_secret_variable(%__MODULE__{} = container, name, secret) do
      selection = select(container.selection, "withSecretVariable")
      selection = arg(selection, "name", name)

      (
        {:ok, id} = Dagger.Secret.id(secret)
        selection = arg(selection, "secret", id)
      )

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Establish a runtime dependency on a service.\n\nThe service will be started automatically when needed and detached when it is no longer needed, executing the default command if none is set.\n\nThe service will be reachable from the container via the provided hostname alias.\n\nThe service dependency will also convey to any files or directories produced by the container.\n\n## Required Arguments\n\n* `alias` - A name that can be used to reach the service from the container\n* `service` - Identifier of the service container"
    @spec with_service_binding(t(), Dagger.String.t(), Dagger.Service.t()) :: Dagger.Container.t()
    def with_service_binding(%__MODULE__{} = container, alias, service) do
      selection = select(container.selection, "withServiceBinding")
      selection = arg(selection, "alias", alias)

      (
        {:ok, id} = Dagger.Service.id(service)
        selection = arg(selection, "service", id)
      )

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container plus a socket forwarded to the given Unix socket path.\n\n## Required Arguments\n\n* `path` - Location of the forwarded Unix socket (e.g., \"/tmp/socket\").\n* `source` - Identifier of the socket to forward.\n\n## Optional Arguments\n\n* `owner` - A user:group to set for the mounted socket.\n\nThe user and group can either be an ID (1000:1000) or a name (foo:bar).\n\nIf the group is omitted, it defaults to the same as the user."
    @spec with_unix_socket(t(), Dagger.String.t(), Dagger.Socket.t(), keyword()) ::
            Dagger.Container.t()
    def with_unix_socket(%__MODULE__{} = container, path, source, optional_args \\ []) do
      selection = select(container.selection, "withUnixSocket")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.Socket.id(source)
        selection = arg(selection, "source", id)
      )

      selection =
        if is_nil(optional_args[:owner]) do
          selection
        else
          arg(selection, "owner", optional_args[:owner])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with a different command user.\n\n## Required Arguments\n\n* `name` - The user to set (e.g., \"root\")."
    @spec with_user(t(), Dagger.String.t()) :: Dagger.Container.t()
    def with_user(%__MODULE__{} = container, name) do
      selection = select(container.selection, "withUser")
      selection = arg(selection, "name", name)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with a different working directory.\n\n## Required Arguments\n\n* `path` - The path to set as the working directory (e.g., \"/app\")."
    @spec with_workdir(t(), Dagger.String.t()) :: Dagger.Container.t()
    def with_workdir(%__MODULE__{} = container, path) do
      selection = select(container.selection, "withWorkdir")
      selection = arg(selection, "path", path)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with unset default arguments for future commands."
    @spec without_default_args(t()) :: Dagger.Container.t()
    def without_default_args(%__MODULE__{} = container) do
      selection = select(container.selection, "withoutDefaultArgs")
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with an unset command entrypoint.\n\n\n\n## Optional Arguments\n\n* `keep_default_args` - Don't remove the default arguments when unsetting the entrypoint."
    @spec without_entrypoint(t(), keyword()) :: Dagger.Container.t()
    def without_entrypoint(%__MODULE__{} = container, optional_args \\ []) do
      selection = select(container.selection, "withoutEntrypoint")

      selection =
        if is_nil(optional_args[:keep_default_args]) do
          selection
        else
          arg(selection, "keepDefaultArgs", optional_args[:keep_default_args])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container minus the given environment variable.\n\n## Required Arguments\n\n* `name` - The name of the environment variable (e.g., \"HOST\")."
    @spec without_env_variable(t(), Dagger.String.t()) :: Dagger.Container.t()
    def without_env_variable(%__MODULE__{} = container, name) do
      selection = select(container.selection, "withoutEnvVariable")
      selection = arg(selection, "name", name)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Unexpose a previously exposed port.\n\n## Required Arguments\n\n* `port` - Port number to unexpose\n\n## Optional Arguments\n\n* `protocol` - Port protocol to unexpose"
    @spec without_exposed_port(t(), Dagger.Int.t(), keyword()) :: Dagger.Container.t()
    def without_exposed_port(%__MODULE__{} = container, port, optional_args \\ []) do
      selection = select(container.selection, "withoutExposedPort")
      selection = arg(selection, "port", port)

      selection =
        if is_nil(optional_args[:protocol]) do
          selection
        else
          arg(selection, "protocol", optional_args[:protocol])
        end

      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Indicate that subsequent operations should not be featured more prominently in the UI.\n\nThis is the initial state of all containers."
    @spec without_focus(t()) :: Dagger.Container.t()
    def without_focus(%__MODULE__{} = container) do
      selection = select(container.selection, "withoutFocus")
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container minus the given environment label.\n\n## Required Arguments\n\n* `name` - The name of the label to remove (e.g., \"org.opencontainers.artifact.created\")."
    @spec without_label(t(), Dagger.String.t()) :: Dagger.Container.t()
    def without_label(%__MODULE__{} = container, name) do
      selection = select(container.selection, "withoutLabel")
      selection = arg(selection, "name", name)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container after unmounting everything at the given path.\n\n## Required Arguments\n\n* `path` - Location of the cache directory (e.g., \"/cache/node_modules\")."
    @spec without_mount(t(), Dagger.String.t()) :: Dagger.Container.t()
    def without_mount(%__MODULE__{} = container, path) do
      selection = select(container.selection, "withoutMount")
      selection = arg(selection, "path", path)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container without the registry authentication of a given address.\n\n## Required Arguments\n\n* `address` - Registry's address to remove the authentication from.\n\nFormatted as [host]/[user]/[repo]:[tag] (e.g. docker.io/dagger/dagger:main)."
    @spec without_registry_auth(t(), Dagger.String.t()) :: Dagger.Container.t()
    def without_registry_auth(%__MODULE__{} = container, address) do
      selection = select(container.selection, "withoutRegistryAuth")
      selection = arg(selection, "address", address)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with a previously added Unix socket removed.\n\n## Required Arguments\n\n* `path` - Location of the socket to remove (e.g., \"/tmp/socket\")."
    @spec without_unix_socket(t(), Dagger.String.t()) :: Dagger.Container.t()
    def without_unix_socket(%__MODULE__{} = container, path) do
      selection = select(container.selection, "withoutUnixSocket")
      selection = arg(selection, "path", path)
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with an unset command user.\n\nShould default to root."
    @spec without_user(t()) :: Dagger.Container.t()
    def without_user(%__MODULE__{} = container) do
      selection = select(container.selection, "withoutUser")
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves this container with an unset working directory.\n\nShould default to \"/\"."
    @spec without_workdir(t()) :: Dagger.Container.t()
    def without_workdir(%__MODULE__{} = container) do
      selection = select(container.selection, "withoutWorkdir")
      %Dagger.Container{selection: selection, client: container.client}
    end
  )

  (
    @doc "Retrieves the working directory for all commands."
    @spec workdir(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def workdir(%__MODULE__{} = container) do
      selection = select(container.selection, "workdir")
      execute(selection, container.client)
    end
  )
end
