/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.serialize;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.serialize.protos.AddressProto;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lorg/whispersystems/signalservice/internal/serialize/SignalServiceAddressProtobufSerializer;", "", "()V", "fromProtobuf", "Lorg/whispersystems/signalservice/api/push/SignalServiceAddress;", "addressProto", "Lorg/whispersystems/signalservice/internal/serialize/protos/AddressProto;", "toProtobuf", "signalServiceAddress", "signal-service-java"})
public final class SignalServiceAddressProtobufSerializer {
    @NotNull
    public static final SignalServiceAddressProtobufSerializer INSTANCE = new SignalServiceAddressProtobufSerializer();

    private SignalServiceAddressProtobufSerializer() {
    }

    @JvmStatic
    @NotNull
    public static final AddressProto toProtobuf(@NotNull SignalServiceAddress signalServiceAddress) {
        Intrinsics.checkNotNullParameter((Object)signalServiceAddress, (String)"signalServiceAddress");
        AddressProto.Builder builder = new AddressProto.Builder();
        builder.uuid(signalServiceAddress.getServiceId().toByteString());
        if (signalServiceAddress.getNumber().isPresent()) {
            builder.e164(signalServiceAddress.getNumber().get());
        }
        return builder.build();
    }

    @JvmStatic
    @NotNull
    public static final SignalServiceAddress fromProtobuf(@NotNull AddressProto addressProto) {
        Intrinsics.checkNotNullParameter((Object)((Object)addressProto), (String)"addressProto");
        if (addressProto.uuid == null) {
            throw new IllegalArgumentException("Missing ServiceId!");
        }
        ServiceId serviceId = ServiceId.Companion.parseOrThrow(addressProto.uuid.toByteArray());
        Optional<String> optional = Optional.ofNullable(addressProto.e164);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        Optional<String> number = optional;
        return new SignalServiceAddress(serviceId, number);
    }
}

