/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.ByteArrayDeserializerBase64;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr3Credentials;", "", "username", "", "password", "shareSet", "", "(Ljava/lang/String;Ljava/lang/String;[B)V", "authCredentials", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "getAuthCredentials", "()Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "getPassword", "()Ljava/lang/String;", "getShareSet", "()[B", "getUsername", "signal-service-java"})
public final class Svr3Credentials {
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @Nullable
    private final byte[] shareSet;

    public Svr3Credentials(@JsonProperty @NotNull String username, @JsonProperty @NotNull String password, @JsonProperty @JsonDeserialize(using=ByteArrayDeserializerBase64.class) @Nullable byte[] shareSet) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.username = username;
        this.password = password;
        this.shareSet = shareSet;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @Nullable
    public final byte[] getShareSet() {
        return this.shareSet;
    }

    @NotNull
    public final AuthCredentials getAuthCredentials() {
        AuthCredentials authCredentials = AuthCredentials.create(this.username, this.password);
        Intrinsics.checkNotNullExpressionValue((Object)authCredentials, (String)"create(...)");
        return authCredentials;
    }
}

