/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.svr2.PinHash;
import org.signal.svr2.proto.BackupRequest;
import org.signal.svr2.proto.BackupResponse;
import org.signal.svr2.proto.DeleteRequest;
import org.signal.svr2.proto.ExposeRequest;
import org.signal.svr2.proto.ExposeResponse;
import org.signal.svr2.proto.Request;
import org.signal.svr2.proto.Response;
import org.signal.svr2.proto.RestoreRequest;
import org.signal.svr2.proto.RestoreResponse;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.signalservice.api.kbs.KbsData;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.kbs.PinHashUtil;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.api.svr.Svr2Socket;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.signalservice.internal.util.JsonUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\"\u0010\u0017\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV2;", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery;", "serviceConfiguration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "mrEnclave", "", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "(Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;Ljava/lang/String;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "svrVersion", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$SvrVersion;", "getSvrVersion", "()Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$SvrVersion;", "authorization", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "deleteData", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$DeleteResponse;", "restoreData", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$RestoreResponse;", "fetchAuth", "Lkotlin/Function0;", "userPin", "restoreDataPostRegistration", "restoreDataPreRegistration", "shareSet", "", "resumePinChangeSession", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$PinChangeSession;", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "serializedChangeSession", "setPin", "toString", "Companion", "Svr2PinChangeSession", "Svr2SessionData", "signal-service-java"})
public final class SecureValueRecoveryV2
implements SecureValueRecovery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignalServiceConfiguration serviceConfiguration;
    @NotNull
    private final String mrEnclave;
    @NotNull
    private final PushServiceSocket pushServiceSocket;
    @NotNull
    private final SecureValueRecovery.SvrVersion svrVersion;
    private static final String TAG = SecureValueRecoveryV2.class.getSimpleName();

    public SecureValueRecoveryV2(@NotNull SignalServiceConfiguration serviceConfiguration, @NotNull String mrEnclave, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)serviceConfiguration, (String)"serviceConfiguration");
        Intrinsics.checkNotNullParameter((Object)mrEnclave, (String)"mrEnclave");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.serviceConfiguration = serviceConfiguration;
        this.mrEnclave = mrEnclave;
        this.pushServiceSocket = pushServiceSocket;
        this.svrVersion = SecureValueRecovery.SvrVersion.SVR2;
    }

    @Override
    @NotNull
    public SecureValueRecovery.SvrVersion getSvrVersion() {
        return this.svrVersion;
    }

    @Override
    @NotNull
    public SecureValueRecovery.PinChangeSession setPin(@NotNull String userPin, @NotNull MasterKey masterKey) {
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        return new Svr2PinChangeSession(this, userPin, masterKey, false, 4, null);
    }

    @Override
    @NotNull
    public SecureValueRecovery.PinChangeSession resumePinChangeSession(@NotNull String userPin, @NotNull MasterKey masterKey, @NotNull String serializedChangeSession) {
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        Intrinsics.checkNotNullParameter((Object)serializedChangeSession, (String)"serializedChangeSession");
        Svr2SessionData svr2SessionData = JsonUtil.fromJson(serializedChangeSession, Svr2SessionData.class);
        Intrinsics.checkNotNullExpressionValue((Object)svr2SessionData, (String)"fromJson(...)");
        Svr2SessionData data = svr2SessionData;
        if (Intrinsics.areEqual((Object)data.getUserPin(), (Object)userPin) && Intrinsics.areEqual((Object)data.getMasterKey(), (Object)masterKey)) {
            return new Svr2PinChangeSession(this, data.getUserPin(), data.getMasterKey(), data.getSetupComplete());
        }
        return this.setPin(userPin, masterKey);
    }

    @Override
    @NotNull
    public SecureValueRecovery.RestoreResponse restoreDataPreRegistration(@NotNull AuthCredentials authorization, @Nullable byte[] shareSet, @NotNull String userPin) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        return this.restoreData((Function0<? extends AuthCredentials>)((Function0)new Function0<AuthCredentials>(authorization){
            final /* synthetic */ AuthCredentials $authorization;
            {
                this.$authorization = $authorization;
                super(0);
            }

            @NotNull
            public final AuthCredentials invoke() {
                return this.$authorization;
            }
        }), userPin);
    }

    @Override
    @NotNull
    public SecureValueRecovery.RestoreResponse restoreDataPostRegistration(@NotNull String userPin) {
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        return this.restoreData((Function0<? extends AuthCredentials>)((Function0)new Function0<AuthCredentials>(this){
            final /* synthetic */ SecureValueRecoveryV2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AuthCredentials invoke() {
                return this.this$0.authorization();
            }
        }), userPin);
    }

    @Override
    @NotNull
    public SecureValueRecovery.DeleteResponse deleteData() {
        SecureValueRecovery.DeleteResponse deleteResponse;
        Request request = new Request(null, null, null, new DeleteRequest(null, 1, null), null, 23, null);
        try {
            AuthCredentials authorization = this.authorization();
            new Svr2Socket(this.serviceConfiguration, this.mrEnclave).makeRequest(authorization, request);
            deleteResponse = SecureValueRecovery.DeleteResponse.Success.INSTANCE;
        }
        catch (NonSuccessfulResponseCodeException e) {
            Log.w((String)TAG, (String)"[Delete] Failed with a non-successful response code exception!", (Throwable)e);
            deleteResponse = new SecureValueRecovery.DeleteResponse.ApplicationError(e);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"[Delete] Failed with a network exception!", (Throwable)e);
            deleteResponse = new SecureValueRecovery.DeleteResponse.NetworkError(e);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"[Delete] Failed with a generic exception!", (Throwable)e);
            deleteResponse = new SecureValueRecovery.DeleteResponse.ApplicationError(e);
        }
        return deleteResponse;
    }

    @Override
    @NotNull
    public AuthCredentials authorization() throws IOException {
        AuthCredentials authCredentials = this.pushServiceSocket.getSvr2Authorization();
        Intrinsics.checkNotNullExpressionValue((Object)authCredentials, (String)"getSvr2Authorization(...)");
        return authCredentials;
    }

    @NotNull
    public String toString() {
        return "SVR2::" + this.mrEnclave;
    }

    private final SecureValueRecovery.RestoreResponse restoreData(Function0<? extends AuthCredentials> fetchAuth, String userPin) {
        SecureValueRecovery.RestoreResponse restoreResponse;
        byte[] normalizedPin = PinHashUtil.normalize(userPin);
        try {
            AuthCredentials authorization = (AuthCredentials)fetchAuth.invoke();
            Svr2Socket svr2Socket = new Svr2Socket(this.serviceConfiguration, this.mrEnclave);
            AuthCredentials authCredentials = (AuthCredentials)fetchAuth.invoke();
            byte[] byArray = PinHash.svr2((byte[])normalizedPin, (String)authorization.username(), (byte[])Hex.fromStringCondensed(this.mrEnclave)).accessKey();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"accessKey(...)");
            Response response = svr2Socket.makeRequest(authCredentials, new Request(null, null, new RestoreRequest(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null), null, 2, null), null, null, 27, null));
            RestoreResponse restoreResponse2 = response.restore;
            RestoreResponse.Status status = restoreResponse2 != null ? restoreResponse2.status : null;
            restoreResponse = switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1 -> {
                    SecureValueRecovery.RestoreResponse var7_10;
                    byte[] ciphertext = response.restore.data_.toByteArray();
                    try {
                        PinHash pinHash = PinHash.svr2((byte[])normalizedPin, (String)authorization.username(), (byte[])Hex.fromStringCondensed(this.mrEnclave));
                        Intrinsics.checkNotNull((Object)pinHash);
                        MasterKey v5 = PinHashUtil.decryptSvrDataIVCipherText(pinHash, ciphertext).getMasterKey();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getMasterKey(...)");
                        MasterKey masterKey = v5;
                        var7_10 = new SecureValueRecovery.RestoreResponse.Success(masterKey, authorization);
                    }
                    catch (InvalidCiphertextException e) {
                        Log.w((String)TAG, (String)"[Restore] Failed with an invalid cipher text exception!", (Throwable)e);
                        var7_10 = new SecureValueRecovery.RestoreResponse.ApplicationError(e);
                    }
                    yield var7_10;
                }
                case 2 -> SecureValueRecovery.RestoreResponse.Missing.INSTANCE;
                case 3 -> new SecureValueRecovery.RestoreResponse.PinMismatch(response.restore.tries);
                case 4 -> new SecureValueRecovery.RestoreResponse.ApplicationError(new SecureValueRecovery.InvalidRequestException("RestoreResponse returned status code for REQUEST_INVALID"));
                default -> {
                    BackupResponse v7 = response.backup;
                    yield new SecureValueRecovery.RestoreResponse.ApplicationError(new IllegalStateException("Unknown status: " + (v7 != null ? v7.status : null)));
                }
            };
        }
        catch (NonSuccessfulResponseCodeException e) {
            Log.w((String)TAG, (String)"[Restore] Failed with a non-successful response code exception!", (Throwable)e);
            restoreResponse = new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"[Restore] Failed with a network exception!", (Throwable)e);
            restoreResponse = new SecureValueRecovery.RestoreResponse.NetworkError(e);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"[Restore] Failed with a generic exception!", (Throwable)e);
            restoreResponse = new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        return restoreResponse;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV2$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV2$Svr2PinChangeSession;", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$PinChangeSession;", "userPin", "", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "setupComplete", "", "(Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV2;Ljava/lang/String;Lorg/whispersystems/signalservice/api/kbs/MasterKey;Z)V", "getMasterKey", "()Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "getUserPin", "()Ljava/lang/String;", "execute", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$BackupResponse;", "getBackupResponse", "Lorg/signal/svr2/proto/BackupResponse;", "authorization", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "normalizedPin", "", "getExposeResponse", "serialize", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nSecureValueRecoveryV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureValueRecoveryV2.kt\norg/whispersystems/signalservice/api/svr/SecureValueRecoveryV2$Svr2PinChangeSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
    public final class Svr2PinChangeSession
    implements SecureValueRecovery.PinChangeSession {
        @NotNull
        private final String userPin;
        @NotNull
        private final MasterKey masterKey;
        private boolean setupComplete;
        final /* synthetic */ SecureValueRecoveryV2 this$0;

        public Svr2PinChangeSession(@JsonProperty(value="user_pin") @NotNull SecureValueRecoveryV2 this$0, @JsonProperty(value="master_key") @JsonSerialize(using=JsonUtil.MasterKeySerializer.class) @JsonDeserialize(using=JsonUtil.MasterKeyDeserializer.class) @NotNull String userPin, @JsonProperty(value="setup_complete") MasterKey masterKey, boolean setupComplete) {
            Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
            Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
            this.this$0 = this$0;
            this.userPin = userPin;
            this.masterKey = masterKey;
            this.setupComplete = setupComplete;
        }

        public /* synthetic */ Svr2PinChangeSession(SecureValueRecoveryV2 secureValueRecoveryV2, String string, MasterKey masterKey, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(secureValueRecoveryV2, string, masterKey, bl);
        }

        @NotNull
        public final String getUserPin() {
            return this.userPin;
        }

        @NotNull
        public final MasterKey getMasterKey() {
            return this.masterKey;
        }

        @Override
        @NotNull
        public SecureValueRecovery.BackupResponse execute() {
            SecureValueRecovery.BackupResponse backupResponse;
            byte[] normalizedPin = PinHashUtil.normalize(this.userPin);
            try {
                BackupResponse backupResponse2;
                AuthCredentials authorization = this.this$0.authorization();
                BackupResponse it = backupResponse2 = this.setupComplete ? new BackupResponse(BackupResponse.Status.OK, null, 2, null) : this.getBackupResponse(authorization, normalizedPin);
                boolean bl = false;
                this.setupComplete = true;
                BackupResponse response = backupResponse2;
                backupResponse = switch (WhenMappings.$EnumSwitchMapping$0[response.status.ordinal()]) {
                    case 1 -> this.getExposeResponse(authorization, normalizedPin);
                    case 2 -> new SecureValueRecovery.BackupResponse.ApplicationError(new SecureValueRecovery.InvalidRequestException("BackupResponse returned status code for REQUEST_INVALID"));
                    default -> new SecureValueRecovery.BackupResponse.ApplicationError(new IllegalStateException("Unknown status: " + response.status));
                };
            }
            catch (NonSuccessfulResponseCodeException e) {
                Log.w((String)TAG, (String)"[Set] Failed with a non-successful response code exception!", (Throwable)e);
                backupResponse = new SecureValueRecovery.BackupResponse.ApplicationError(e);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"[Set] Failed with a network exception!", (Throwable)e);
                backupResponse = new SecureValueRecovery.BackupResponse.NetworkError(e);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"[Set] Failed with a generic exception!", (Throwable)e);
                backupResponse = new SecureValueRecovery.BackupResponse.ApplicationError(e);
            }
            return backupResponse;
        }

        @Override
        @NotNull
        public String serialize() {
            String string = JsonUtil.toJson(new Svr2SessionData(this.userPin, this.masterKey, this.setupComplete));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        private final BackupResponse getBackupResponse(AuthCredentials authorization, byte[] normalizedPin) {
            PinHash hashedPin = PinHash.svr2((byte[])normalizedPin, (String)authorization.username(), (byte[])Hex.fromStringCondensed(this.this$0.mrEnclave));
            Intrinsics.checkNotNull((Object)hashedPin);
            KbsData data = PinHashUtil.createNewKbsData(hashedPin, this.masterKey);
            byte[] byArray = data.getKbsAccessKey();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getKbsAccessKey(...)");
            ByteString byteString = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null);
            byte[] byArray2 = data.getCipherText();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getCipherText(...)");
            ByteString byteString2 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray2, (int)0, (int)0, (int)3, null);
            Request request = new Request(new BackupRequest(byteString2, byteString, 10, null, 8, null), null, null, null, null, 30, null);
            Response response = new Svr2Socket(this.this$0.serviceConfiguration, this.this$0.mrEnclave).makeRequest(authorization, request);
            boolean bl = false;
            BackupResponse backupResponse = response.backup;
            if (backupResponse == null) {
                throw new IllegalStateException("Backup response not set!");
            }
            return backupResponse;
        }

        private final SecureValueRecovery.BackupResponse getExposeResponse(AuthCredentials authorization, byte[] normalizedPin) {
            SecureValueRecovery.BackupResponse backupResponse;
            PinHash hashedPin = PinHash.svr2((byte[])normalizedPin, (String)authorization.username(), (byte[])Hex.fromStringCondensed(this.this$0.mrEnclave));
            Intrinsics.checkNotNull((Object)hashedPin);
            KbsData data = PinHashUtil.createNewKbsData(hashedPin, this.masterKey);
            byte[] byArray = data.getCipherText();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getCipherText(...)");
            Request request = new Request(null, new ExposeRequest(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null), null, 2, null), null, null, null, 29, null);
            Response response = new Svr2Socket(this.this$0.serviceConfiguration, this.this$0.mrEnclave).makeRequest(authorization, request);
            boolean bl = false;
            ExposeResponse exposeResponse = response.expose;
            ExposeResponse.Status status = exposeResponse != null ? exposeResponse.status : null;
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
                case 1: {
                    backupResponse = new SecureValueRecovery.BackupResponse.Success(this.masterKey, authorization, SecureValueRecovery.SvrVersion.SVR2);
                    break;
                }
                case 2: {
                    backupResponse = SecureValueRecovery.BackupResponse.ExposeFailure.INSTANCE;
                    break;
                }
                default: {
                    backupResponse = new SecureValueRecovery.BackupResponse.ApplicationError(new IllegalStateException("Backup response not set!"));
                }
            }
            return backupResponse;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[BackupResponse.Status.values().length];
                try {
                    nArray[BackupResponse.Status.OK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BackupResponse.Status.REQUEST_INVALID.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ExposeResponse.Status.values().length];
                try {
                    nArray[ExposeResponse.Status.OK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExposeResponse.Status.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV2$Svr2SessionData;", "", "userPin", "", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "setupComplete", "", "(Ljava/lang/String;Lorg/whispersystems/signalservice/api/kbs/MasterKey;Z)V", "getMasterKey", "()Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "getSetupComplete", "()Z", "getUserPin", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "signal-service-java"})
    public static final class Svr2SessionData {
        @NotNull
        private final String userPin;
        @NotNull
        private final MasterKey masterKey;
        private final boolean setupComplete;

        public Svr2SessionData(@JsonProperty(value="user_pin") @NotNull String userPin, @JsonProperty(value="master_key") @JsonSerialize(using=JsonUtil.MasterKeySerializer.class) @JsonDeserialize(using=JsonUtil.MasterKeyDeserializer.class) @NotNull MasterKey masterKey, @JsonProperty(value="setup_complete") boolean setupComplete) {
            Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
            Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
            this.userPin = userPin;
            this.masterKey = masterKey;
            this.setupComplete = setupComplete;
        }

        public /* synthetic */ Svr2SessionData(String string, MasterKey masterKey, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, masterKey, bl);
        }

        @NotNull
        public final String getUserPin() {
            return this.userPin;
        }

        @NotNull
        public final MasterKey getMasterKey() {
            return this.masterKey;
        }

        public final boolean getSetupComplete() {
            return this.setupComplete;
        }

        @NotNull
        public final String component1() {
            return this.userPin;
        }

        @NotNull
        public final MasterKey component2() {
            return this.masterKey;
        }

        public final boolean component3() {
            return this.setupComplete;
        }

        @NotNull
        public final Svr2SessionData copy(@JsonProperty(value="user_pin") @NotNull String userPin, @JsonProperty(value="master_key") @JsonSerialize(using=JsonUtil.MasterKeySerializer.class) @JsonDeserialize(using=JsonUtil.MasterKeyDeserializer.class) @NotNull MasterKey masterKey, @JsonProperty(value="setup_complete") boolean setupComplete) {
            Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
            Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
            return new Svr2SessionData(userPin, masterKey, setupComplete);
        }

        public static /* synthetic */ Svr2SessionData copy$default(Svr2SessionData svr2SessionData, String string, MasterKey masterKey, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = svr2SessionData.userPin;
            }
            if ((n & 2) != 0) {
                masterKey = svr2SessionData.masterKey;
            }
            if ((n & 4) != 0) {
                bl = svr2SessionData.setupComplete;
            }
            return svr2SessionData.copy(string, masterKey, bl);
        }

        @NotNull
        public String toString() {
            return "Svr2SessionData(userPin=" + this.userPin + ", masterKey=" + this.masterKey + ", setupComplete=" + this.setupComplete + ")";
        }

        public int hashCode() {
            int result2 = this.userPin.hashCode();
            result2 = result2 * 31 + this.masterKey.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.setupComplete);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Svr2SessionData)) {
                return false;
            }
            Svr2SessionData svr2SessionData = (Svr2SessionData)other;
            if (!Intrinsics.areEqual((Object)this.userPin, (Object)svr2SessionData.userPin)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.masterKey, (Object)svr2SessionData.masterKey)) {
                return false;
            }
            return this.setupComplete == svr2SessionData.setupComplete;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestoreResponse.Status.values().length];
            try {
                nArray[RestoreResponse.Status.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestoreResponse.Status.MISSING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestoreResponse.Status.PIN_MISMATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestoreResponse.Status.REQUEST_INVALID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

