/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.crypto.DigestingOutputStream;

public class ProfileCipherOutputStream
extends DigestingOutputStream {
    private final Cipher cipher;

    public ProfileCipherOutputStream(OutputStream out, ProfileKey key) throws IOException {
        super(out);
        try {
            this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] nonce = this.generateNonce();
            this.cipher.init(1, (Key)new SecretKeySpec(key.serialize(), "AES"), new GCMParameterSpec(128, nonce));
            super.write(nonce, 0, nonce.length);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        byte[] output = this.cipher.update(buffer, offset, length);
        super.write(output);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] input = new byte[]{(byte)b};
        byte[] output = this.cipher.update(input);
        super.write(output);
    }

    @Override
    public void flush() throws IOException {
        try {
            byte[] output = this.cipher.doFinal();
            super.write(output);
            super.flush();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] generateNonce() {
        byte[] nonce = new byte[12];
        new SecureRandom().nextBytes(nonce);
        return nonce;
    }

    public static long getCiphertextLength(long plaintextLength) {
        return 28L + plaintextLength;
    }
}

