/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.signalservice.api.crypto.DigestingOutputStream;
import org.whispersystems.signalservice.internal.util.Util;

public class AttachmentCipherOutputStream
extends DigestingOutputStream {
    private final Cipher cipher;
    private final Mac mac;

    public AttachmentCipherOutputStream(byte[] combinedKeyMaterial, byte[] iv, OutputStream outputStream) throws IOException {
        super(outputStream);
        try {
            this.cipher = this.initializeCipher();
            this.mac = this.initializeMac();
            byte[][] keyParts = Util.split(combinedKeyMaterial, 32, 32);
            if (iv == null) {
                this.cipher.init(1, new SecretKeySpec(keyParts[0], "AES"));
            } else {
                this.cipher.init(1, (Key)new SecretKeySpec(keyParts[0], "AES"), new IvParameterSpec(iv));
            }
            this.mac.init(new SecretKeySpec(keyParts[1], "HmacSHA256"));
            this.mac.update(this.cipher.getIV());
            super.write(this.cipher.getIV());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        byte[] ciphertext = this.cipher.update(buffer, offset, length);
        if (ciphertext != null) {
            this.mac.update(ciphertext);
            super.write(ciphertext);
        }
    }

    @Override
    public void write(int b) {
        throw new AssertionError((Object)"NYI");
    }

    @Override
    public void flush() throws IOException {
        try {
            byte[] ciphertext = this.cipher.doFinal();
            byte[] auth = this.mac.doFinal(ciphertext);
            super.write(ciphertext);
            super.write(auth);
            super.flush();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Mac initializeMac() {
        try {
            return Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Cipher initializeCipher() {
        try {
            return Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

