/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;

public class IOUtils {
    public static File createTempFile() throws IOException {
        File tempFile = File.createTempFile("signal-cli_tmp_", ".tmp");
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copyStream(in, baos);
        return baos.toByteArray();
    }

    public static void createPrivateDirectories(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        Path path = file.toPath();
        try {
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(perms));
        }
        catch (UnsupportedOperationException e) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    public static void createPrivateFile(File path) throws IOException {
        Path file = path.toPath();
        try {
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            Files.createFile(file, PosixFilePermissions.asFileAttribute(perms));
        }
        catch (UnsupportedOperationException e) {
            Files.createFile(file, new FileAttribute[0]);
        }
    }

    public static void copyFileToStream(File inputFile, OutputStream output) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            IOUtils.copyStream(inputStream, output);
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        IOUtils.copyStream(input, output, 4096);
    }

    public static void copyStream(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int read;
        byte[] buffer = new byte[bufferSize];
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
    }

    public static long getFileCreateTime(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attr.creationTime();
            return fileTime.toMillis();
        }
        catch (IOException ex) {
            return -1L;
        }
    }
}

