/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.identities;

import java.util.function.Supplier;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.identities.IdentityKeyStore;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.state.IdentityKeyStore;

public class SignalIdentityKeyStore
implements org.signal.libsignal.protocol.state.IdentityKeyStore {
    private final Supplier<IdentityKeyPair> identityKeyPairSupplier;
    private final int localRegistrationId;
    private final IdentityKeyStore identityKeyStore;

    public SignalIdentityKeyStore(Supplier<IdentityKeyPair> identityKeyPairSupplier, int localRegistrationId, IdentityKeyStore identityKeyStore) {
        this.identityKeyPairSupplier = identityKeyPairSupplier;
        this.localRegistrationId = localRegistrationId;
        this.identityKeyStore = identityKeyStore;
    }

    public IdentityKeyPair getIdentityKeyPair() {
        return this.identityKeyPairSupplier.get();
    }

    public int getLocalRegistrationId() {
        return this.localRegistrationId;
    }

    public boolean saveIdentity(SignalProtocolAddress address, IdentityKey identityKey) {
        return this.identityKeyStore.saveIdentity(address.getName(), identityKey);
    }

    public boolean isTrustedIdentity(SignalProtocolAddress address, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        return this.identityKeyStore.isTrustedIdentity(address.getName(), identityKey, direction);
    }

    public IdentityKey getIdentity(SignalProtocolAddress address) {
        IdentityInfo identityInfo = this.identityKeyStore.getIdentityInfo(address.getName());
        return identityInfo == null ? null : identityInfo.getIdentityKey();
    }
}

