/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.configuration;

import java.sql.Connection;
import java.sql.SQLException;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.storage.keyValue.KeyValueEntry;
import org.asamk.signal.manager.storage.keyValue.KeyValueStore;
import org.asamk.signal.manager.storage.recipients.RecipientStore;

public class ConfigurationStore {
    private final KeyValueStore keyValueStore;
    private final RecipientStore recipientStore;
    private final KeyValueEntry<Boolean> readReceipts = new KeyValueEntry<Boolean>("config-read-receipts", Boolean.class);
    private final KeyValueEntry<Boolean> unidentifiedDeliveryIndicators = new KeyValueEntry<Boolean>("config-unidentified-delivery-indicators", Boolean.class);
    private final KeyValueEntry<Boolean> typingIndicators = new KeyValueEntry<Boolean>("config-typing-indicators", Boolean.class);
    private final KeyValueEntry<Boolean> linkPreviews = new KeyValueEntry<Boolean>("config-link-previews", Boolean.class);
    private final KeyValueEntry<Boolean> phoneNumberUnlisted = new KeyValueEntry<Boolean>("config-phone-number-unlisted", Boolean.class);
    private final KeyValueEntry<PhoneNumberSharingMode> phoneNumberSharingMode = new KeyValueEntry<PhoneNumberSharingMode>("config-phone-number-sharing-mode", PhoneNumberSharingMode.class);
    private final KeyValueEntry<String> usernameLinkColor = new KeyValueEntry<String>("username-link-color", String.class);

    public ConfigurationStore(KeyValueStore keyValueStore, RecipientStore recipientStore) {
        this.keyValueStore = keyValueStore;
        this.recipientStore = recipientStore;
    }

    public Boolean getReadReceipts() {
        return this.keyValueStore.getEntry(this.readReceipts);
    }

    public void setReadReceipts(boolean value) {
        if (this.keyValueStore.storeEntry(this.readReceipts, value)) {
            this.recipientStore.rotateSelfStorageId();
        }
    }

    public void setReadReceipts(Connection connection, boolean value) throws SQLException {
        if (this.keyValueStore.storeEntry(connection, this.readReceipts, value)) {
            this.recipientStore.rotateSelfStorageId(connection);
        }
    }

    public Boolean getUnidentifiedDeliveryIndicators() {
        return this.keyValueStore.getEntry(this.unidentifiedDeliveryIndicators);
    }

    public void setUnidentifiedDeliveryIndicators(boolean value) {
        if (this.keyValueStore.storeEntry(this.unidentifiedDeliveryIndicators, value)) {
            this.recipientStore.rotateSelfStorageId();
        }
    }

    public void setUnidentifiedDeliveryIndicators(Connection connection, boolean value) throws SQLException {
        if (this.keyValueStore.storeEntry(connection, this.unidentifiedDeliveryIndicators, value)) {
            this.recipientStore.rotateSelfStorageId(connection);
        }
    }

    public Boolean getTypingIndicators() {
        return this.keyValueStore.getEntry(this.typingIndicators);
    }

    public void setTypingIndicators(boolean value) {
        if (this.keyValueStore.storeEntry(this.typingIndicators, value)) {
            this.recipientStore.rotateSelfStorageId();
        }
    }

    public void setTypingIndicators(Connection connection, boolean value) throws SQLException {
        if (this.keyValueStore.storeEntry(connection, this.typingIndicators, value)) {
            this.recipientStore.rotateSelfStorageId(connection);
        }
    }

    public Boolean getLinkPreviews() {
        return this.keyValueStore.getEntry(this.linkPreviews);
    }

    public void setLinkPreviews(boolean value) {
        if (this.keyValueStore.storeEntry(this.linkPreviews, value)) {
            this.recipientStore.rotateSelfStorageId();
        }
    }

    public void setLinkPreviews(Connection connection, boolean value) throws SQLException {
        if (this.keyValueStore.storeEntry(connection, this.linkPreviews, value)) {
            this.recipientStore.rotateSelfStorageId(connection);
        }
    }

    public Boolean getPhoneNumberUnlisted() {
        return this.keyValueStore.getEntry(this.phoneNumberUnlisted);
    }

    public void setPhoneNumberUnlisted(boolean value) {
        if (this.keyValueStore.storeEntry(this.phoneNumberUnlisted, value)) {
            this.recipientStore.rotateSelfStorageId();
        }
    }

    public void setPhoneNumberUnlisted(Connection connection, boolean value) throws SQLException {
        if (this.keyValueStore.storeEntry(connection, this.phoneNumberUnlisted, value)) {
            this.recipientStore.rotateSelfStorageId(connection);
        }
    }

    public PhoneNumberSharingMode getPhoneNumberSharingMode() {
        return this.keyValueStore.getEntry(this.phoneNumberSharingMode);
    }

    public void setPhoneNumberSharingMode(PhoneNumberSharingMode value) {
        if (this.keyValueStore.storeEntry(this.phoneNumberSharingMode, value)) {
            this.recipientStore.rotateSelfStorageId();
        }
    }

    public void setPhoneNumberSharingMode(Connection connection, PhoneNumberSharingMode value) throws SQLException {
        if (this.keyValueStore.storeEntry(connection, this.phoneNumberSharingMode, value)) {
            this.recipientStore.rotateSelfStorageId(connection);
        }
    }

    public String getUsernameLinkColor() {
        return this.keyValueStore.getEntry(this.usernameLinkColor);
    }

    public void setUsernameLinkColor(String color) {
        if (this.keyValueStore.storeEntry(this.usernameLinkColor, color)) {
            this.recipientStore.rotateSelfStorageId();
        }
    }

    public void setUsernameLinkColor(Connection connection, String color) throws SQLException {
        if (this.keyValueStore.storeEntry(connection, this.usernameLinkColor, color)) {
            this.recipientStore.rotateSelfStorageId(connection);
        }
    }
}

