/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.asamk.signal.manager.api.InvalidDeviceLinkException;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.whispersystems.signalservice.internal.util.Util;

public record DeviceLinkUrl(String deviceIdentifier, ECPublicKey deviceKey) {
    public static DeviceLinkUrl parseDeviceLinkUri(URI linkUri) throws InvalidDeviceLinkException {
        ECPublicKey deviceKey;
        byte[] publicKeyBytes;
        String rawQuery = linkUri.getRawQuery();
        if (Util.isEmpty((String)rawQuery)) {
            throw new RuntimeException("Invalid device link uri");
        }
        Map<String, String> query = Utils.getQueryMap(rawQuery);
        String deviceIdentifier = query.get("uuid");
        String publicKeyEncoded = query.get("pub_key");
        if (Util.isEmpty((String)deviceIdentifier) || Util.isEmpty((String)publicKeyEncoded)) {
            throw new InvalidDeviceLinkException("Invalid device link uri");
        }
        try {
            publicKeyBytes = Base64.getDecoder().decode(publicKeyEncoded);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDeviceLinkException("Invalid device link uri", e);
        }
        try {
            deviceKey = Curve.decodePoint((byte[])publicKeyBytes, (int)0);
        }
        catch (InvalidKeyException e) {
            throw new InvalidDeviceLinkException("Invalid device link", e);
        }
        return new DeviceLinkUrl(deviceIdentifier, deviceKey);
    }

    public URI createDeviceLinkUri() {
        String deviceKeyString = Base64.getEncoder().encodeToString(this.deviceKey.serialize()).replace("=", "");
        try {
            return new URI("sgnl://linkdevice?uuid=" + URLEncoder.encode(this.deviceIdentifier, StandardCharsets.UTF_8) + "&pub_key=" + URLEncoder.encode(deviceKeyString, StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }
}

