/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groups;

import java.security.SecureRandom;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupPublicParams;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class GroupSecretParams
extends ByteArray {
    public static GroupSecretParams generate() {
        return GroupSecretParams.generate(new SecureRandom());
    }

    public static GroupSecretParams generate(SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.GroupSecretParams_GenerateDeterministic(random);
        try {
            return new GroupSecretParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GroupSecretParams deriveFromMasterKey(GroupMasterKey groupMasterKey) {
        byte[] newContents = Native.GroupSecretParams_DeriveFromMasterKey(groupMasterKey.getInternalContentsForJNI());
        try {
            return new GroupSecretParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public GroupSecretParams(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.GroupSecretParams_CheckValidContents(contents));
    }

    public GroupMasterKey getMasterKey() {
        byte[] newContents = Native.GroupSecretParams_GetMasterKey(this.contents);
        try {
            return new GroupMasterKey(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public GroupPublicParams getPublicParams() {
        byte[] newContents = Native.GroupSecretParams_GetPublicParams(this.contents);
        try {
            return new GroupPublicParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

