/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.auth;

import java.security.SecureRandom;
import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerSecretParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.AuthCredentialPresentation;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPniResponse;
import org.signal.libsignal.zkgroup.groups.GroupPublicParams;

public class ServerZkAuthOperations {
    private final ServerSecretParams serverSecretParams;

    public ServerZkAuthOperations(ServerSecretParams serverSecretParams) {
        this.serverSecretParams = serverSecretParams;
    }

    public AuthCredentialWithPniResponse issueAuthCredentialWithPniAsServiceId(ServiceId.Aci aci, ServiceId.Pni pni, Instant redemptionTime) {
        return this.issueAuthCredentialWithPniAsServiceId(new SecureRandom(), aci, pni, redemptionTime);
    }

    public AuthCredentialWithPniResponse issueAuthCredentialWithPniAsServiceId(SecureRandom secureRandom, ServiceId.Aci aci, ServiceId.Pni pni, Instant redemptionTime) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = this.serverSecretParams.guardedMap(serverSecretParams -> Native.ServerSecretParams_IssueAuthCredentialWithPniAsServiceIdDeterministic(serverSecretParams, random, aci.toServiceIdFixedWidthBinary(), pni.toServiceIdFixedWidthBinary(), redemptionTime.getEpochSecond()));
        try {
            return new AuthCredentialWithPniResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AuthCredentialWithPniResponse issueAuthCredentialWithPniZkc(ServiceId.Aci aci, ServiceId.Pni pni, Instant redemptionTime) {
        return this.issueAuthCredentialWithPniZkc(new SecureRandom(), aci, pni, redemptionTime);
    }

    public AuthCredentialWithPniResponse issueAuthCredentialWithPniZkc(SecureRandom secureRandom, ServiceId.Aci aci, ServiceId.Pni pni, Instant redemptionTime) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = this.serverSecretParams.guardedMap(serverSecretParams -> Native.ServerSecretParams_IssueAuthCredentialWithPniZkcDeterministic(serverSecretParams, random, aci.toServiceIdFixedWidthBinary(), pni.toServiceIdFixedWidthBinary(), redemptionTime.getEpochSecond()));
        try {
            return new AuthCredentialWithPniResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void verifyAuthCredentialPresentation(GroupPublicParams groupPublicParams, AuthCredentialPresentation authCredentialPresentation) throws VerificationFailedException {
        this.verifyAuthCredentialPresentation(groupPublicParams, authCredentialPresentation, Instant.now());
    }

    public void verifyAuthCredentialPresentation(GroupPublicParams groupPublicParams, AuthCredentialPresentation authCredentialPresentation, Instant currentTime) throws VerificationFailedException {
        FilterExceptions.filterExceptions(VerificationFailedException.class, () -> this.serverSecretParams.guardedRunChecked(secretParams -> Native.ServerSecretParams_VerifyAuthCredentialPresentation(secretParams, groupPublicParams.getInternalContentsForJNI(), authCredentialPresentation.getInternalContentsForJNI(), currentTime.getEpochSecond())));
    }
}

