/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.sgxsession;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.sgxsession.SgxCommunicationFailureException;

public class SgxClient
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected SgxClient(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    protected void finalize() {
        Native.SgxClientState_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public byte[] initialRequest() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.SgxClientState_InitialRequest(guard.nativeHandle()));
            return byArray;
        }
    }

    public void completeHandshake(byte[] handshakeResponse) throws SgxCommunicationFailureException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            FilterExceptions.filterExceptions(SgxCommunicationFailureException.class, () -> Native.SgxClientState_CompleteHandshake(guard.nativeHandle(), handshakeResponse));
        }
    }

    public byte[] establishedSend(byte[] plaintextToSend) throws SgxCommunicationFailureException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(SgxCommunicationFailureException.class, () -> Native.SgxClientState_EstablishedSend(guard.nativeHandle(), plaintextToSend));
            return byArray;
        }
    }

    public byte[] establishedRecv(byte[] receivedCiphertext) throws SgxCommunicationFailureException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(SgxCommunicationFailureException.class, () -> Native.SgxClientState_EstablishedRecv(guard.nativeHandle(), receivedCiphertext));
            return byArray;
        }
    }
}

