/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kem.KEMPublicKey;

public class PreKeyBundle
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;
    public static final int NULL_PRE_KEY_ID = -1;

    protected void finalize() {
        Native.PreKeyBundle_Destroy(this.unsafeHandle);
    }

    public PreKeyBundle(int registrationId, int deviceId, int preKeyId, ECPublicKey preKeyPublic, int signedPreKeyId, ECPublicKey signedPreKeyPublic, byte[] signedPreKeySignature, IdentityKey identityKey) {
        this(registrationId, deviceId, preKeyId, preKeyPublic, signedPreKeyId, signedPreKeyPublic, signedPreKeySignature, identityKey, -1, null, null);
    }

    public PreKeyBundle(int registrationId, int deviceId, int preKeyId, ECPublicKey preKeyPublic, int signedPreKeyId, ECPublicKey signedPreKeyPublic, byte[] signedPreKeySignature, IdentityKey identityKey, int kyberPreKeyId, KEMPublicKey kyberPreKeyPublic, byte[] kyberPreKeySignature) {
        try (NativeHandleGuard preKeyPublicGuard = new NativeHandleGuard(preKeyPublic);
             NativeHandleGuard signedPreKeyPublicGuard = new NativeHandleGuard(signedPreKeyPublic);
             NativeHandleGuard identityKeyGuard = new NativeHandleGuard(identityKey.getPublicKey());
             NativeHandleGuard kyberPreKeyPublicGuard = new NativeHandleGuard(kyberPreKeyPublic);){
            byte[] kyberSignature = kyberPreKeySignature == null ? new byte[]{} : kyberPreKeySignature;
            this.unsafeHandle = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_New(registrationId, deviceId, preKeyId, preKeyPublicGuard.nativeHandle(), signedPreKeyId, signedPreKeyPublicGuard.nativeHandle(), signedPreKeySignature, identityKeyGuard.nativeHandle(), kyberPreKeyId, kyberPreKeyPublicGuard.nativeHandle(), kyberSignature));
        }
    }

    public int getDeviceId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetDeviceId(guard.nativeHandle()));
            return n;
        }
    }

    public int getPreKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetPreKeyId(guard.nativeHandle()));
            return n;
        }
    }

    public ECPublicKey getPreKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long handle = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetPreKeyPublic(guard.nativeHandle()));
            if (handle != 0L) {
                ECPublicKey eCPublicKey = new ECPublicKey(handle);
                return eCPublicKey;
            }
            ECPublicKey eCPublicKey = null;
            return eCPublicKey;
        }
    }

    public int getSignedPreKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetSignedPreKeyId(guard.nativeHandle()));
            return n;
        }
    }

    public ECPublicKey getSignedPreKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetSignedPreKeyPublic(guard.nativeHandle())));
            return eCPublicKey;
        }
    }

    public byte[] getSignedPreKeySignature() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetSignedPreKeySignature(guard.nativeHandle()));
            return byArray;
        }
    }

    public IdentityKey getIdentityKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            IdentityKey identityKey = new IdentityKey(new ECPublicKey(FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetIdentityKey(guard.nativeHandle()))));
            return identityKey;
        }
    }

    public int getRegistrationId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetRegistrationId(guard.nativeHandle()));
            return n;
        }
    }

    public int getKyberPreKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetKyberPreKeyId(guard.nativeHandle()));
            return n;
        }
    }

    public KEMPublicKey getKyberPreKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            long handle = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetKyberPreKeyPublic(guard.nativeHandle()));
            if (handle != 0L) {
                KEMPublicKey kEMPublicKey = new KEMPublicKey(handle);
                return kEMPublicKey;
            }
            KEMPublicKey kEMPublicKey = null;
            return kEMPublicKey;
        }
    }

    public byte[] getKyberPreKeySignature() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] signature = FilterExceptions.filterExceptions(() -> Native.PreKeyBundle_GetKyberPreKeySignature(guard.nativeHandle()));
            if (signature.length == 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = signature;
            return byArray;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

