/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ServerSentEventSender {
    private final BufferedWriter writer;

    public ServerSentEventSender(OutputStream outputStream) {
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    public synchronized void sendEvent(String id, String event, List<String> data) throws IOException {
        if (id != null) {
            this.writer.write("id:");
            this.writer.write(id);
            this.writer.write("\n");
        }
        if (event != null) {
            this.writer.write("event:");
            this.writer.write(event);
            this.writer.write("\n");
        }
        if (data.isEmpty()) {
            this.writer.write("data\n");
        } else {
            for (String d : data) {
                this.writer.write("data:");
                this.writer.write(d);
                this.writer.write("\n");
            }
        }
        this.writer.write("\n");
        this.writer.flush();
    }

    public synchronized void sendKeepAlive() throws IOException {
        this.writer.write(":\n");
        this.writer.flush();
    }
}

