/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.asamk.Signal;
import org.asamk.signal.dbus.DbusInterfacePropertiesHandler;
import org.asamk.signal.dbus.DbusProperty;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;

public abstract class DbusProperties
implements Properties {
    private final List<DbusInterfacePropertiesHandler> handlers = new ArrayList<DbusInterfacePropertiesHandler>();

    protected void addPropertiesHandler(DbusInterfacePropertiesHandler handler) {
        this.handlers.add(handler);
    }

    DbusInterfacePropertiesHandler getHandler(String interfaceName) {
        Optional<DbusInterfacePropertiesHandler> handler = this.getHandlerOptional(interfaceName);
        if (handler.isEmpty()) {
            throw new Signal.Error.Failure("Property not found");
        }
        return handler.get();
    }

    private Optional<DbusInterfacePropertiesHandler> getHandlerOptional(String interfaceName) {
        return this.handlers.stream().filter(h -> h.getInterfaceName().equals(interfaceName)).findFirst();
    }

    public <A> A Get(String interface_name, String property_name) {
        DbusInterfacePropertiesHandler handler = this.getHandler(interface_name);
        Supplier getter = handler.getGetter(property_name);
        if (getter == null) {
            throw new Signal.Error.Failure("Property not found");
        }
        return (A)getter.get();
    }

    public <A> void Set(String interface_name, String property_name, A value) {
        DbusInterfacePropertiesHandler handler = this.getHandler(interface_name);
        Consumer<A> setter = handler.getSetter(property_name);
        if (setter == null) {
            throw new Signal.Error.Failure("Property not found");
        }
        setter.accept(value);
    }

    public Map<String, Variant<?>> GetAll(String interface_name) {
        Optional<DbusInterfacePropertiesHandler> handler = this.getHandlerOptional(interface_name);
        if (handler.isEmpty()) {
            return Map.of();
        }
        return handler.get().getProperties().stream().filter(p -> p.getGetter() != null).collect(Collectors.toMap(DbusProperty::getName, p -> {
            Variant variant;
            Object o = p.getGetter().get();
            return o instanceof Variant ? (variant = (Variant)o) : new Variant(o);
        }));
    }
}

