/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.util.ArrayList;
import java.util.List;
import org.asamk.signal.DbusConfig;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.dbus.DbusSignalControlImpl;
import org.asamk.signal.dbus.DbusSignalImpl;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbusHandler
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DbusHandler.class);
    private final boolean isDbusSystem;
    private DBusConnection dBusConnection;
    private final String busname;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final DbusRunner dbusRunner;
    private final boolean noReceiveOnStart;

    public DbusHandler(boolean isDbusSystem, String busname, Manager m, boolean noReceiveOnStart) {
        this.isDbusSystem = isDbusSystem;
        this.dbusRunner = connection -> {
            try {
                this.exportDbusObject(connection, DbusConfig.getObjectPath(), m).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        this.noReceiveOnStart = noReceiveOnStart;
        this.busname = busname;
    }

    public DbusHandler(boolean isDbusSystem, String busname, MultiAccountManager c, boolean noReceiveOnStart) {
        this.isDbusSystem = isDbusSystem;
        this.dbusRunner = connection -> {
            DbusSignalControlImpl signalControl = new DbusSignalControlImpl(c, DbusConfig.getObjectPath());
            connection.exportObject((DBusInterface)signalControl);
            c.addOnManagerAddedHandler(m -> {
                Thread thread = this.exportManager(connection, (Manager)m);
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            c.addOnManagerRemovedHandler(m -> {
                String path = DbusConfig.getObjectPath(m.getSelfNumber());
                try {
                    DBusInterface object = connection.getExportedObject(null, path);
                    if (object instanceof DbusSignalImpl) {
                        DbusSignalImpl dbusSignal = (DbusSignalImpl)object;
                        dbusSignal.close();
                        this.closeables.remove(dbusSignal);
                    }
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
            });
            List<Thread> initThreads = c.getManagers().stream().map(m -> this.exportManager(connection, (Manager)m)).toList();
            for (Thread t : initThreads) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        this.noReceiveOnStart = noReceiveOnStart;
        this.busname = busname;
    }

    public void init() throws CommandException {
        if (this.dBusConnection != null) {
            throw new AssertionError((Object)"DbusHandler already initialized");
        }
        DBusConnection.DBusBusType busType = this.isDbusSystem ? DBusConnection.DBusBusType.SYSTEM : DBusConnection.DBusBusType.SESSION;
        logger.debug("Starting DBus server on {} bus: {}", (Object)busType, (Object)this.busname);
        try {
            this.dBusConnection = DBusConnectionBuilder.forType((DBusConnection.DBusBusType)busType).build();
            this.dbusRunner.run(this.dBusConnection);
        }
        catch (DBusException e) {
            throw new UnexpectedErrorException("Dbus command failed: " + e.getMessage(), e);
        }
        catch (UnsupportedOperationException e) {
            throw new UserErrorException("Failed to connect to Dbus: " + e.getMessage(), e);
        }
        try {
            this.dBusConnection.requestBusName(this.busname);
        }
        catch (DBusException e) {
            throw new UnexpectedErrorException("Dbus command failed, maybe signal-cli dbus daemon is already running: " + e.getMessage(), e);
        }
        logger.info("Started DBus server on {} bus: {}", (Object)busType, (Object)this.busname);
    }

    @Override
    public void close() throws Exception {
        if (this.dBusConnection == null) {
            return;
        }
        this.dBusConnection.close();
        for (AutoCloseable c : new ArrayList<AutoCloseable>(this.closeables)) {
            c.close();
        }
        this.closeables.clear();
        this.dBusConnection = null;
    }

    private Thread exportDbusObject(DBusConnection conn, String objectPath, Manager m) {
        DbusSignalImpl signal = new DbusSignalImpl(m, conn, objectPath, this.noReceiveOnStart);
        this.closeables.add(signal);
        return Thread.ofPlatform().name("dbus-init-" + m.getSelfNumber()).start(signal::initObjects);
    }

    private Thread exportManager(DBusConnection conn, Manager m) {
        String objectPath = DbusConfig.getObjectPath(m.getSelfNumber());
        return this.exportDbusObject(conn, objectPath, m);
    }

    private static interface DbusRunner {
        public void run(DBusConnection var1) throws DBusException;
    }
}

