/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.output.OutputWriter;

public class FinishChangeNumberCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "finishChangeNumber";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Verify the new number using the code received via SMS or voice.");
        subparser.addArgument(new String[]{"number"}).help("The new phone number in E164 format.").required(true);
        subparser.addArgument(new String[]{"-v", "--verification-code"}).help("The verification code you received via sms or voice call.").required(true);
        subparser.addArgument(new String[]{"-p", "--pin"}).help("The registration lock PIN, that was set by the user (Optional)");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String newNumber = ns.getString("number");
        String verificationCode = ns.getString("verification-code");
        String pin = ns.getString("pin");
        try {
            m.finishChangeNumber(newNumber, verificationCode, pin);
        }
        catch (PinLockedException e) {
            throw new UserErrorException("Verification failed! This number is locked with a pin. Hours remaining until reset: " + e.getTimeRemaining() / 1000L / 60L / 60L + "\nUse '--pin PIN_CODE' to specify the registration lock PIN");
        }
        catch (IncorrectPinException e) {
            throw new UserErrorException("Verification failed! Invalid pin, tries remaining: " + e.getTriesRemaining());
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to change number: %s (%s)".formatted(e.getMessage(), e.getClass().getSimpleName()), e);
        }
    }
}

