/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.Base64Tools;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J$\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/signal/core/util/Base64;", "", "()V", "decode", "", "value", "", "decodeNullableOrThrow", "decodeOrNull", "decodeOrThrow", "encodeUrlSafeWithPadding", "bytes", "encodeUrlSafeWithoutPadding", "encodeWithPadding", "offset", "", "length", "encodeWithoutPadding", "stripPadding", "withPaddingIfNeeded", "core-util-jvm"})
public final class Base64 {
    @NotNull
    public static final Base64 INSTANCE = new Base64();

    private Base64() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String encodeWithPadding(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = Base64Tools.encodeBytes(bytes, offset, length);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBytes(...)");
        return string;
    }

    public static /* synthetic */ String encodeWithPadding$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return Base64.encodeWithPadding(byArray, n, n2);
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithoutPadding(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = Base64Tools.encodeBytes(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBytes(...)");
        return INSTANCE.stripPadding(string);
    }

    @JvmStatic
    @NotNull
    public static final String encodeUrlSafeWithPadding(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = Base64Tools.encodeBytes(bytes, 20);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBytes(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String encodeUrlSafeWithoutPadding(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = Base64Tools.encodeBytes(bytes, 20);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBytes(...)");
        return INSTANCE.stripPadding(string);
    }

    @JvmStatic
    @NotNull
    public static final byte[] decode(@NotNull String value) throws IOException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.contains$default((CharSequence)value, (char)'-', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)value, (char)'_', (boolean)false, (int)2, null)) {
            byte[] byArray2 = Base64Tools.decode(INSTANCE.withPaddingIfNeeded(value), 20);
            Intrinsics.checkNotNull((Object)byArray2);
            byArray = byArray2;
        } else {
            byte[] byArray3 = Base64Tools.decode(INSTANCE.withPaddingIfNeeded(value));
            Intrinsics.checkNotNull((Object)byArray3);
            byArray = byArray3;
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decode(@NotNull byte[] value) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            byArray = Base64.decode(new String(value, Charsets.US_ASCII));
        }
        catch (UnsupportedEncodingException e) {
            byArray = Base64.decode(new String(value, Charsets.UTF_8));
        }
        return byArray;
    }

    @JvmStatic
    @Nullable
    public static final byte[] decodeOrNull(@Nullable String value) {
        byte[] byArray;
        if (value == null) {
            return null;
        }
        try {
            byArray = Base64.decode(value);
        }
        catch (IOException e) {
            byArray = null;
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decodeOrThrow(@NotNull String value) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            byArray = Base64.decode(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return byArray;
    }

    @JvmStatic
    @Nullable
    public static final byte[] decodeNullableOrThrow(@Nullable String value) {
        byte[] byArray;
        if (value == null) {
            return null;
        }
        try {
            byArray = Base64.decode(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return byArray;
    }

    private final String withPaddingIfNeeded(String $this$withPaddingIfNeeded) {
        return switch ($this$withPaddingIfNeeded.length() % 4) {
            case 2 -> $this$withPaddingIfNeeded + "==";
            case 3 -> $this$withPaddingIfNeeded + "=";
            default -> $this$withPaddingIfNeeded;
        };
    }

    private final String stripPadding(String $this$stripPadding) {
        return StringsKt.replace$default((String)$this$stripPadding, (String)"=", (String)"", (boolean)false, (int)4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String encodeWithPadding(@NotNull byte[] bytes, int offset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return Base64.encodeWithPadding$default(bytes, offset, 0, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String encodeWithPadding(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return Base64.encodeWithPadding$default(bytes, 0, 0, 6, null);
    }
}

