/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.VelocityConstants;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public class EncryptionRequest
implements MinecraftPacket {
    private String serverId = "";
    private byte[] publicKey = VelocityConstants.EMPTY_BYTE_ARRAY;
    private byte[] verifyToken = VelocityConstants.EMPTY_BYTE_ARRAY;

    public byte[] getPublicKey() {
        return (byte[])this.publicKey.clone();
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = (byte[])publicKey.clone();
    }

    public byte[] getVerifyToken() {
        return (byte[])this.verifyToken.clone();
    }

    public void setVerifyToken(byte[] verifyToken) {
        this.verifyToken = (byte[])verifyToken.clone();
    }

    public String toString() {
        return "EncryptionRequest{publicKey=" + Arrays.toString(this.publicKey) + ", verifyToken=" + Arrays.toString(this.verifyToken) + '}';
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.serverId = ProtocolUtils.readString(buf, 20);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.publicKey = ProtocolUtils.readByteArray(buf, 256);
            this.verifyToken = ProtocolUtils.readByteArray(buf, 16);
        } else {
            this.publicKey = ProtocolUtils.readByteArray17(buf);
            this.verifyToken = ProtocolUtils.readByteArray17(buf);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        ProtocolUtils.writeString(buf, this.serverId);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            ProtocolUtils.writeByteArray(buf, this.publicKey);
            ProtocolUtils.writeByteArray(buf, this.verifyToken);
        } else {
            ProtocolUtils.writeByteArray17(this.publicKey, buf, false);
            ProtocolUtils.writeByteArray17(this.verifyToken, buf, false);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

