/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.network;

import com.velocitypowered.proxy.util.concurrent.VelocityNettyThreadFactory;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;

enum TransportType {
    NIO("NIO", NioServerSocketChannel::new, NioSocketChannel::new, NioDatagramChannel::new, (name, type) -> new NioEventLoopGroup(0, TransportType.createThreadFactory(name, type))),
    EPOLL("epoll", EpollServerSocketChannel::new, EpollSocketChannel::new, EpollDatagramChannel::new, (name, type) -> new EpollEventLoopGroup(0, TransportType.createThreadFactory(name, type)));

    final String name;
    final ChannelFactory<? extends ServerSocketChannel> serverSocketChannelFactory;
    final ChannelFactory<? extends SocketChannel> socketChannelFactory;
    final ChannelFactory<? extends DatagramChannel> datagramChannelFactory;
    final BiFunction<String, Type, EventLoopGroup> eventLoopGroupFactory;

    private TransportType(String name, ChannelFactory<? extends ServerSocketChannel> serverSocketChannelFactory, ChannelFactory<? extends SocketChannel> socketChannelFactory, ChannelFactory<? extends DatagramChannel> datagramChannelFactory, BiFunction<String, Type, EventLoopGroup> eventLoopGroupFactory) {
        this.name = name;
        this.serverSocketChannelFactory = serverSocketChannelFactory;
        this.socketChannelFactory = socketChannelFactory;
        this.datagramChannelFactory = datagramChannelFactory;
        this.eventLoopGroupFactory = eventLoopGroupFactory;
    }

    public String toString() {
        return this.name;
    }

    public EventLoopGroup createEventLoopGroup(Type type) {
        return this.eventLoopGroupFactory.apply(this.name, type);
    }

    private static ThreadFactory createThreadFactory(String name, Type type) {
        return new VelocityNettyThreadFactory("Netty " + name + ' ' + type.toString() + " #%d");
    }

    public static TransportType bestType() {
        if (Boolean.getBoolean("velocity.disable-native-transport")) {
            return NIO;
        }
        if (Epoll.isAvailable()) {
            return EPOLL;
        }
        return NIO;
    }

    public static enum Type {
        BOSS("Boss"),
        WORKER("Worker");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

