/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.SecondaryStructure;
import driftwood.star.DataCell;
import java.io.IOException;
import java.util.List;

class CifSecondaryStructure
extends SecondaryStructure {
    public CifSecondaryStructure(DataCell dataCell) throws IOException {
        this.doStructConf(dataCell);
        this.doStructSheet(dataCell);
    }

    void doStructConf(DataCell dataCell) throws IOException {
        List list = dataCell.getItem("_struct_conf.conf_type_id");
        List list2 = dataCell.getItem("_struct_conf.beg_auth_asym_id");
        List list3 = dataCell.getItem("_struct_conf.beg_auth_seq_id");
        List list4 = dataCell.getItem("_struct_conf.end_auth_asym_id");
        List list5 = dataCell.getItem("_struct_conf.end_auth_seq_id");
        int n = list.size();
        if (n == 0) {
            return;
        }
        if (list2.size() != n || list3.size() != n || list4.size() != n || list5.size() != n) {
            throw new IOException("Elements in struct_conf disagree in length");
        }
        for (int i = 0; i < n; ++i) {
            String string;
            SecondaryStructure.Range range = new SecondaryStructure.Range();
            String string2 = (String)list.get(i);
            range.type = string2.startsWith("HELX") ? HELIX : (string2.startsWith("TURN") ? TURN : (string2.startsWith("STRN") ? STRAND : COIL));
            String string3 = (String)list2.get(i);
            if (!string3.equals(string = (String)list4.get(i))) {
                System.err.println("Mismatched asym (chain) IDs (row " + (i + 1) + ")");
            }
            range.chainId = string3;
            try {
                range.initSeqNum = Integer.parseInt(((String)list3.get(i)).trim());
                range.endSeqNum = Integer.parseInt(((String)list5.get(i)).trim());
                this.addRange(range);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Non-numeric sequence numbers (row " + (i + 1) + ")");
            }
        }
    }

    void doStructSheet(DataCell dataCell) throws IOException {
        List list = dataCell.getItem("_struct_sheet_range.beg_auth_asym_id");
        List list2 = dataCell.getItem("_struct_sheet_range.beg_auth_seq_id");
        List list3 = dataCell.getItem("_struct_sheet_range.end_auth_asym_id");
        List list4 = dataCell.getItem("_struct_sheet_range.end_auth_seq_id");
        int n = list2.size();
        if (n == 0) {
            return;
        }
        if (list.size() != n || list2.size() != n || list3.size() != n || list4.size() != n) {
            throw new IOException("Elements in struct_sheet_range disagree in length");
        }
        for (int i = 0; i < n; ++i) {
            String string;
            SecondaryStructure.Range range = new SecondaryStructure.Range();
            range.type = STRAND;
            String string2 = (String)list.get(i);
            if (!string2.equals(string = (String)list3.get(i))) {
                System.err.println("Mismatched asym (chain) IDs (row " + (i + 1) + ")");
            }
            range.chainId = string2;
            try {
                range.initSeqNum = Integer.parseInt(((String)list2.get(i)).trim());
                range.endSeqNum = Integer.parseInt(((String)list4.get(i)).trim());
                this.addRange(range);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Non-numeric sequence numbers (row " + (i + 1) + ")");
            }
        }
    }
}

