/*
 * Decompiled with CFR 0.152.
 */
package dangle;

import dangle.AtomSpec;
import dangle.Measurement;
import dangle.XyzSpec;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeomKinSmith {
    final DecimalFormat df1 = new DecimalFormat("0.##");
    final DecimalFormat df2 = new DecimalFormat("#.###");
    final DecimalFormat df3 = new DecimalFormat("#.##");
    ArrayList<String> lengths;
    ArrayList<String> angles;
    ArrayList<String> cbdevs;
    Measurement[] meas;
    String label;
    CoordinateFile coords;
    boolean subgroup;
    boolean doHets;
    double sigmaCutoff;
    TreeSet resnums;

    public GeomKinSmith(String string, CoordinateFile coordinateFile, ArrayList<Measurement> arrayList, double d, boolean bl, boolean bl2, TreeSet<Integer> treeSet) {
        this.label = string;
        this.coords = coordinateFile;
        this.meas = arrayList.toArray(new Measurement[arrayList.size()]);
        this.sigmaCutoff = d;
        this.subgroup = bl;
        this.doHets = bl2;
        this.resnums = treeSet;
    }

    public void makeKin() {
        for (Model model : this.coords.getModels()) {
            ModelState modelState = model.getState();
            this.lengths = new ArrayList();
            this.angles = new ArrayList();
            this.cbdevs = new ArrayList();
            for (Residue residue : model.getResidues()) {
                boolean bl;
                if (this.resnums != null && !this.resnums.contains(residue.getSequenceInteger()) || !(bl = true)) continue;
                for (int i = 0; i < this.meas.length; ++i) {
                    Measurement measurement;
                    if (this.meas[i] instanceof Measurement.Group) {
                        measurement = (Measurement.Group)this.meas[i];
                        this.groupOutput(model, modelState, residue, (Measurement.Group)measurement);
                        continue;
                    }
                    measurement = this.meas[i];
                    this.nonGroupOutput(model, modelState, residue, measurement);
                }
            }
            this.printModel(model);
        }
    }

    public void groupOutput(Model model, ModelState modelState, Residue residue, Measurement.Group group) {
        boolean bl = false;
        for (Measurement measurement : (ArrayList)group.group) {
            double d = measurement.measure(model, modelState, residue, this.doHets);
            double d2 = measurement.getDeviation();
            double d3 = measurement.mean;
            if (Double.isNaN(d) || bl) continue;
            bl = true;
            if (Double.isNaN(d3)) {
                if (measurement.getType().equals(Measurement.TYPE_DISTANCE) && measurement.getLabel().equals("cbdev")) {
                    this.cbDevImpl(measurement, model, modelState, residue, d);
                    continue;
                }
                if (!measurement.getType().equals(Measurement.TYPE_BASEPPERP)) continue;
                this.pPerpImpl(measurement, model, modelState, residue, d);
                continue;
            }
            if (Double.isNaN(d2) || !(Math.abs(d2) >= this.sigmaCutoff)) continue;
            if (measurement.getType().equals(Measurement.TYPE_DISTANCE)) {
                this.lengthImpl(measurement, model, modelState, residue, d, d3, d2);
                continue;
            }
            if (!measurement.getType().equals(Measurement.TYPE_ANGLE)) continue;
            this.angleImpl(measurement, model, modelState, residue, d, d3, d2);
        }
    }

    public void nonGroupOutput(Model model, ModelState modelState, Residue residue, Measurement measurement) {
        double d = measurement.measure(model, modelState, residue, this.doHets);
        double d2 = measurement.getDeviation();
        double d3 = measurement.mean;
        if (Double.isNaN(d3)) {
            if (measurement.getType().equals(Measurement.TYPE_DISTANCE) && measurement.getLabel().equals("cbdev")) {
                this.cbDevImpl(measurement, model, modelState, residue, d);
            } else if (measurement.getType().equals(Measurement.TYPE_BASEPPERP)) {
                this.pPerpImpl(measurement, model, modelState, residue, d);
            }
        } else if (!Double.isNaN(d2) && Math.abs(d2) >= this.sigmaCutoff) {
            if (measurement.getType().equals(Measurement.TYPE_DISTANCE)) {
                this.lengthImpl(measurement, model, modelState, residue, d, d3, d2);
            } else if (measurement.getType().equals(Measurement.TYPE_ANGLE)) {
                this.angleImpl(measurement, model, modelState, residue, d, d3, d2);
            }
        }
    }

    protected String getName(AtomSpec atomSpec) {
        String string = atomSpec.toString();
        String string2 = string.substring(string.length() - 4);
        int n = 99;
        int n2 = 99;
        for (int i = 0; i < string2.length(); ++i) {
            String string3 = string2.substring(i, i + 1);
            if (!string3.equals("_") && n == 99 && n2 == 99) {
                n = i;
                continue;
            }
            if (!string3.equals("_") || n == 99 || n2 != 99) continue;
            n2 = i;
        }
        if (n2 == 99) {
            return string2.substring(n);
        }
        return string2.substring(n, n2);
    }

    protected void lengthImpl(Measurement measurement, Model model, ModelState modelState, Residue residue, double d, double d2, double d3) {
        Object object5;
        Measurement.Distance distance = (Measurement.Distance)measurement;
        AtomSpec atomSpec = (AtomSpec)distance.getA();
        AtomSpec atomSpec2 = (AtomSpec)distance.getB();
        String string = this.getName(atomSpec);
        String string2 = this.getName(atomSpec2);
        Residue residue2 = atomSpec.getRes(model, modelState, residue);
        Residue residue3 = atomSpec2.getRes(model, modelState, residue);
        if (atomSpec.getResOffset() == -1) {
            residue2 = residue.getPrev(model);
        }
        if (atomSpec.getResOffset() == 1) {
            residue2 = residue.getNext(model);
        }
        if (atomSpec2.getResOffset() == -1) {
            residue3 = residue.getPrev(model);
        }
        if (atomSpec2.getResOffset() == 1) {
            residue3 = residue.getNext(model);
        }
        Object object2 = null;
        Object object3 = null;
        for (Object object4 : residue2.getAtoms()) {
            if (!((Atom)object4).getName().trim().equals(string.trim()) && !((Atom)object4).getName().trim().equals(string.trim().replace('*', '\'')) && !((Atom)object4).getName().trim().equals(string.trim().replace('\'', '*'))) continue;
            object2 = object4;
        }
        for (Object object5 : residue3.getAtoms()) {
            if (!((Atom)object5).getName().trim().equals(string2.trim()) && !((Atom)object5).getName().trim().equals(string2.trim().replace('*', '\'')) && !((Atom)object5).getName().trim().equals(string2.trim().replace('\'', '*'))) continue;
            object3 = object5;
        }
        object5 = null;
        AtomState atomState = null;
        try {
            object5 = modelState.get((Atom)object2);
            atomState = modelState.get((Atom)object3);
        }
        catch (AtomException atomException) {
            System.err.println("Couldn't get AtomState");
        }
        String string3 = this.label.substring(0, 4) + " " + residue2.getName() + residue2.getSequenceInteger() + "-" + residue3.getName() + residue3.getSequenceInteger() + " " + ((Atom)object2).getName().trim() + "-" + ((Atom)object3).getName().trim() + " " + this.df2.format(d3) + " sigma";
        Triple triple = new Triple(((Triple)object5).getX(), ((Triple)object5).getY(), ((Triple)object5).getZ());
        Triple triple2 = new Triple(atomState.getX(), atomState.getY(), atomState.getZ());
        this.addSpring(string3, triple, triple2, d, d2, d3);
    }

    public void addSpring(String string, Triple triple, Triple triple2, double d, double d2, double d3) {
        Triple triple3 = new Triple(triple.getX(), triple.getY(), triple.getZ());
        ArrayList<String> arrayList = new ArrayList<String>();
        Triple triple4 = new Triple(triple2.getX() - triple.getX(), triple2.getY() - triple.getY(), triple2.getZ() - triple.getZ());
        Triple triple5 = new Triple(1.0, 0.0, 0.0);
        Triple triple6 = new Triple().likeNormal(triple, triple2, triple5);
        triple6.mult(0.2);
        String string2 = "red";
        if (d - d2 < 0.0) {
            string2 = "blue";
        }
        arrayList.add("@vectorlist {" + string + "} color= " + string2 + " width= " + 3 + " master= {length dev}");
        arrayList.add("{" + string + "}P U " + this.df2.format(triple.getX()) + " " + this.df2.format(triple.getY()) + " " + this.df2.format(triple.getZ()));
        arrayList.add("{" + string + "}  U " + this.df2.format(triple.getX() + triple6.getX()) + " " + this.df2.format(triple.getY() + triple6.getY()) + " " + this.df2.format(triple.getZ() + triple6.getZ()));
        double d4 = triple.getX() + triple6.getX();
        double d5 = triple.getY() + triple6.getY();
        double d6 = triple.getZ() + triple6.getZ();
        Triple triple7 = new Triple(d4, d5, d6);
        double d7 = 36.0;
        if (d3 > 10.0) {
            d3 = 10.0;
        }
        if (d3 < -10.0) {
            d3 = -10.0;
        }
        if (d3 <= 0.0) {
            d7 += 1.5 * Math.abs(d3);
        } else if (d3 > 0.0) {
            d7 -= 1.5 * d3;
        }
        int n = 60;
        double d8 = new Triple(triple2.getX() - triple.getX(), triple2.getY() - triple.getY(), triple2.getZ() - triple.getZ()).mag();
        Triple triple8 = triple6;
        for (int i = 1; i <= n; ++i) {
            triple = new Triple(triple3.getX(), triple3.getY(), triple3.getZ());
            triple4 = new Triple().likeVector(triple, triple2);
            Transform object = new Transform();
            object = object.likeRotation(triple4, d7);
            object.transform(triple8);
            Triple triple9 = new Triple(triple4.getX(), triple4.getY(), triple4.getZ());
            triple9.div(n);
            triple8.add(triple9);
            Triple triple10 = triple.add(triple8);
            arrayList.add("{" + string + "} U " + this.df2.format(triple10.getX()) + " " + this.df2.format(triple10.getY()) + " " + this.df2.format(triple10.getZ()));
        }
        arrayList.add("{" + string + "} U " + this.df2.format(triple2.getX()) + " " + this.df2.format(triple2.getY()) + " " + this.df2.format(triple2.getZ()));
        for (String string3 : arrayList) {
            this.lengths.add(string3);
        }
    }

    protected void angleImpl(Measurement measurement, Model model, ModelState modelState, Residue residue, double d, double d2, double d3) {
        Measurement.Angle angle = (Measurement.Angle)measurement;
        AtomSpec atomSpec = angle.getA();
        AtomSpec atomSpec2 = angle.getB();
        AtomSpec atomSpec3 = angle.getC();
        AtomState atomState = atomSpec.get(model, modelState, residue);
        AtomState atomState2 = atomSpec2.get(model, modelState, residue);
        AtomState atomState3 = atomSpec3.get(model, modelState, residue);
        String string = this.label.substring(0, 4) + " " + residue.getName() + " " + residue.getSequenceInteger() + " " + atomState.getName().trim() + "-" + atomState2.getName().trim() + "-" + atomState3.getName().trim() + " " + this.df2.format(d3) + " sigma";
        this.addFan(string, atomState, atomState2, atomState3, d, d2);
    }

    public void addFan(String string, Triple triple, Triple triple2, Triple triple3, double d, double d2) {
        String string2 = "red";
        if (d - d2 < 0.0) {
            string2 = "blue";
        }
        Triple triple4 = new Triple().likeVector(triple2, triple);
        Triple triple5 = triple4.mult(0.75).add(triple2);
        String string3 = "@vectorlist {" + string + "} color= " + string2 + " width= " + 4 + " master= {angle dev}";
        String string4 = "{" + string + "}P U " + this.df2.format(triple5.getX()) + " " + this.df2.format(triple5.getY()) + " " + this.df2.format(triple5.getZ());
        String string5 = "{" + string + "}  U " + this.df2.format(triple2.getX()) + " " + this.df2.format(triple2.getY()) + " " + this.df2.format(triple2.getZ());
        this.angles.add(string3);
        this.angles.add(string4);
        this.angles.add(string5);
        this.addBlur(string, triple, triple2, triple3, d, d2);
    }

    public void addBlur(String string, Triple triple, Triple triple2, Triple triple3, double d, double d2) {
        Triple triple4 = new Triple().likeNormal(triple, triple2, triple3);
        Transform transform = new Transform();
        transform = transform.likeRotation(triple4, (d - d2) * 1.0);
        Transform transform2 = new Transform();
        transform2 = transform2.likeRotation(triple4, (d - d2) * 0.75);
        Transform transform3 = new Transform();
        transform3 = transform3.likeRotation(triple4, (d - d2) * 0.5);
        Transform transform4 = new Transform();
        transform4 = transform4.likeRotation(triple4, (d - d2) * 0.25);
        Triple triple5 = new Triple().likeVector(triple2, triple3);
        Triple triple6 = new Triple().likeVector(triple2, triple3);
        Triple triple7 = new Triple().likeVector(triple2, triple3);
        Triple triple8 = new Triple().likeVector(triple2, triple3);
        transform.transform(triple5);
        transform2.transform(triple6);
        transform3.transform(triple7);
        transform4.transform(triple8);
        Triple triple9 = triple5.mult(0.75).add(triple2);
        Triple triple10 = triple6.mult(0.75).add(triple2);
        Triple triple11 = triple7.mult(0.75).add(triple2);
        Triple triple12 = triple8.mult(0.75).add(triple2);
        String string2 = "red";
        if (d - d2 < 0.0) {
            string2 = "blue";
        }
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        arrayList.add(triple9);
        arrayList.add(triple10);
        arrayList.add(triple11);
        arrayList.add(triple12);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = "@vectorlist {" + string + "} color= " + string2 + " width= " + (4 - i) + " master= {angle dev}";
            Triple triple13 = (Triple)arrayList.get(i);
            String string4 = "{" + string + "}P U " + this.df2.format(triple2.getX()) + " " + this.df2.format(triple2.getY()) + " " + this.df2.format(triple2.getZ());
            String string5 = "{" + string + "}  U " + this.df2.format(triple13.getX()) + " " + this.df2.format(triple13.getY()) + " " + this.df2.format(triple13.getZ());
            this.angles.add(string3);
            this.angles.add(string4);
            this.angles.add(string5);
        }
    }

    protected void cbDevImpl(Measurement measurement, Model model, ModelState modelState, Residue residue, double d) {
        double d2 = 0.25;
        if (d > d2) {
            Measurement.Distance distance = (Measurement.Distance)measurement;
            AtomSpec atomSpec = (AtomSpec)distance.getA();
            AtomState atomState = atomSpec.get(model, modelState, residue);
            XyzSpec.IdealTetrahedral idealTetrahedral = (XyzSpec.IdealTetrahedral)distance.getB();
            Triple triple = (Triple)idealTetrahedral.get(model, modelState, residue);
            String string = this.label.substring(0, 4) + " " + residue + " Cbeta dev " + this.df3.format(d) + "A";
            this.addBall(string, triple, d);
        }
    }

    protected void addBall(String string, Triple triple, double d) {
        String string2 = "@balllist {" + string + "} color= magenta radius= " + this.df2.format(d) + " master= {Cbeta dev}";
        String string3 = "{" + string + "} " + this.df2.format(triple.getX()) + " " + this.df2.format(triple.getY()) + " " + this.df2.format(triple.getZ());
        this.cbdevs.add(string2);
        this.cbdevs.add(string3);
    }

    protected void pPerpImpl(Measurement measurement, Model model, ModelState modelState, Residue residue, double d) {
        throw new IllegalArgumentException("Base-phosphate perpendicular visualizations not yet implemented!");
    }

    public void printModel(Model model) {
        System.out.println("@master {length dev} on");
        System.out.println("@master {angle dev} on");
        System.out.println("@master {Cbeta dev} on");
        boolean bl = this.coords.getModels().size() > 1;
        System.out.println((this.subgroup ? "@subgroup" : "@group") + " {" + this.label.substring(0, 4) + (bl ? " " + model.getName() : "") + " geom devs} dominant" + (bl ? " master= {all models}" : ""));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < this.meas.length; ++i) {
            if (this.meas[i].getType().equals(Measurement.TYPE_DISTANCE) && this.meas[i].getLabel().equals("cbdev")) {
                bl4 = true;
                continue;
            }
            if (this.meas[i].getType().equals(Measurement.TYPE_DISTANCE)) {
                bl2 = true;
                continue;
            }
            if (!this.meas[i].getType().equals(Measurement.TYPE_ANGLE)) continue;
            bl3 = true;
        }
        if (!bl2) {
            System.err.println("(Didn't look for bond length outliers)");
        } else if (this.lengths.isEmpty()) {
            System.err.println("No bond length outliers (in selected residues)");
        } else {
            for (String string : this.lengths) {
                System.out.println(string);
            }
        }
        if (!bl3) {
            System.err.println("(Didn't look for bond angle outliers)");
        } else if (this.angles.isEmpty()) {
            System.err.println("No bond angle outliers (in selected residues)");
        } else {
            for (String string : this.angles) {
                System.out.println(string);
            }
        }
        if (!bl4) {
            System.err.println("(Didn't look for Cbeta dev outliers)");
        } else if (this.cbdevs.isEmpty()) {
            System.err.println("No Cbeta dev outliers (in selected residues)");
        } else {
            for (String string : this.cbdevs) {
                System.out.println(string);
            }
        }
    }
}

