/*
 * Decompiled with CFR 0.152.
 */
package driftwood.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public class CharWindow
implements CharSequence {
    public static final int KILOCHAR = 1024;
    public static final int MEGACHAR = 0x100000;
    Reader reader;
    long prevChars = 0L;
    int lineAtZero = 0;
    int colAtZero = 0;
    int dataLen = 0;
    int dataMin = 0;
    long bufMask;
    char[] buffer;

    public CharWindow(Reader reader) throws IOException {
        this(reader, 16384);
    }

    public CharWindow(Reader reader, int n) throws IOException {
        int n2;
        int n3;
        for (n3 = 16; n3 < n; n3 <<= 1) {
        }
        this.buffer = new char[n3 <<= 1];
        this.bufMask = n3 - 1;
        this.reader = reader;
        this.dataLen = 0;
        while (this.dataLen < n3 / 2 && (n2 = reader.read()) != -1) {
            this.buffer[(int)((long)this.dataLen & this.bufMask)] = (char)n2;
            ++this.dataLen;
        }
    }

    public CharWindow(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream));
    }

    public CharWindow(InputStream inputStream, int n) throws IOException {
        this(new InputStreamReader(inputStream), n);
    }

    public CharWindow(String string) throws IOException {
        this(new StringReader(string), string.length());
    }

    public CharWindow(File file) throws IOException {
        this(new FileReader(file));
    }

    public CharWindow(File file, int n) throws IOException {
        this(new FileReader(file), n);
    }

    public CharWindow(URL uRL) throws IOException {
        this(uRL.openStream());
    }

    public CharWindow(URL uRL, int n) throws IOException {
        this(uRL.openStream(), n);
    }

    public char charAt(int n) {
        if (n < this.dataMin || n >= this.dataLen) {
            throw new IndexOutOfBoundsException("Current range is [" + this.dataMin + ", " + this.dataLen + "); can't get " + n);
        }
        return this.buffer[(int)(this.prevChars + (long)n & this.bufMask)];
    }

    public int length() {
        return this.dataLen;
    }

    public char read() throws IOException {
        char c = this.buffer[(int)(this.prevChars & this.bufMask)];
        if (c == '\n') {
            ++this.lineAtZero;
            this.colAtZero = 0;
        } else {
            ++this.colAtZero;
        }
        int n = this.reader.read();
        if (n == -1) {
            --this.dataLen;
        } else {
            this.buffer[(int)(this.prevChars + (long)this.dataLen & this.bufMask)] = (char)n;
        }
        ++this.prevChars;
        this.dataMin = (int)Math.max(-this.prevChars, (long)(this.dataLen - this.buffer.length));
        return c;
    }

    public void advance(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Can't advance backwards!");
        }
        for (int i = 0; i < n; ++i) {
            this.read();
        }
    }

    public String toString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(this.charAt(i));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0, this.dataLen);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.toString(n, n2);
    }

    public int lineAt(int n) {
        int n2 = this.lineAtZero;
        for (int i = 0; i < n; ++i) {
            if (this.charAt(i) != '\n') continue;
            ++n2;
        }
        return n2 + 1;
    }

    public int columnAt(int n) {
        int n2 = this.colAtZero;
        for (int i = 0; i < n; ++i) {
            if (this.charAt(i) == '\n') {
                n2 = 0;
                continue;
            }
            ++n2;
        }
        return n2 + 1;
    }

    public String contextAt(int n) {
        int n2;
        int n3;
        for (n3 = n; n3 > this.dataMin && this.charAt(n3 - 1) != '\n'; --n3) {
        }
        for (n2 = n; n2 < this.dataLen && this.charAt(n2) != '\n'; ++n2) {
        }
        return this.toString(n3, n2);
    }

    public boolean startsWith(CharSequence charSequence, int n) {
        int n2 = this.length() - n;
        int n3 = charSequence.length();
        if (n3 > n2) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.charAt(n++) == charSequence.charAt(n4++)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, 0);
    }

    public static void main(String[] stringArray) throws Exception {
        CharWindow charWindow = new CharWindow(new InputStreamReader(System.in));
        int n = 0;
        while (charWindow.length() > n) {
            char c = charWindow.charAt(n++);
            System.out.println("% got 0x" + Integer.toHexString(c));
            if (c != '\n') continue;
            System.out.println("> " + charWindow.subSequence(0, n - 1));
            charWindow.advance(n);
            System.out.println("> len = " + charWindow.length());
            n = 0;
        }
    }
}

