/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.NDFloatTable;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NdftToPgm {
    public void Main() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(System.in));
        NDFloatTable nDFloatTable = new NDFloatTable(dataInputStream);
        if (nDFloatTable.getDimensions() != 2) {
            throw new IllegalArgumentException("Must provide a 2-D NDFT");
        }
        int[] nArray = nDFloatTable.getBins();
        int n = nArray[0];
        int n2 = nArray[1];
        double d = Math.log((double)nDFloatTable.maxValue() + 1.0);
        System.out.println("P5");
        System.out.println(n + " " + n2);
        System.out.println(65535);
        DataOutputStream dataOutputStream = new DataOutputStream(System.out);
        int[] nArray2 = new int[2];
        nArray2[1] = n2 - 1;
        while (nArray2[1] >= 0) {
            nArray2[0] = 0;
            while (nArray2[0] < n) {
                double d2 = Math.log((double)nDFloatTable.valueAt(nArray2) + 1.0) / d;
                int n3 = (int)Math.round(65535.0 * d2);
                if (n3 > 65535) {
                    n3 = 65535;
                } else if (n3 < 0) {
                    n3 = 0;
                }
                dataOutputStream.writeChar(n3);
                nArray2[0] = nArray2[0] + 1;
            }
            nArray2[1] = nArray2[1] - 1;
        }
        dataOutputStream.flush();
    }

    public static void main(String[] stringArray) {
        NdftToPgm ndftToPgm = new NdftToPgm();
        try {
            ndftToPgm.parseArguments(stringArray);
            ndftToPgm.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            ndftToPgm.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("NdftToPgm.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'NdftToPgm.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.rotarama.NdftToPgm");
        System.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

