/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.BgKinRunner;
import chiropraxis.kingtools.ExpectedNoePanel;
import chiropraxis.kingtools.FastModelOpen;
import chiropraxis.kingtools.ModelPlotter;
import chiropraxis.kingtools.NoePanel;
import chiropraxis.kingtools.Remodeler;
import driftwood.data.CheapSet;
import driftwood.data.IdentityHashFunction;
import driftwood.gui.AttentiveTextField;
import driftwood.gui.FoldingBox;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.gui.TablePane;
import driftwood.gui.TablePane2;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.util.SoftLog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import king.KingMain;
import king.Plugin;
import king.ToolBox;
import king.core.AHE;
import king.core.KGroup;
import king.core.KPaint;
import king.core.KPalette;
import king.core.Kinemage;

public class ModelManager2
extends Plugin {
    File srcfile = null;
    CoordinateFile srccoordfile = null;
    Model srcmodel = null;
    LinkedList stateList = new LinkedList();
    ModelState moltenState = null;
    File moltenPDB = null;
    Collection registeredTools = new ArrayList();
    Map moltenRes = new HashMap();
    Set allMoltenRes = new HashSet();
    BgKinRunner probePlotter = null;
    File noeFile = null;
    String noeFormat = "xplor";
    NoePanel noePanel;
    ExpectedNoePanel expNoePanel;
    SuffixFileFilter pdbFilter;
    SuffixFileFilter rotFilter;
    SuffixFileFilter noeFilter;
    JFileChooser openChooser;
    JFileChooser saveChooser;
    JFileChooser noeChooser;
    FastModelOpen fastModelOpen;
    JCheckBox cbUseSegID;
    boolean changedSinceSave = false;
    JDialog dialog;
    JLabel lblFileName;
    JLabel lblNumMolten;
    JMenuItem miUndo;
    JCheckBox cbShowProbe;
    JCheckBox cbShowNOEs;
    JCheckBox cbShowExpNOEs;
    AttentiveTextField tfProbeCmd;

    public ModelManager2(ToolBox toolBox) {
        super(toolBox);
        this.buildFileChoosers();
        this.buildDialog();
    }

    private void buildFileChoosers() {
        this.pdbFilter = new SuffixFileFilter("Protein Data Bank (PDB) files");
        this.pdbFilter.addSuffix(".pdb");
        this.rotFilter = new SuffixFileFilter("Rotated-coordinate files");
        this.rotFilter.addSuffix(".rot");
        this.noeFilter = new SuffixFileFilter("NOE files");
        this.noeFilter.addSuffix(".noe");
        this.noeFilter.addSuffix(".tbl");
        this.noeFilter.addSuffix(".list");
        this.noeFilter.addSuffix(".upl");
        String string = System.getProperty("user.dir");
        this.openChooser = new JFileChooser();
        this.openChooser.addChoosableFileFilter(this.pdbFilter);
        this.openChooser.setFileFilter(this.pdbFilter);
        if (string != null) {
            this.openChooser.setCurrentDirectory(new File(string));
        }
        this.cbUseSegID = new JCheckBox("Use SegID to define chains", false);
        this.openChooser.setAccessory(this.cbUseSegID);
        this.saveChooser = new JFileChooser();
        this.saveChooser.setFileFilter(this.rotFilter);
        if (string != null) {
            this.saveChooser.setCurrentDirectory(new File(string));
        }
        this.noeChooser = new JFileChooser();
        this.noeChooser.addChoosableFileFilter(this.noeFilter);
        this.noeChooser.setFileFilter(this.noeFilter);
        if (string != null) {
            this.noeChooser.setCurrentDirectory(new File(string));
        }
    }

    private void buildDialog() {
        this.lblFileName = new JLabel();
        this.lblNumMolten = new JLabel();
        ReflectiveAction reflectiveAction = new ReflectiveAction("Update visualizations", null, (Object)this, "onUpdateVis");
        this.cbShowProbe = new JCheckBox("Probe dots", false);
        this.cbShowProbe.addActionListener(reflectiveAction);
        this.tfProbeCmd = new AttentiveTextField("", 25);
        this.tfProbeCmd.addActionListener(new ReflectiveAction("edit-probe-cmd", null, (Object)this, "onEditProbeCmd"));
        JButton jButton = new JButton(">");
        jButton.addActionListener(new ReflectiveAction("edit-probe-cmd", null, (Object)this, "onEditProbeCmd"));
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.hfill(true).addCell(this.tfProbeCmd).weights(0.0, 0.0).addCell(jButton);
        FoldingBox foldingBox = new FoldingBox(this.cbShowProbe, (Component)tablePane2);
        foldingBox.setAutoPack(true);
        foldingBox.setIndent(10);
        this.cbShowNOEs = new JCheckBox("NOEs", false);
        this.cbShowNOEs.addActionListener(reflectiveAction);
        this.noePanel = new NoePanel(this.kMain, this);
        FoldingBox foldingBox2 = new FoldingBox(this.cbShowNOEs, (Component)this.noePanel);
        foldingBox2.setAutoPack(true);
        foldingBox2.setIndent(10);
        this.cbShowExpNOEs = new JCheckBox("Expected NOEs", false);
        this.cbShowExpNOEs.addActionListener(reflectiveAction);
        this.expNoePanel = new ExpectedNoePanel(this.kMain, this);
        FoldingBox foldingBox3 = new FoldingBox(this.cbShowExpNOEs, (Component)this.expNoePanel);
        foldingBox3.setAutoPack(true);
        foldingBox3.setIndent(10);
        JCheckBox jCheckBox = new JCheckBox("Fast model open", false);
        this.fastModelOpen = new FastModelOpen(this);
        FoldingBox foldingBox4 = new FoldingBox(jCheckBox, (Component)new JScrollPane(this.fastModelOpen.list));
        foldingBox4.setAutoPack(true);
        foldingBox4.setIndent(10);
        TablePane tablePane = new TablePane();
        tablePane.insets(2).weights(1.0, 0.1);
        tablePane.addCell(this.lblFileName);
        tablePane.newRow();
        tablePane.addCell(this.lblNumMolten);
        tablePane.newRow();
        tablePane.addCell(jCheckBox);
        tablePane.newRow();
        tablePane.save().hfill(true).vfill(true).weights(1.0, 1.0).addCell(foldingBox4).restore();
        tablePane.newRow().addCell(TablePane.strut(0, 2)).newRow();
        tablePane.addCell(this.cbShowProbe);
        tablePane.newRow();
        tablePane.save().hfill(true).vfill(true).addCell(foldingBox).restore();
        tablePane.newRow();
        tablePane.addCell(this.cbShowNOEs);
        tablePane.newRow();
        tablePane.save().hfill(true).vfill(true).addCell(foldingBox2).restore();
        tablePane.newRow();
        tablePane.addCell(this.cbShowExpNOEs);
        tablePane.newRow();
        tablePane.save().hfill(true).vfill(true).addCell(foldingBox3).restore();
        this.dialog = new JDialog(this.kMain.getTopWindow(), this.toString(), false);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setContentPane(tablePane);
        this.dialog.setJMenuBar(this.buildMenus());
        this.refreshGUI();
    }

    private JMenuBar buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("Open PDB file...", null, (Object)this, "onOpenPDB"));
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Open NOE file...", null, (Object)this, "onOpenNOE"));
        jMenuItem.setMnemonic(78);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(new ReflectiveAction("Save PDB file...", null, (Object)this, "onSaveFullPDB"));
        jMenuItem.setMnemonic(83);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem(new ReflectiveAction("Choose alt conf...", null, (Object)this, "onChooseAltConf"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Create new alt conf...", null, (Object)this, "onCreateAltConf"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        this.miUndo = jMenuItem = new JMenuItem(new ReflectiveAction("Undo last change", null, (Object)this, "onUndo"));
        jMenuItem.setMnemonic(85);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        jMenuBar.add(jMenu);
        jMenu.add(this.getHelpMenuItem());
        return jMenuBar;
    }

    protected void refreshGUI() {
        if (this.srcfile != null) {
            String string = "File: " + this.srcfile.getName();
            String string2 = this.getAltConf();
            if (!string2.equals(" ")) {
                string = string + " [" + string2 + "]";
            }
            this.lblFileName.setText(string);
        } else {
            this.lblFileName.setText("File not loaded");
        }
        this.lblNumMolten.setText("Residues checked out: " + this.allMoltenRes.size());
        this.miUndo.setEnabled(this.stateList.size() > 1);
        this.cbShowNOEs.setEnabled(this.noeFile != null);
        this.expNoePanel.refreshGUI();
        this.dialog.pack();
    }

    public void onUpdateVis(ActionEvent actionEvent) {
        if (actionEvent != null) {
            if (actionEvent.getSource() == this.cbShowProbe) {
                this.getProbePlotter().setLastGroupOn(this.cbShowProbe.isSelected());
                this.kCanvas.repaint();
            }
            if (actionEvent.getSource() == this.cbShowNOEs) {
                this.noePanel.getNoePlotter().setLastGroupOn(this.cbShowNOEs.isSelected());
                this.kCanvas.repaint();
            }
            if (actionEvent.getSource() == this.cbShowExpNOEs) {
                this.expNoePanel.getNoePlotter().setLastGroupOn(this.cbShowExpNOEs.isSelected());
                this.kCanvas.repaint();
            }
        }
        this.refreshGUI();
        this.requestStateRefresh();
    }

    public void onOpenPDB(ActionEvent actionEvent) {
        File file;
        if (this.isMolten()) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Can't open a new model while some residues are checked out for modification.", "Sorry!", 0);
            return;
        }
        this.askSavePDB();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null && kinemage.atPdbfile != null && (file = new File(kinemage.atPdbfile)).exists()) {
            this.openChooser.setCurrentDirectory(file);
            this.openChooser.setSelectedFile(file);
        }
        if (0 == this.openChooser.showOpenDialog(this.kMain.getTopWindow())) {
            try {
                file = this.openChooser.getSelectedFile();
                if (file != null && file.exists()) {
                    this.openPDB(file);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An I/O error occurred while loading the file:\n" + iOException.getMessage(), "Sorry!", 0);
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    protected void openPDB(File file) throws IOException {
        Object[] objectArray;
        Model model;
        this.srcfile = file;
        PdbReader pdbReader = new PdbReader();
        pdbReader.setUseSegID(this.cbUseSegID.isSelected());
        this.srccoordfile = pdbReader.read(this.srcfile);
        this.changedSinceSave = false;
        Collection collection = this.srccoordfile.getModels();
        if (collection.size() == 1) {
            model = this.srccoordfile.getFirstModel();
        } else {
            objectArray = collection.toArray();
            model = (Model)JOptionPane.showInputDialog(this.kMain.getTopWindow(), "This file has multiple models. Please choose one:", "Choose model", -1, null, objectArray, objectArray[0]);
            if (model == null) {
                model = this.srccoordfile.getFirstModel();
            }
        }
        objectArray = this.askAltConf(model, "This file has alternate conformations. Please choose one:");
        this.srcmodel = model;
        this.stateList.clear();
        this.setModelAndState(model, (String)objectArray);
        this.fastModelOpen.updateList(this.srcfile.getParentFile(), this.pdbFilter);
        this.refreshGUI();
    }

    String askAltConf(Model model, String string) {
        ArrayList arrayList = new ArrayList(model.getStates().keySet());
        if (arrayList.size() == 1) {
            return (String)arrayList.get(0);
        }
        arrayList.remove(" ");
        Object[] objectArray = arrayList.toArray();
        String string2 = (String)JOptionPane.showInputDialog(this.kMain.getTopWindow(), string, "Choose alt. conf.", -1, null, objectArray, objectArray[0]);
        if (string2 == null) {
            return (String)arrayList.get(0);
        }
        return string2;
    }

    public void onChooseAltConf(ActionEvent actionEvent) {
        Model model = this.getModel();
        if (model == null) {
            return;
        }
        String string = this.askAltConf(model, "This file has alternate conformations. Please choose one:");
        this.setModelAndState(model, string);
    }

    public void onCreateAltConf(ActionEvent actionEvent) {
        Model model = this.getModel();
        if (model == null) {
            return;
        }
        String string = this.askAltConf(model, "Choose a state to base your new alternate conformation on:");
        String string2 = JOptionPane.showInputDialog(this.kMain.getTopWindow(), "What label should be used for the new alternate? (e.g. 'X')", "Name alt. conf.", -1);
        if (string2 == null) {
            return;
        }
        Model model2 = (Model)model.clone();
        HashMap<String, ModelState> hashMap = new HashMap<String, ModelState>(model2.getStates());
        hashMap.put(string2, new ModelState(model.getState(string)));
        model2.setStates(hashMap);
        this.setModelAndState(model2, string2);
        this.addUserMod("Created alternate conformation '" + string2 + "'");
    }

    void askSavePDB() {
        if (this.isMolten() && 1 == JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "Some changes have not been committed and won't be saved. Save anyway?", "Save model?", 0)) {
            return;
        }
        if (this.changedSinceSave && 0 == JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "Save any changes made to the current model?", "Save model?", 0)) {
            this.onSaveFullPDB(null);
        }
    }

    public void onSaveFullPDB(ActionEvent actionEvent) {
        this.saveChooser.resetChoosableFileFilters();
        this.saveChooser.setFileFilter(this.pdbFilter);
        File file = this.srcfile;
        String string = file.getName();
        if (string.endsWith(".pdb")) {
            if (string.length() > 6 && string.charAt(string.length() - 6) == '.') {
                String string2 = string.substring(0, string.length() - 6);
                char c = string.charAt(string.length() - 5);
                if ('0' <= c && c < '9') {
                    c = (char)(c + '\u0001');
                    string = string2 + "." + c + ".pdb";
                } else if (c == '9') {
                    string = string2 + ".a.pdb";
                } else if ('a' <= c && c < 'z') {
                    c = (char)(c + '\u0001');
                    string = string2 + "." + c + ".pdb";
                } else {
                    string = string2 + "." + c + ".1.pdb";
                }
            } else {
                String string3 = string.substring(0, string.length() - 4);
                string = string3 + ".1.pdb";
            }
        }
        this.saveChooser.setSelectedFile(new File(string));
        this.savePDB(true);
    }

    public void savePDB(boolean bl) {
        File file;
        if (!(0 != this.saveChooser.showSaveDialog(this.kMain.getTopWindow()) || (file = this.saveChooser.getSelectedFile()).exists() && 0 != JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file exists -- do you want to overwrite it?", "Overwrite file?", 0))) {
            try {
                PdbWriter pdbWriter = new PdbWriter(file);
                if (!bl) {
                    throw new IOException("Partial save not supported");
                }
                Model model = this.getModel();
                this.adjustAltConfLabels(model);
                this.srccoordfile.replace(this.srcmodel, model);
                pdbWriter.writeCoordinateFile(this.srccoordfile);
                this.srcfile = file;
                this.srcmodel = model;
                this.changedSinceSave = false;
                this.refreshGUI();
                pdbWriter.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An error occurred while saving the file.", "Sorry!", 0);
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    void adjustAltConfLabels(Model model) {
        CheapSet cheapSet = new CheapSet(new IdentityHashFunction());
        for (String string : model.getStates().keySet()) {
            ModelState modelState = (ModelState)model.getStates().get(string);
            for (Residue residue : model.getResidues()) {
                for (Atom atom : residue.getAtoms()) {
                    try {
                        AtomState atomState = modelState.get(atom);
                        if (!cheapSet.add(atomState)) continue;
                        atomState.setAltConf(string);
                    }
                    catch (AtomException atomException) {}
                }
            }
        }
    }

    public void addUserMod(String string) {
        if (!string.startsWith("USER  ")) {
            string = "USER  MOD " + string;
        }
        this.srccoordfile.addHeader("USER  MOD", string);
    }

    public Model getModel() {
        return this.getMSP().getModel();
    }

    public String getAltConf() {
        return this.getMSP().getAltConf();
    }

    public ModelState getFrozenState() {
        return this.getMSP().getState();
    }

    public File getFrozenPDB() {
        return this.getMSP().getPDB();
    }

    protected ModelStatePair getMSP() {
        if (this.stateList.size() < 1) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "This tool requires an active model\nloaded in the Model Manager plugin.\nPlease load one now.", "Please load a model", 1);
            this.onOpenPDB(null);
        }
        if (this.stateList.size() < 1) {
            throw new IllegalStateException("Cannot procede without a model loaded!");
        }
        ModelStatePair modelStatePair = (ModelStatePair)this.stateList.getLast();
        return modelStatePair;
    }

    public ModelState getMoltenState() {
        if (this.moltenState == null) {
            this.requestStateRefresh();
        }
        return this.moltenState;
    }

    public File getMoltenPDB() {
        if (this.moltenPDB == null) {
            try {
                this.moltenPDB = File.createTempFile("king", ".pdb");
                PdbWriter pdbWriter = new PdbWriter(this.moltenPDB);
                pdbWriter.writeResidues(this.allMoltenRes, this.getMoltenState());
                pdbWriter.close();
                this.moltenPDB.deleteOnExit();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
        return this.moltenPDB;
    }

    public void requestStateRefresh() {
        ModelState modelState;
        this.moltenPDB = null;
        this.moltenState = modelState = this.getFrozenState();
        Iterator iterator = this.registeredTools.iterator();
        while (iterator.hasNext()) {
            this.moltenState = ((Remodeler)iterator.next()).updateModelState(this.moltenState);
        }
        this.moltenState = this.moltenState.createCollapsed(modelState);
        this.visualizeMoltenModel();
        if (this.cbShowProbe.isSelected()) {
            this.visualizeProbeDots();
        }
        if (this.cbShowNOEs.isSelected()) {
            this.visualizeNOEs();
        }
        if (this.cbShowExpNOEs.isSelected()) {
            this.visualizeExpectedNOEs();
        }
        this.kCanvas.repaint();
    }

    public void requestStateChange(Remodeler remodeler) {
        ModelState modelState = remodeler.updateModelState(this.getFrozenState());
        modelState = modelState.createCollapsed();
        Model model = (Model)this.getModel().clone();
        HashMap<String, ModelState> hashMap = new HashMap<String, ModelState>(model.getStates());
        hashMap.put(this.getAltConf(), modelState);
        model.setStates(hashMap);
        ModelStatePair modelStatePair = new ModelStatePair(model, this.getAltConf());
        this.stateList.addLast(modelStatePair);
        this.changedSinceSave = true;
        this.visualizeFrozenModel();
        this.unregisterTool(remodeler);
    }

    public void replaceModelAndState(Model model, ModelState modelState) {
        if (this.isMolten()) {
            throw new IllegalStateException("Cannot install new model while old model is molten");
        }
        Model model2 = (Model)model.clone();
        HashMap<String, ModelState> hashMap = new HashMap<String, ModelState>(model2.getStates());
        hashMap.put(this.getAltConf(), modelState);
        model2.setStates(hashMap);
        this.setModelAndState(model2, this.getAltConf());
        this.changedSinceSave = true;
    }

    public void setModelAndState(Model model, String string) {
        ModelStatePair modelStatePair = new ModelStatePair(model, string);
        this.stateList.addLast(modelStatePair);
        this.visualizeFrozenModel();
        this.requestStateRefresh();
        this.refreshGUI();
    }

    public boolean isMolten() {
        return this.allMoltenRes.size() > 0;
    }

    public void unregisterTool(Remodeler remodeler) {
        this.registeredTools.remove(remodeler);
        this.moltenRes.remove(remodeler);
        this.allMoltenRes.clear();
        Iterator iterator = this.moltenRes.values().iterator();
        while (iterator.hasNext()) {
            this.allMoltenRes.addAll((Collection)iterator.next());
        }
        this.refreshGUI();
        this.requestStateRefresh();
    }

    public void registerTool(Remodeler remodeler, Collection collection) {
        this.registeredTools.add(remodeler);
        this.moltenRes.put(remodeler, collection);
        this.allMoltenRes.addAll(collection);
        this.refreshGUI();
        this.requestStateRefresh();
    }

    public void onUndo(ActionEvent actionEvent) {
        if (!this.undoChange()) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "No changes to undo.", "Sorry!", 0);
        }
    }

    public boolean undoChange() {
        if (this.stateList.size() < 2) {
            return false;
        }
        this.stateList.removeLast();
        this.visualizeFrozenModel();
        this.requestStateRefresh();
        this.refreshGUI();
        return true;
    }

    ModelPlotter getPlotter(String string, KPaint kPaint, KPaint kPaint2, int n) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return new ModelPlotter();
        }
        String string2 = "king.ModelManager2." + string;
        ModelPlotter modelPlotter = (ModelPlotter)kinemage.metadata.get(string2);
        if (modelPlotter == null) {
            modelPlotter = new ModelPlotter();
            modelPlotter.mainColor = kPaint;
            modelPlotter.sideColor = kPaint2;
            modelPlotter.hyColor = KPalette.gray;
            modelPlotter.modelWidth = n;
            KGroup kGroup = modelPlotter.createGroup(string);
            kinemage.add((AHE)kGroup);
            kinemage.metadata.put(string2, modelPlotter);
        }
        return modelPlotter;
    }

    void visualizeMoltenModel() {
        ModelState modelState = this.getMoltenState();
        ModelPlotter modelPlotter = this.getPlotter("molten model", KPalette.peachtint, KPalette.orange, 5);
        modelPlotter.plotAminoAcids(this.getModel(), this.allMoltenRes, modelState);
    }

    void visualizeFrozenModel() {
        Collection collection = this.getModel().getResidues();
        ModelState modelState = this.getFrozenState();
        ModelPlotter modelPlotter = this.getPlotter("frozen model", KPalette.yellowtint, KPalette.sky, 2);
        modelPlotter.plotAminoAcids(this.getModel(), collection, modelState);
    }

    BgKinRunner getProbePlotter() {
        Kinemage kinemage = this.kMain.getKinemage();
        if (!(kinemage == null || this.probePlotter != null && this.probePlotter.getKinemage().equals(kinemage))) {
            if (this.probePlotter != null) {
                this.probePlotter.terminate();
            }
            String string = " -quiet -kin -drop -mc -both -stdbonds '(file1 within {bbradius} of {bbcenter} not water not({molten})),file2' 'file2' '{pdbfile}' -";
            this.probePlotter = new BgKinRunner(this.kMain, kinemage, string);
            String string2 = this.probePlotter.findProgram("probe");
            this.probePlotter.setCommand(string2 + string);
            this.tfProbeCmd.setText(this.probePlotter.getCommand());
        }
        return this.probePlotter;
    }

    void visualizeProbeDots() {
        BgKinRunner bgKinRunner = this.getProbePlotter();
        bgKinRunner.requestRun(this.allMoltenRes, this.getMoltenState(), this.getFrozenPDB());
    }

    public void onEditProbeCmd(ActionEvent actionEvent) {
        this.getProbePlotter().setCommand(this.tfProbeCmd.getText());
        this.requestStateRefresh();
    }

    public void onOpenNOE(ActionEvent actionEvent) {
        File file;
        if (0 == this.noeChooser.showOpenDialog(this.kMain.getTopWindow()) && (file = this.noeChooser.getSelectedFile()) != null && file.exists()) {
            Object[] objectArray = new Object[]{"xplor", "dyana", "aria"};
            String string = "xplor";
            String string2 = file.getName().toLowerCase();
            if (string2.endsWith(".upl")) {
                string = "dyana";
            } else if (string2.endsWith(".list")) {
                string = "aria";
            }
            String string3 = (String)JOptionPane.showInputDialog(this.kMain.getTopWindow(), "What format are these NOEs in?", "Choose format", -1, null, objectArray, string);
            if (string3 != null) {
                this.noeFormat = string3;
            }
            this.noeFile = file;
            this.refreshGUI();
        }
    }

    void visualizeNOEs() {
        this.noePanel.visualizeNOEs(this.allMoltenRes, this.noeFile, this.noeFormat);
    }

    void visualizeExpectedNOEs() {
        this.expNoePanel.visualizeNOEs(this.allMoltenRes, this.noeFile, this.noeFormat);
    }

    public JMenuItem getToolsMenuItem() {
        return new JMenuItem(new ReflectiveAction(this.toString(), null, (Object)this, "onShowDialog"));
    }

    public void onShowDialog(ActionEvent actionEvent) {
        if (!this.dialog.isVisible()) {
            Container container = this.kMain.getContentContainer();
            this.dialog.pack();
            Point point = container.getLocation();
            point.x += container.getWidth() - this.dialog.getWidth();
            point.y += container.getHeight() - this.dialog.getHeight();
            this.dialog.setLocation(point);
            this.dialog.setVisible(true);
        }
        if (this.stateList == null || this.stateList.size() < 1) {
            this.onOpenPDB(null);
        }
    }

    public String getHelpAnchor() {
        return "#modelman-plugin";
    }

    public String toString() {
        return "Model manager";
    }

    public static boolean isAppletSafe() {
        return false;
    }

    static class ModelStatePair {
        Model model;
        String stateLabel;
        File asPDB;

        public ModelStatePair(Model model, String string) {
            this.model = model;
            this.stateLabel = string;
            this.asPDB = null;
        }

        public Model getModel() {
            return this.model;
        }

        public String getAltConf() {
            return this.stateLabel;
        }

        public ModelState getState() {
            return this.model.getState(this.stateLabel);
        }

        public File getPDB() {
            if (this.asPDB == null) {
                try {
                    this.asPDB = File.createTempFile("king", ".pdb");
                    PdbWriter pdbWriter = new PdbWriter(this.asPDB);
                    pdbWriter.writeResidues(this.model.getResidues(), this.getState());
                    pdbWriter.close();
                    this.asPDB.deleteOnExit();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(SoftLog.err);
                }
            }
            return this.asPDB;
        }
    }
}

