/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dezymer;

import chiropraxis.forcefield.BondTerm;
import chiropraxis.forcefield.GradientMinimizer;
import chiropraxis.forcefield.StateManager;
import driftwood.data.ReverseComparator;
import driftwood.r3.MutableTuple3;
import driftwood.r3.Triple;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SequenceSpacer {
    static DecimalFormat df = new DecimalFormat("0.0####");
    static final String BLOSUM_INDICES = "CSTPAGNDEQHRKMILVFYW";
    static final int[][] BLOSUM_62 = new int[][]{{9}, {-1, 4}, {-1, 1, 5}, {-3, -1, -1, 7}, {0, 1, 0, -1, 4}, {-3, 0, -2, -2, 0, 6}, {-3, 1, 0, -2, -2, 0, 6}, {-3, 0, -1, -1, -2, -1, 1, 6}, {-4, 0, -1, -1, -1, -2, 0, 2, 5}, {-3, 0, -1, -1, -1, -2, 0, 0, 2, 5}, {-3, -1, -2, -2, -2, -2, 1, -1, 0, 0, 8}, {-3, -1, -1, -2, -1, -2, 0, -2, 0, 1, 0, 5}, {-3, 0, -1, -1, -1, -2, 0, -1, 1, 1, -1, 2, 5}, {-1, -1, -1, -2, -1, -3, -2, -3, -2, 0, -2, -1, -1, 5}, {-1, -1, -1, -3, -1, -4, -3, -3, -3, -3, -3, -3, -3, 1, 4}, {-1, -2, -1, -3, -1, -4, -3, -4, -3, -2, -3, -2, -2, 2, 2, 4}, {-1, -2, 0, -2, 0, -3, -3, -3, -2, -2, -3, -3, -2, 1, 3, 1, 4}, {-2, -2, -2, -4, -2, -3, -3, -3, -3, -3, -1, -3, -3, 0, 0, 0, -1, 6}, {-2, -2, -2, -3, -2, -3, -2, -3, -2, -1, 2, -2, -2, -1, -1, -1, -1, 3, 7}, {-2, -3, -2, -4, -3, -2, -4, -4, -3, -2, -2, -3, -3, -1, -3, -2, -3, 1, 2, 11}};
    List inputFiles = new ArrayList();
    int numTries = 5;
    double pow = 1.0;
    boolean useBlosum = false;
    Sequence[] seqs;
    int[] mutationDist;
    Collection neighborGraphs;

    Sequence[] loadSequences(InputStream[] inputStreamArray) throws IOException {
        HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>();
        for (int i = 0; i < inputStreamArray.length; ++i) {
            String string;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStreamArray[i]));
            while ((string = lineNumberReader.readLine()) != null) {
                if (string.length() <= 0) continue;
                Sequence sequence = (Sequence)hashMap.get(string);
                if (sequence == null) {
                    sequence = new Sequence(string);
                    hashMap.put(string, sequence);
                }
                sequence.flags.set(i);
            }
        }
        return hashMap.values().toArray(new Sequence[hashMap.size()]);
    }

    int seqDistance(Sequence sequence, Sequence sequence2) {
        String string = sequence.toString();
        String string2 = sequence2.toString();
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    double blosumDistance(Sequence sequence, Sequence sequence2) {
        double d = this.blosumScore(sequence, sequence2);
        double d2 = (double)(this.blosumScore(sequence, sequence) + this.blosumScore(sequence2, sequence2)) / 2.0;
        return (d2 - d) / 7.0;
    }

    int blosumScore(Sequence sequence, Sequence sequence2) {
        String string = sequence.toString();
        String string2 = sequence2.toString();
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            try {
                n3 = BLOSUM_INDICES.indexOf(string.charAt(n5));
                n4 = BLOSUM_INDICES.indexOf(string2.charAt(n5));
                if (n3 < 0 || n4 < 0) continue;
                if (n3 < n4) {
                    n += BLOSUM_62[n4][n3];
                    continue;
                }
                n += BLOSUM_62[n3][n4];
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                System.err.println("i = " + n3 + "; j = " + n4 + "; k = " + n5);
                System.err.println("Comparing " + string + " (" + string.length() + ") and " + string2 + " (" + string2.length() + ")");
                System.exit(1);
            }
        }
        return n;
    }

    StateManager createRestraints() {
        this.mutationDist = new int[this.seqs.length * this.seqs.length];
        StateManager stateManager = new StateManager(this.seqs, this.seqs.length);
        ArrayList<BondTerm> arrayList = new ArrayList<BondTerm>();
        for (int i = 0; i < this.seqs.length; ++i) {
            this.mutationDist[this.seqs.length * i + i] = 0;
            for (int j = i + 1; j < this.seqs.length; ++j) {
                int n;
                this.mutationDist[this.seqs.length * i + j] = n = this.seqDistance(this.seqs[i], this.seqs[j]);
                this.mutationDist[this.seqs.length * j + i] = n;
                if (this.useBlosum) {
                    double d = this.blosumDistance(this.seqs[i], this.seqs[j]);
                    arrayList.add(new BondTerm(i, j, d, 1.0 / Math.pow(d, this.pow)));
                    continue;
                }
                arrayList.add(new BondTerm(i, j, n, 1.0 / Math.pow(n, this.pow)));
            }
        }
        stateManager.setBondTerms(arrayList);
        return stateManager;
    }

    double findLowestEnergy(StateManager stateManager) {
        int n;
        DecimalFormat decimalFormat = new DecimalFormat("0.0000E0");
        double d = Double.POSITIVE_INFINITY;
        MutableTuple3[] mutableTuple3Array = new Triple[this.seqs.length];
        for (n = 0; n < mutableTuple3Array.length; ++n) {
            mutableTuple3Array[n] = new Triple();
        }
        for (n = 0; n < this.numTries; ++n) {
            this.randomizePositions(this.seqs, 10.0);
            stateManager.setState();
            GradientMinimizer gradientMinimizer = new GradientMinimizer(stateManager);
            long l = System.currentTimeMillis();
            for (int i = 1; i <= 100 && gradientMinimizer.step() && !(gradientMinimizer.getFracDeltaEnergy() > -1.0E-4); ++i) {
            }
            l = System.currentTimeMillis() - l;
            System.err.println(l + " ms; E = " + decimalFormat.format(gradientMinimizer.getEnergy()));
            if (!(gradientMinimizer.getEnergy() < d)) continue;
            d = gradientMinimizer.getEnergy();
            stateManager.getState(mutableTuple3Array);
        }
        stateManager.setState(mutableTuple3Array);
        stateManager.getState();
        System.err.println();
        System.err.println("Best energy:  " + decimalFormat.format(d));
        return d;
    }

    void randomizePositions(Sequence[] sequenceArray, double d) {
        for (int i = 0; i < sequenceArray.length; ++i) {
            sequenceArray[i].setX(Math.random() * d);
            sequenceArray[i].setY(Math.random() * d);
            sequenceArray[i].setZ(Math.random() * d);
        }
    }

    void findNeighbors() {
        int n;
        for (n = 0; n < this.seqs.length; ++n) {
            ArrayList<Sequence> arrayList = this.seqs[n].neighbors = new ArrayList<Sequence>();
            for (int i = 0; i < this.seqs.length; ++i) {
                if (this.mutationDist[this.seqs.length * n + i] != 1) continue;
                arrayList.add(this.seqs[i]);
            }
        }
        for (n = 0; n < this.seqs.length; ++n) {
            this.seqs[n].calculateDegrees();
        }
    }

    Collection makeNeighborGraphs() {
        HashSet<Sequence> hashSet = new HashSet<Sequence>(Arrays.asList(this.seqs));
        ArrayList arrayList = new ArrayList();
        while (hashSet.size() > 0) {
            Sequence sequence = (Sequence)hashSet.iterator().next();
            HashSet hashSet2 = new HashSet();
            sequence.neighborGraph(hashSet2);
            arrayList.add(hashSet2);
            hashSet.removeAll(hashSet2);
        }
        Collections.sort(arrayList, new ReverseComparator(new CollectionSizeComparator()));
        return arrayList;
    }

    void renderLinkedViews(Sequence[] sequenceArray, Collection collection, PrintStream printStream) {
        Sequence sequence;
        ArrayList arrayList;
        int n;
        printStream.println("@text");
        Iterator iterator = collection.iterator();
        for (n = 0; iterator.hasNext() && n < 10; ++n) {
            arrayList = new ArrayList((Collection)iterator.next());
            Collections.sort(arrayList, Collections.reverseOrder());
            sequence = (Sequence)arrayList.get(0);
            printStream.println("*{v=" + (n + 2) + "}*   " + arrayList.size() + " member cluster with " + sequence.degree_1 + " neighbors to " + sequence.seq);
            printStream.println(sequence.printNeighborhood(arrayList));
        }
        printStream.println("@1viewid {Overview}");
        iterator = collection.iterator();
        for (n = 0; iterator.hasNext() && n < 10; ++n) {
            arrayList = new ArrayList((Collection)iterator.next());
            Collections.sort(arrayList, Collections.reverseOrder());
            sequence = (Sequence)arrayList.get(0);
            printStream.println("@" + (n + 2) + "viewid {" + sequence.seq + "}");
            printStream.println("@" + (n + 2) + "center " + sequence.format(df));
            printStream.println("@" + (n + 2) + "span 4");
        }
    }

    void renderToKinemage(Sequence[] sequenceArray, int[] nArray, PrintStream printStream) {
        printStream.println("@onewidth");
        int n = 0;
        int n2 = 0;
        String[] stringArray = this.inputFiles.iterator();
        while (stringArray.hasNext()) {
            printStream.println("@" + ++n + "aspect {" + ((File)stringArray.next()).getName() + "}");
        }
        printStream.println("@group {sequences}");
        printStream.println("@subgroup {sequences} nobutton");
        printStream.println("@labellist {labels} color= white off");
        for (n = 0; n < sequenceArray.length; ++n) {
            printStream.print("{" + sequenceArray[n].toString() + "} (");
            for (n2 = 0; n2 < this.inputFiles.size(); ++n2) {
                if (sequenceArray[n].flags.get(n2)) {
                    printStream.print("MABCDEF".charAt(n2 % "MABCDEF".length()));
                    continue;
                }
                printStream.print("X");
            }
            printStream.println(") " + df.format(sequenceArray[n].getX()) + " " + df.format(sequenceArray[n].getY()) + " " + df.format(sequenceArray[n].getZ()));
        }
        printStream.println("@balllist {balls} color= white radius= 0.1");
        for (n = 0; n < sequenceArray.length; ++n) {
            printStream.print("{" + sequenceArray[n].toString() + "} (");
            for (n2 = 0; n2 < this.inputFiles.size(); ++n2) {
                if (sequenceArray[n].flags.get(n2)) {
                    printStream.print("MABCDEF".charAt(n2 % "MABCDEF".length()));
                    continue;
                }
                printStream.print("X");
            }
            printStream.println(") " + df.format(sequenceArray[n].getX()) + " " + df.format(sequenceArray[n].getY()) + " " + df.format(sequenceArray[n].getZ()));
        }
        printStream.println("@group {connections}");
        printStream.println("@subgroup {connections} nobutton");
        this.renderConnections(1, "white", sequenceArray, nArray, printStream);
        this.renderConnections(2, "bluetint", sequenceArray, nArray, printStream);
        this.renderConnections(3, "sky off", sequenceArray, nArray, printStream);
        this.renderConnections(4, "blue off", sequenceArray, nArray, printStream);
        this.renderConnections(5, "purple off", sequenceArray, nArray, printStream);
        stringArray = new String[]{"hotpink", "red", "orange", "gold", "yellow", "lime", "green"};
        n2 = 0;
        Iterator iterator = this.inputFiles.iterator();
        while (iterator.hasNext()) {
            printStream.println("@group {" + ((File)iterator.next()).getName() + "} dominant animate");
            double d = 0.1 + 0.02 * (double)(n2 % 5);
            printStream.println("@balllist {balls} color= " + stringArray[n2 % stringArray.length] + " radius= " + df.format(d) + " nohighlight alpha= 0.4");
            for (n = 0; n < sequenceArray.length; ++n) {
                if (!sequenceArray[n].flags.get(n2)) continue;
                printStream.println("{" + sequenceArray[n].toString() + "} " + df.format(sequenceArray[n].getX()) + " " + df.format(sequenceArray[n].getY()) + " " + df.format(sequenceArray[n].getZ()));
            }
            ++n2;
        }
    }

    void renderConnections(int n, String string, Sequence[] sequenceArray, int[] nArray, PrintStream printStream) {
        printStream.println("@vectorlist {+" + n + "} color= " + string);
        for (int i = 0; i < sequenceArray.length; ++i) {
            for (int j = i; j < sequenceArray.length; ++j) {
                int n2 = nArray[sequenceArray.length * i + j];
                if (n2 != n) continue;
                StringBuffer stringBuffer = new StringBuffer(this.inputFiles.size() + 2);
                stringBuffer.append("(");
                for (int k = 0; k < this.inputFiles.size(); ++k) {
                    if (sequenceArray[i].flags.get(k) && sequenceArray[j].flags.get(k)) {
                        stringBuffer.append(" ");
                        continue;
                    }
                    stringBuffer.append("X");
                }
                stringBuffer.append(")");
                printStream.println("{" + sequenceArray[i].toString() + "} P " + stringBuffer + " " + sequenceArray[i].format(df));
                printStream.println("{" + sequenceArray[j].toString() + "} " + stringBuffer + " " + sequenceArray[j].format(df));
            }
        }
    }

    public void Main() throws IOException {
        InputStream[] inputStreamArray;
        if (this.inputFiles.isEmpty()) {
            this.seqs = this.loadSequences(new InputStream[]{System.in});
        } else {
            inputStreamArray = new InputStream[this.inputFiles.size()];
            for (int i = 0; i < inputStreamArray.length; ++i) {
                inputStreamArray[i] = new FileInputStream((File)this.inputFiles.get(i));
            }
            this.seqs = this.loadSequences(inputStreamArray);
        }
        inputStreamArray = this.createRestraints();
        double d = this.findLowestEnergy((StateManager)inputStreamArray);
        this.findNeighbors();
        this.neighborGraphs = this.makeNeighborGraphs();
        System.err.println(this.seqs.length + " sequences form " + this.neighborGraphs.size() + " connected graphs");
        System.out.println("@kinemage");
        this.renderLinkedViews(this.seqs, this.neighborGraphs, System.out);
        this.renderToKinemage(this.seqs, this.mutationDist, System.out);
    }

    public static void main(String[] stringArray) {
        SequenceSpacer sequenceSpacer = new SequenceSpacer();
        try {
            sequenceSpacer.parseArguments(stringArray);
            sequenceSpacer.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            sequenceSpacer.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println();
            System.err.println("*** I/O error: " + iOException.getMessage());
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SequenceSpacer.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SequenceSpacer.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.minimize.SequenceSpacer");
        System.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        this.inputFiles.add(new File(string));
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-tries")) {
            try {
                this.numTries = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equals("-power")) {
            try {
                this.pow = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equals("-blosum")) {
            this.useBlosum = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    public static class CollectionSizeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((Collection)object).size() - ((Collection)object2).size();
        }
    }

    static class Sequence
    extends Triple
    implements Comparable {
        String seq;
        BitSet flags = new BitSet();
        Collection neighbors;
        int degree_1;
        int degree_2;

        public Sequence(String string) {
            super(10.0 * Math.random(), 10.0 * Math.random(), 10.0 * Math.random());
            this.seq = string;
        }

        public String toString() {
            return this.seq;
        }

        public void neighborGraph(Set set) {
            if (set.contains(this)) {
                return;
            }
            set.add(this);
            Iterator iterator = this.neighbors.iterator();
            while (iterator.hasNext()) {
                ((Sequence)iterator.next()).neighborGraph(set);
            }
        }

        public void calculateDegrees() {
            this.degree_1 = this.neighbors.size();
            this.degree_2 = 0;
            for (Sequence sequence : this.neighbors) {
                this.degree_2 += sequence.neighbors.size();
            }
        }

        public int compareTo(Object object) {
            Sequence sequence = (Sequence)object;
            if (this.degree_1 != sequence.degree_1) {
                return this.degree_1 - sequence.degree_1;
            }
            return this.degree_2 - sequence.degree_2;
        }

        public String printNeighborhood(Collection collection) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.seq.length(); ++i) {
                stringBuffer.append("  ").append(this.seq.charAt(i));
                HashSet<Character> hashSet = new HashSet<Character>();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(new Character(((Sequence)iterator.next()).seq.charAt(i)));
                }
                hashSet.remove(new Character(this.seq.charAt(i)));
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                }
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

