/*
 * Decompiled with CFR 0.152.
 */
package jiffiloop;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.mysql.DatabaseManager;
import driftwood.r3.Builder;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jiffiloop.Filler;
import jiffiloop.PdbLibraryReader;
import jiffiloop.ProteinStem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StemFiller
implements Filler {
    static final DecimalFormat df = new DecimalFormat("0.000");
    HashMap<ProteinStem, ArrayList<String>> filledMap = new HashMap();
    static int matchDiff;

    public StemFiller(Map<String, ArrayList<ProteinStem>> map) {
        ArrayList<ProteinStem> arrayList = new ArrayList<ProteinStem>();
        for (ArrayList<ProteinStem> object : map.values()) {
            arrayList.addAll(object);
        }
        for (ProteinStem proteinStem : arrayList) {
            this.filledMap.put(proteinStem, new ArrayList());
        }
    }

    public void searchDB(int n) {
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.connectToDatabase("//quality.biochem.duke.edu/vbc3");
        for (ProteinStem proteinStem : this.filledMap.keySet()) {
            ArrayList<Double> arrayList = proteinStem.getParameters();
            String string = "SELECT pdb_id, chain_id, frag_length, start_res_num FROM parameters5200 ";
            string = n == 0 ? string.concat("WHERE frag_length = " + Integer.toString(4) + " \n") : string.concat("WHERE frag_length = " + Integer.toString(n) + " \n");
            double d = arrayList.get(0);
            double d2 = arrayList.get(1);
            double d3 = arrayList.get(2);
            if (proteinStem.getStemType() == 1) {
                string = string.concat(this.createWhereQuery(d, "start_pair_angle", 5) + " \n");
                string = string.concat(this.createWhereQuery(d2, "sp_n_dihedral", 5) + " \n");
                string = string.concat(this.createWhereQuery(d3, "sp_c_dihedral", 5) + "\n");
            } else {
                string = string.concat(this.createWhereQuery(d, "end_pair_angle", 5) + " \n");
                string = string.concat(this.createWhereQuery(d2, "ep_n_dihedral", 5) + " \n");
                string = string.concat(this.createWhereQuery(d3, "ep_c_dihedral", 5) + " \n");
            }
            string = string.concat("AND max_B_factor <= 35;");
            System.out.println(string);
            ArrayList<String> arrayList2 = this.filledMap.get(proteinStem);
            databaseManager.select(string);
            while (databaseManager.next()) {
                arrayList2.add(databaseManager.getString(1) + " " + databaseManager.getString(2) + " " + databaseManager.getString(3) + " " + databaseManager.getString(4));
            }
        }
    }

    public String getMatchesInfo() {
        String string = "";
        for (ProteinStem proteinStem : this.filledMap.keySet()) {
            ArrayList<String> arrayList = this.filledMap.get(proteinStem);
            string = string.concat(proteinStem.getSourceString() + " had " + arrayList.size() + " matches\n");
        }
        return string;
    }

    public String createWhereQuery(double d, String string, int n) {
        if (d > (double)(180 - n)) {
            return "AND (" + string + " >= " + Double.toString(d - (double)n) + " OR " + string + " <= " + Double.toString((double)(-360 + n) + d) + ")";
        }
        if (d < (double)(-180 + n)) {
            return "AND (" + string + " <= " + Double.toString(d + (double)n) + " OR " + string + " >= " + Double.toString(d + 360.0 - (double)n) + ")";
        }
        return "AND (" + string + " <= " + Double.toString(d + (double)n) + " AND " + string + " >= " + Double.toString(d - (double)n) + ")";
    }

    public void scanLoopData(ArrayList<File> arrayList, ArrayList<ProteinStem> arrayList2) {
        for (File file : arrayList) {
            if (file == null || !file.exists()) continue;
            try {
                System.out.println("Opening file: " + file.getName());
                ZipFile zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string;
                    ZipEntry zipEntry = enumeration.nextElement();
                    System.out.println("Scanning: " + zipEntry.getName());
                    LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
                    while ((string = lineNumberReader.readLine()) != null) {
                        String[] stringArray = string.split(",");
                        String[] stringArray2 = stringArray[0].split(" ");
                        double[] dArray = new double[8];
                        dArray[1] = Double.parseDouble(stringArray2[1]);
                        for (int i = 2; i < 8; ++i) {
                            dArray[i] = Double.parseDouble(stringArray[i]);
                        }
                        Iterator<ProteinStem> iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            int n = 5;
                            ProteinStem proteinStem = iterator.next();
                            ArrayList<Double> arrayList3 = proteinStem.getParameters();
                            if (!this.scanLine(dArray, n, arrayList3)) continue;
                            ArrayList<String> arrayList4 = this.filledMap.get(arrayList3);
                            arrayList4.add(stringArray[0] + " " + stringArray[1]);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("An I/O error occurred while loading the file:\n" + iOException.getMessage());
            }
        }
    }

    public boolean scanLine(double[] dArray, int n, ArrayList<Double> arrayList) {
        boolean bl = true;
        if ((double)n != dArray[1]) {
            bl = false;
        }
        if (dArray[2] >= arrayList.get(0) + 1.0 || dArray[2] <= arrayList.get(0) - 1.0) {
            bl = false;
        }
        for (int i = 3; i < arrayList.size() && bl; ++i) {
            bl = this.checkAngle(arrayList.get(i - 2), dArray[i]);
        }
        return bl;
    }

    public boolean checkAngle(double d, double d2) {
        if (d > 155.0) {
            return d2 >= d - 25.0 || d2 <= -335.0 + d;
        }
        if (d < -155.0) {
            return d2 <= d + 25.0 || d2 >= d + 360.0 - 25.0;
        }
        return d2 <= d + 25.0 && d2 >= d - 25.0;
    }

    @Override
    public CoordinateFile[] getFragments(PdbLibraryReader pdbLibraryReader, boolean bl, int n) {
        CoordinateFile[] coordinateFileArray = new CoordinateFile[this.filledMap.keySet().size()];
        int n2 = 0;
        for (ProteinStem proteinStem : this.filledMap.keySet()) {
            coordinateFileArray[n2] = new CoordinateFile();
            System.out.println(proteinStem.getSourceString() + "." + proteinStem.getOneNum());
            coordinateFileArray[n2].setIdCode(proteinStem.getSourceString() + "." + proteinStem.getOneNum());
            ArrayList<String> arrayList = this.filledMap.get(proteinStem);
            System.out.println(arrayList.size());
            for (int i = 0; i < n && i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                String[] stringArray = string.split(" ");
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                int n3 = Integer.parseInt(stringArray[2]);
                int n4 = Integer.parseInt(stringArray[3]);
                pdbLibraryReader.setCurrentPdb(string2, string3);
                Model model = proteinStem.getStemType() == 1 ? pdbLibraryReader.getFragment(Integer.toString(i), string3, n4, n3, proteinStem.getOneNum() - 1) : pdbLibraryReader.getFragment(Integer.toString(i), string3, n4, n3, proteinStem.getOneNum() - n3 - 1);
                if (model == null) continue;
                try {
                    Object object;
                    Transform transform = null;
                    if (!bl) {
                        object = proteinStem.getStemType() == 1 ? new SuperPoser(proteinStem.getTupleArray(), pdbLibraryReader.getStemNtermAtoms(model)) : new SuperPoser(proteinStem.getTupleArray(), pdbLibraryReader.getStemCtermAtoms(model));
                        transform = ((SuperPoser)object).superpos();
                    } else {
                        Tuple3[] tuple3Array;
                        Tuple3[] tuple3Array2;
                        object = new Builder();
                        if (proteinStem.getStemType() == 1) {
                            tuple3Array2 = proteinStem.getTupleArray();
                            tuple3Array = pdbLibraryReader.getStemNtermAtoms(model);
                            transform = ((Builder)object).dock3on3(tuple3Array2[2], tuple3Array2[1], tuple3Array2[0], tuple3Array[2], tuple3Array[1], tuple3Array[0]);
                        } else {
                            tuple3Array2 = proteinStem.getTupleArray();
                            tuple3Array = pdbLibraryReader.getStemCtermAtoms(model);
                            transform = ((Builder)object).dock3on3(tuple3Array2[0], tuple3Array2[1], tuple3Array2[2], tuple3Array[0], tuple3Array[1], tuple3Array[2]);
                        }
                    }
                    this.transform(model, transform);
                    coordinateFileArray[n2].add(model);
                    if (Math.IEEEremainder(i, 100.0) != 0.0) continue;
                    System.out.println("Opened: " + i);
                    continue;
                }
                catch (AtomException atomException) {
                    System.err.println("Problem with atom " + atomException.getMessage() + " in pdb " + string2);
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.err.println("Problem with residue " + string3 + " " + n4 + " in pdb " + string2);
                }
            }
            ++n2;
        }
        return coordinateFileArray;
    }

    public void transform(Model model, Transform transform) {
        ModelState modelState = model.getState();
        for (Residue residue : model.getResidues()) {
            for (Atom atom : residue.getAtoms()) {
                try {
                    AtomState atomState = modelState.get(atom);
                    Triple triple = new Triple();
                    triple.setXYZ(atomState.getX(), atomState.getY(), atomState.getZ());
                    transform.transform(triple);
                    atomState.setX(triple.getX());
                    atomState.setY(triple.getY());
                    atomState.setZ(triple.getZ());
                }
                catch (AtomException atomException) {
                    System.err.println("Problem with atom " + atomException.getMessage() + " in fragment filler");
                }
            }
        }
    }

    @Override
    public Tuple3[] getTupleArray(ArrayList<Triple> arrayList) {
        Tuple3[] tuple3Array = new Tuple3[]{arrayList.get(0), arrayList.get(1), arrayList.get(2), arrayList.get(3)};
        return tuple3Array;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }
}

