/*
 * Decompiled with CFR 0.152.
 */
package absigner;

import absigner.Parameters;
import driftwood.data.UberSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import molikin.logic.BallAndStickLogic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Absigner {
    static final DecimalFormat df = new DecimalFormat("0.000");
    Parameters params = null;
    CoordinateFile pdb = null;
    HashMap<Residue, Integer> alphaMap = null;
    HashMap<Residue, Integer> betaMap = null;

    public static void main(String[] stringArray) {
        ArrayList arrayList = Absigner.parseArgs(stringArray);
        if (arrayList.size() < 1) {
            System.out.println("Not enough arguments: you must have an input pdb!");
        } else {
            File file = new File((String)arrayList.get(0));
            Absigner absigner = new Absigner(new File(file.getAbsolutePath()));
        }
    }

    public Absigner(File file) {
        String string = file.getName();
        System.out.println(string);
        this.pdb = null;
        if (string.endsWith(".pdb") || string.endsWith(".pdb.gz")) {
            this.pdb = this.readFile(file);
        }
        this.params = new Parameters();
        this.analyzePdb(2);
    }

    public static ArrayList parseArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-h") || string.equals("-help")) {
                    System.err.println("Help not available. Sorry!");
                    System.exit(0);
                    continue;
                }
                if (string.equals("-kin")) continue;
                System.err.println("*** Unrecognized option: " + string);
                continue;
            }
            System.out.println(string);
            arrayList.add(string);
        }
        return arrayList;
    }

    public CoordinateFile readFile(File file) {
        try {
            InputStream inputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(inputStream);
            inputStream.mark(10);
            if (inputStream.read() == 31 && inputStream.read() == 139) {
                inputStream.reset();
                inputStream = new GZIPInputStream(inputStream);
            } else {
                inputStream.reset();
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            PdbReader pdbReader = new PdbReader();
            pdbReader.setUseSegID(false);
            CoordinateFile coordinateFile = pdbReader.read(lineNumberReader);
            System.out.println(coordinateFile.getIdCode() + " has been read");
            lineNumberReader.close();
            return coordinateFile;
        }
        catch (IOException iOException) {
            System.err.println("IO Exception thrown " + iOException.getMessage());
            return null;
        }
    }

    public void analyzePdb(int n) {
        double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.analyzePdb(n, dArray);
    }

    public void analyzePdb(int n, double[] dArray) {
        if (this.pdb == null) {
            System.err.println("Somehow a file wasn't readable");
        } else {
            this.alphaMap = new HashMap();
            this.betaMap = new HashMap();
            Model model = this.pdb.getFirstModel();
            Set set = model.getChainIDs();
            for (String string : set) {
                Set set2 = model.getChain(string);
                this.fragalyze(this.pdb.getIdCode(), model, set2, n, dArray);
            }
        }
    }

    public void fragalyze(String string, Model model, Set<Residue> set, int n, double[] dArray) {
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        for (Residue residue : set) {
            if (!this.alphaMap.containsKey(residue)) {
                this.alphaMap.put(residue, new Integer(0));
            }
            if (this.betaMap.containsKey(residue)) continue;
            this.betaMap.put(residue, new Integer(0));
        }
        for (Residue residue : set) {
            if (arrayList.size() != n + 3) {
                if (Absigner.isBackboneComplete(residue, model)) {
                    arrayList.add(residue);
                } else {
                    arrayList.clear();
                }
            }
            if (arrayList.size() != n + 3) continue;
            double[] dArray2 = this.parameterize(model, arrayList, n);
            double[] dArray3 = this.multiply(this.params.getAlphaSD(n), dArray);
            if (Parameters.inRange(dArray2, this.params.getAlphaSize(n), dArray3)) {
                for (Residue residue2 : arrayList) {
                    Comparable<Integer> comparable = this.alphaMap.get(residue2);
                    this.alphaMap.put(residue2, new Integer(comparable + 1));
                }
            }
            Object object = this.multiply(this.params.getBetaSD(n), dArray);
            if (Parameters.inRange(dArray2, this.params.getBetaSize(n), (double[])object)) {
                for (Comparable<Integer> comparable : arrayList) {
                    Integer n2 = this.betaMap.get(comparable);
                    System.out.println(comparable + " " + n2);
                    this.betaMap.put((Residue)comparable, new Integer(n2 - 1));
                }
            }
            arrayList.remove(0);
        }
        for (Residue residue : set) {
        }
    }

    public static boolean isBackboneComplete(Residue residue, Model model) {
        ModelState modelState = model.getState();
        Iterator iterator = residue.getAtoms().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Atom atom = (Atom)iterator.next();
            if (!modelState.hasState(atom)) {
                return false;
            }
            String string = atom.getName();
            if (string.equals(" N  ")) {
                ++n;
            }
            if (string.equals(" CA ")) {
                n += 2;
            }
            if (string.equals(" C  ")) {
                n += 4;
            }
            if (!string.equals(" O  ")) continue;
            n += 8;
        }
        return n == 15;
    }

    public double[] parameterize(Model model, ArrayList<Residue> arrayList, int n) {
        Residue residue = arrayList.get(0);
        Residue residue2 = arrayList.get(1);
        Residue residue3 = arrayList.get(2);
        Residue residue4 = arrayList.get(arrayList.size() - 3);
        Residue residue5 = arrayList.get(arrayList.size() - 1);
        Residue residue6 = arrayList.get(arrayList.size() - 2);
        ModelState modelState = model.getState();
        double[] dArray = null;
        try {
            AtomState atomState = modelState.get(residue.getAtom(" CA "));
            AtomState atomState2 = modelState.get(residue2.getAtom(" CA "));
            AtomState atomState3 = modelState.get(residue6.getAtom(" CA "));
            AtomState atomState4 = modelState.get(residue5.getAtom(" CA "));
            AtomState atomState5 = modelState.get(residue.getAtom(" O  "));
            AtomState atomState6 = modelState.get(residue6.getAtom(" O  "));
            dArray = this.frameAnalyze(atomState, atomState2, atomState3, atomState4, atomState5, atomState6);
        }
        catch (AtomException atomException) {
            System.err.println("Problem with atom " + atomException.getMessage());
        }
        return dArray;
    }

    public double[] frameAnalyze(Triple triple, Triple triple2, Triple triple3, Triple triple4, Triple triple5, Triple triple6) {
        double[] dArray = new double[]{triple2.distance(triple3), Triple.angle(triple, triple2, triple3), Triple.angle(triple2, triple3, triple4), Triple.dihedral(triple5, triple, triple2, triple3), Triple.dihedral(triple, triple2, triple3, triple4), Triple.dihedral(triple2, triple3, triple4, triple6)};
        return dArray;
    }

    public double[] multiply(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] * dArray2[i];
        }
        return dArray3;
    }

    public void recalculate(int[] nArray, double[] dArray) {
        for (int n : nArray) {
            this.analyzePdb(n, dArray);
        }
    }

    public CoordinateFile getPdb() {
        return this.pdb;
    }

    public HashMap<Residue, Integer> getAlphaMap() {
        return this.alphaMap;
    }

    public HashMap<Residue, Integer> getBetaMap() {
        return this.betaMap;
    }

    public HashMap<Residue, Integer> getAlphaMap(double[] dArray) {
        for (int i = 1; i <= 2; ++i) {
            this.analyzePdb(i, dArray);
        }
        return this.alphaMap;
    }

    public HashMap<Residue, Integer> getBetaMap(double[] dArray) {
        for (int i = 1; i <= 2; ++i) {
            this.analyzePdb(i, dArray);
        }
        return this.betaMap;
    }

    public void printKinemage(CoordinateFile coordinateFile, PrintWriter printWriter) {
        printWriter.println("@kinemage");
        BallAndStickLogic ballAndStickLogic = new BallAndStickLogic();
        ballAndStickLogic.doProtein = true;
        ballAndStickLogic.doBackbone = true;
        ballAndStickLogic.doSidechains = true;
        ballAndStickLogic.doHydrogens = true;
        ballAndStickLogic.colorBy = BallAndStickLogic.COLOR_BY_MC_SC;
        for (Model model : coordinateFile.getModels()) {
            printWriter.println("@group {" + coordinateFile.getIdCode() + " " + model.getName() + "} dominant master= {input pdb}");
            ballAndStickLogic.printKinemage(printWriter, model, new UberSet(model.getResidues()), coordinateFile.getIdCode(), "bluetint");
        }
        printWriter.flush();
    }
}

