/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.r3.Triple;
import driftwood.util.Strings;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import molikin.AtomIDer;
import molikin.Bond;
import molikin.BondCrayon;
import molikin.PrekinIDer;
import molikin.Util;
import molikin.crayons.ConstCrayon;

public class StickPrinter {
    static final DecimalFormat df = Strings.usDecimalFormat("0.###");
    PrintWriter out;
    BondCrayon crayon = ConstCrayon.NONE;
    AtomIDer ider = new PrekinIDer();
    boolean halfbonds = false;
    Triple midpoint = new Triple();
    Collection selectedBonds = new ArrayList();

    public StickPrinter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void printSticks(Collection collection, Set set, Set set2, Set set3, Set set4, String string) {
        this.selectedBonds.clear();
        Util.selectBondsBetween(collection, set, set2, set3, set4, this.selectedBonds);
        Bond[] bondArray = this.selectedBonds.toArray(new Bond[this.selectedBonds.size()]);
        Bond.optimizeBondSequence(bondArray);
        if (this.halfbonds) {
            this.halfBondsImpl(bondArray, string);
        } else {
            this.wholeBondsImpl(bondArray, string);
        }
        this.out.flush();
    }

    public void printSticks(Collection collection, Set set, Set set2) {
        this.printSticks(collection, set, set2, null, null, null);
    }

    public void printSticks(Collection collection) {
        this.printSticks(collection, null, null, null, null, null);
    }

    void wholeBondsImpl(Bond[] bondArray, String string) {
        Bond bond = new Bond(null, -1, null, -1);
        for (int i = 0; i < bondArray.length; ++i) {
            Bond bond2 = bondArray[i];
            this.crayon.forBond(bond2.higher, bond2.lower);
            if (!this.crayon.shouldPrint()) continue;
            if (bond2.lower != bond.higher) {
                this.out.print("{" + this.ider.identifyAtom(bond2.lower) + string + "}P " + bond2.lower.format(df) + " ");
            }
            this.out.println("{" + this.ider.identifyAtom(bond2.higher) + string + "}L " + this.crayon.getKinString() + " " + bond2.higher.format(df));
            bond = bond2;
        }
    }

    void halfBondsImpl(Bond[] bondArray, String string) {
        Bond bond = new Bond(null, -1, null, -1);
        for (int i = 0; i < bondArray.length; ++i) {
            Bond bond2 = bondArray[i];
            this.midpoint.likeMidpoint(bond2.lower, bond2.higher);
            this.crayon.forBond(bond2.lower, bond2.higher);
            boolean bl = this.crayon.shouldPrint();
            String string2 = this.crayon.getKinString();
            this.crayon.forBond(bond2.higher, bond2.lower);
            boolean bl2 = this.crayon.shouldPrint();
            String string3 = this.crayon.getKinString();
            if (bl) {
                if (bond2.lower != bond.higher) {
                    this.out.print("{" + this.ider.identifyAtom(bond2.lower) + string + "}P " + bond2.lower.format(df) + " ");
                }
                if (!string2.equals(string3)) {
                    this.out.print("{mid}U " + string2 + " " + this.midpoint.format(df) + " ");
                }
            }
            if (!bl2) continue;
            if (!bl) {
                this.out.print("{mid}P U " + this.midpoint.format(df) + " ");
            }
            this.out.println("{" + this.ider.identifyAtom(bond2.higher) + string + "}L " + string3 + " " + bond2.higher.format(df));
            bond = bond2;
        }
    }

    public boolean getHalfBonds() {
        return this.halfbonds;
    }

    public void setHalfBonds(boolean bl) {
        this.halfbonds = bl;
    }

    public BondCrayon getCrayon() {
        return this.crayon;
    }

    public void setCrayon(BondCrayon bondCrayon) {
        this.crayon = bondCrayon;
    }

    public AtomIDer getAtomIDer() {
        return this.ider;
    }

    public void setAtomIDer(AtomIDer atomIDer) {
        this.ider = atomIDer;
    }

    public void testBonds(Collection collection) {
        for (Bond bond : collection) {
            System.out.print(bond.higher.getName() + "->" + bond.lower.getName() + "; ");
        }
    }
}

