/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import driftwood.r3.Transform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import king.core.AHE;
import king.core.AHEImpl;
import king.core.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AGE<P extends AGE, C extends AHE>
extends AHEImpl<P>
implements Iterable<C> {
    protected static final int FLAG_ON = 1;
    protected static final int FLAG_NOBUTTON = 2;
    protected static final int FLAG_DOMINANT = 4;
    protected static final int FLAG_COLLAPSIBLE = 8;
    protected static final int FLAG_LENS = 16;
    protected static final int FLAG_ANIMATE = 256;
    protected static final int FLAG_2ANIMATE = 512;
    protected static final int FLAG_NOHILITE = 1024;
    protected static final int FLAG_SELECT = 2048;
    protected P parent = null;
    protected ArrayList<C> children = new ArrayList();
    protected Collection<String> masters = null;
    protected Transform transform = null;
    protected int flags = 1;

    public AGE<P, C> clone() throws CloneNotSupportedException {
        return this.clone(true);
    }

    public AGE<P, C> clone(boolean bl) throws CloneNotSupportedException {
        return (AGE)super.clone();
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public void setParent(P p) {
        this.parent = p;
    }

    public void add(C c) {
        c.setParent((AGE)this);
        this.children.add(c);
        if (c instanceof AGE) {
            this.fireKinChanged(1);
        } else {
            this.fireKinChanged(256);
        }
    }

    public C replace(C c, C c2) {
        int n = this.children.indexOf(c);
        if (n == -1) {
            this.add(c2);
            return null;
        }
        c2.setParent((AGE)this);
        AHE aHE = (AHE)this.children.set(n, c2);
        if (c2 instanceof AGE) {
            this.fireKinChanged(1);
        } else {
            this.fireKinChanged(256);
        }
        return (C)aHE;
    }

    public void remove(C c) {
        boolean bl = this.children.remove(c);
        if (!bl) {
            return;
        }
        if (c.getParent() == this) {
            c.setParent(null);
        }
        if (c instanceof AGE) {
            this.fireKinChanged(1);
        } else {
            this.fireKinChanged(256);
        }
    }

    public void clear() {
        this.children.clear();
        this.fireKinChanged(257);
    }

    public ArrayList<C> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<C> arrayList) {
        this.children = arrayList;
        this.fireKinChanged(257);
    }

    @Override
    public Iterator<C> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.fireKinChanged(2);
    }

    @Override
    public boolean isOn() {
        return (this.flags & 1) == 1;
    }

    @Override
    public void setOn(boolean bl) {
        int n = this.flags;
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        if (this.flags != n) {
            this.fireKinChanged(4);
        }
    }

    public boolean hasButton() {
        return (this.flags & 2) != 2;
    }

    public void setHasButton(boolean bl) {
        int n = this.flags;
        this.flags = !bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        if (this.flags != n) {
            this.fireKinChanged(2);
        }
    }

    public boolean isDominant() {
        return (this.flags & 4) == 4;
    }

    public void setDominant(boolean bl) {
        int n = this.flags;
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        if (this.flags != n) {
            this.fireKinChanged(2);
        }
    }

    public boolean isCollapsible() {
        return (this.flags & 8) == 8;
    }

    public void setCollapsible(boolean bl) {
        int n = this.flags;
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
        if (this.flags != n) {
            this.fireKinChanged(2);
        }
    }

    public boolean isLens() {
        return (this.flags & 0x10) == 16;
    }

    public void setLens(boolean bl) {
        int n = this.flags;
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
        if (this.flags != n) {
            this.fireKinChanged(16);
        }
    }

    @Override
    public void doTransform(Engine engine, Transform transform) {
        if (!this.isOn()) {
            return;
        }
        if (this.transform != null) {
            transform = new Transform().like(this.transform).append(transform);
        }
        for (AHE aHE : this.children) {
            aHE.doTransform(engine, transform);
        }
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    @Override
    public void calcBoundingBox(float[] fArray) {
        for (AHE aHE : this.children) {
            aHE.calcBoundingBox(fArray);
        }
    }

    @Override
    public float calcRadiusSq(float[] fArray) {
        float f = 0.0f;
        for (AHE aHE : this.children) {
            f = Math.max(f, aHE.calcRadiusSq(fArray));
        }
        return f;
    }

    public void addMaster(String string) {
        if (this.masters == null) {
            this.masters = new ArrayList<String>(5);
        }
        if (!this.masters.contains(string)) {
            this.masters.add(string);
            this.fireKinChanged(8);
        }
    }

    public void removeMaster(String string) {
        if (this.masters == null) {
            return;
        }
        if (this.masters.contains(string)) {
            this.masters.remove(string);
            this.fireKinChanged(8);
        }
    }

    public Collection<String> getMasters() {
        if (this.masters == null) {
            return Collections.emptySet();
        }
        return this.masters;
    }
}

