/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.SoftLog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import king.KMessage;
import king.KinCanvas;
import king.KingMain;
import king.ToolBox;
import king.core.Aspect;
import king.core.Engine;
import king.core.Engine2D;
import king.core.KGroup;
import king.core.KList;
import king.core.KPalette;
import king.core.KPoint;
import king.core.KView;
import king.core.Kinemage;
import king.core.Painter;
import king.core.Transformable;
import king.points.DotPoint;
import king.points.MarkerPoint;
import king.points.VectorPoint;

public class ToolServices
implements Transformable {
    static final DecimalFormat df_3 = new DecimalFormat("###,###,##0.###");
    static final DecimalFormat df_1 = new DecimalFormat("##0.#");
    static final int[] marker_styles = new int[]{1544, 393220, 514, 131074, 0x700000};
    ToolBox parent;
    KingMain kMain;
    KinCanvas kCanvas;
    float delta_zoom = 0.0f;
    float delta_clip = 0.0f;
    String pointID = null;
    String distance = null;
    String aspect = null;
    String coords = null;
    public JCheckBoxMenuItem doXYZ;
    public JCheckBox doMarkers;
    public JCheckBoxMenuItem doFlatland;
    public JCheckBoxMenuItem doSuperpick;
    public JCheckBoxMenuItem doObjectPick;
    public JCheckBoxMenuItem doMeasureAll;
    public JCheckBox doPickcenter;
    LinkedList trackedPoints;
    final int maxTrackedPoints = 5;

    public ToolServices(ToolBox toolBox) {
        this.parent = toolBox;
        this.kMain = toolBox.kMain;
        this.kCanvas = toolBox.kCanvas;
        this.trackedPoints = new LinkedList();
        this.doXYZ = new JCheckBoxMenuItem(new ReflectiveAction("Show XYZ coordinates", null, this, "onShowXYZ"));
        this.doXYZ.setSelected(false);
        this.doMarkers = new JCheckBox(new ReflectiveAction("Markers", null, this, "onShowMarkers"));
        this.doMarkers.setSelected(false);
        this.doMarkers.setToolTipText("Markers painted on points you've selected with the mouse");
        this.doFlatland = new JCheckBoxMenuItem(new ReflectiveAction("Flatland", null, this, "onFlatland"));
        this.doFlatland.setSelected(false);
        this.doFlatland.setToolTipText("Translate in X-Y instead of rotating");
        this.doSuperpick = new JCheckBoxMenuItem("Superpick", false);
        this.doSuperpick.setToolTipText("Pick points that are otherwise unpickable");
        this.doObjectPick = new JCheckBoxMenuItem(new ReflectiveAction("Pick objects", null, this, "onObjectPick"));
        this.doObjectPick.setSelected(this.kCanvas.getEngine().useObjPicking);
        this.doObjectPick.setToolTipText("Pick lines and faces in addition to points");
        this.doMeasureAll = new JCheckBoxMenuItem(new ReflectiveAction("Measure angle & dihedral", null, this, "onShowMeasures"));
        this.doMeasureAll.setSelected(false);
        this.doPickcenter = new JCheckBox("Pick center", false);
        this.doPickcenter.setToolTipText("Click this, then choose a new center of rotation");
    }

    private Tuple3 kinCoordsToLogicalXYZ(Kinemage kinemage, KPoint kPoint, int[] nArray) {
        Triple triple = new Triple(kPoint);
        if (kinemage == null) {
            return triple;
        }
        if (nArray != null && nArray.length >= 3) {
            double d = 1.0;
            double d2 = 1.0;
            double d3 = 1.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (kinemage.dimensionScale.size() > nArray[0]) {
                d = kinemage.dimensionScale.get(nArray[0]).doubleValue();
            }
            if (kinemage.dimensionScale.size() > nArray[1]) {
                d2 = kinemage.dimensionScale.get(nArray[1]).doubleValue();
            }
            if (kinemage.dimensionScale.size() > nArray[2]) {
                d3 = kinemage.dimensionScale.get(nArray[2]).doubleValue();
            }
            if (kinemage.dimensionOffset.size() > nArray[0]) {
                d4 = kinemage.dimensionOffset.get(nArray[0]).doubleValue();
            }
            if (kinemage.dimensionOffset.size() > nArray[1]) {
                d5 = kinemage.dimensionOffset.get(nArray[1]).doubleValue();
            }
            if (kinemage.dimensionOffset.size() > nArray[2]) {
                d6 = kinemage.dimensionOffset.get(nArray[2]).doubleValue();
            }
            triple.setX(triple.getX() / d - d4);
            triple.setY(triple.getY() / d2 - d5);
            triple.setZ(triple.getZ() / d3 - d6);
        }
        return triple;
    }

    public void pick(KPoint kPoint) {
        if (this.doPickcenter.isSelected()) {
            this.doPickcenter.setSelected(false);
            this.centerOnPoint(kPoint);
        } else {
            this.identify(kPoint);
            if (this.doMeasureAll.isSelected()) {
                this.measureAll(kPoint);
            } else {
                this.measure(kPoint);
            }
            this.mark(kPoint);
        }
    }

    public void identify(KPoint kPoint) {
        if (this.kMain.getView() == null || kPoint == null) {
            this.setID(null);
            this.setDist(null);
            this.setCoords(null);
        } else {
            this.setID(kPoint.getName());
            Tuple3 tuple3 = this.kinCoordsToLogicalXYZ(this.kMain.getKinemage(), kPoint, this.kMain.getView().getViewingAxes());
            this.setCoords(df_3.format(tuple3.getX()) + "  " + df_3.format(tuple3.getY()) + "  " + df_3.format(tuple3.getZ()));
        }
        this.kCanvas.repaint();
    }

    public void measure(KPoint kPoint) {
        KPoint kPoint2 = this.getLastPicked(0);
        if (this.kMain.getView() == null || kPoint == null) {
            this.setDist(null);
        } else if (kPoint2 != null) {
            double d = kPoint.getX() - kPoint2.getX();
            double d2 = kPoint.getY() - kPoint2.getY();
            double d3 = kPoint.getZ() - kPoint2.getZ();
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            this.setDist(df_3.format(d4));
        }
        this.kCanvas.repaint();
    }

    public void mark(KPoint kPoint) {
        if (kPoint != null) {
            this.trackedPoints.addFirst(kPoint);
        }
        while (this.trackedPoints.size() > 5) {
            this.trackedPoints.removeLast();
        }
        if (this.doMarkers.isSelected()) {
            this.kCanvas.repaint();
        }
    }

    public void measureAll(KPoint kPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        KPoint kPoint2 = this.getLastPicked(0);
        if (this.kMain.getView() == null || kPoint == null) {
            this.setDist(null);
        } else if (kPoint2 != null) {
            double d = kPoint.getX() - kPoint2.getX();
            double d2 = kPoint.getY() - kPoint2.getY();
            double d3 = kPoint.getZ() - kPoint2.getZ();
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            stringBuffer.append("dist: ").append(df_3.format(d4));
            KPoint kPoint3 = this.getLastPicked(1);
            if (kPoint3 != null) {
                double d5 = kPoint2.getX() - kPoint3.getX();
                double d6 = kPoint2.getY() - kPoint3.getY();
                double d7 = kPoint2.getZ() - kPoint3.getZ();
                double d8 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
                double d9 = Math.toDegrees(Math.acos((d * d5 + d2 * d6 + d3 * d7) / (d4 * -d8)));
                stringBuffer.append("   angl: ").append(df_1.format(d9));
                KPoint kPoint4 = this.getLastPicked(2);
                if (kPoint4 != null) {
                    double d10 = kPoint3.getX() - kPoint4.getX();
                    double d11 = kPoint3.getY() - kPoint4.getY();
                    double d12 = kPoint3.getZ() - kPoint4.getZ();
                    double d13 = Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12);
                    double d14 = d11 * d7 - d12 * d6;
                    double d15 = d12 * d5 - d10 * d7;
                    double d16 = d10 * d6 - d11 * d5;
                    double d17 = Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16);
                    double d18 = d6 * d3 - d7 * d2;
                    double d19 = d7 * d - d5 * d3;
                    double d20 = d5 * d2 - d6 * d;
                    double d21 = Math.sqrt(d18 * d18 + d19 * d19 + d20 * d20);
                    d9 = Math.toDegrees(Math.acos((d14 * d18 + d15 * d19 + d16 * d20) / (d17 * d21)));
                    if (Math.toDegrees(Math.acos((d10 * d18 + d11 * d19 + d12 * d20) / (d13 * d21))) > 90.0) {
                        d9 = -d9;
                    }
                    stringBuffer.append("   dihd: ").append(df_1.format(d9));
                    if (this.kMain.getPrefs().getBoolean("measureVectorVectorAngle")) {
                        d9 = Math.toDegrees(Math.acos((d * d10 + d2 * d11 + d3 * d12) / (d4 * -d13)));
                        stringBuffer.append("   vect: ").append(df_1.format(d9));
                    }
                }
            }
            this.setDist(stringBuffer.toString());
        }
        this.kCanvas.repaint();
    }

    public void centerOnPoint(KPoint kPoint) {
        KView kView = this.kMain.getView();
        if (kView == null || kPoint == null) {
            return;
        }
        kView.setCenter((float)kPoint.getX(), (float)kPoint.getY(), (float)kPoint.getZ());
    }

    public void rotate(float f, float f2) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        kView.rotateX((float)Math.PI * 2 * f2 / 600.0f);
        kView.rotateY((float)Math.PI * 2 * f / 600.0f);
    }

    public void pinwheel(float f) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        kView.rotateZ((float)Math.PI * -2 * f / 600.0f);
    }

    public void translate(int n, int n2) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        Dimension dimension = this.kCanvas.getCanvasSize();
        kView.viewTranslateRotated(n, -n2, 0, dimension.width < dimension.height ? dimension.width : dimension.height);
    }

    public void ztranslate(int n) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        Dimension dimension = this.kCanvas.getCanvasSize();
        kView.viewTranslateRotated(0, 0, n, dimension.width < dimension.height ? dimension.width : dimension.height);
    }

    public void adjustZoom(float f) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        BoundedRangeModel boundedRangeModel = this.kCanvas.getZoomModel();
        this.delta_zoom += f / 6.0f;
        boundedRangeModel.setValue(boundedRangeModel.getValue() + (int)this.delta_zoom);
        this.delta_zoom -= (float)((int)this.delta_zoom);
    }

    public void adjustClipping(float f) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        BoundedRangeModel boundedRangeModel = this.kCanvas.getClipModel();
        this.delta_clip += f / 1.0f;
        boundedRangeModel.setValue(boundedRangeModel.getValue() + (int)this.delta_clip);
        this.delta_clip -= (float)((int)this.delta_clip);
    }

    public KPoint getLastPicked(int n) {
        KPoint kPoint = null;
        try {
            kPoint = (KPoint)this.trackedPoints.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return kPoint;
    }

    public void clearLastPicked() {
        this.trackedPoints.clear();
    }

    public void clearEverything() {
        this.clearLastPicked();
        this.setID(null);
        this.setDist(null);
        this.setAspect(null);
        this.setCoords(null);
    }

    public void onShowMarkers(ActionEvent actionEvent) {
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 4));
    }

    public void onShowMeasures(ActionEvent actionEvent) {
        if (this.doMeasureAll.isSelected()) {
            this.clearLastPicked();
            this.doMarkers.setSelected(true);
        } else {
            this.setDist(null);
            this.doMarkers.setSelected(false);
        }
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 4));
    }

    public void onShowXYZ(ActionEvent actionEvent) {
        this.kCanvas.repaint();
    }

    public void onObjectPick(ActionEvent actionEvent) {
        this.kCanvas.getEngine().useObjPicking = this.doObjectPick.isSelected();
    }

    public void onFlatland(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        kinemage.atFlat = this.doFlatland.isSelected();
    }

    KList makeNormalMarkers(List list, int n) {
        KList kList = new KList("mark");
        kList.setColor(KPalette.white);
        for (int i = 0; i < n && i < list.size(); ++i) {
            KPoint kPoint = (KPoint)list.get(i);
            MarkerPoint markerPoint = new MarkerPoint(kPoint, KPalette.white, marker_styles[i]);
            markerPoint.setParent(kList);
            kList.add(markerPoint);
        }
        return kList;
    }

    KGroup makeMageMeasures(List list) {
        KPoint kPoint;
        KGroup kGroup = new KGroup();
        KList kList = new KList("vector", "lines");
        kGroup.add(kList);
        kList.setWidth(5);
        kList.setColor(KPalette.white);
        VectorPoint vectorPoint = null;
        for (int i = 3; i >= 0; --i) {
            if (list.size() <= i) continue;
            kPoint = (KPoint)list.get(i);
            VectorPoint vectorPoint2 = new VectorPoint("", vectorPoint);
            vectorPoint2.setX(kPoint.getX());
            vectorPoint2.setY(kPoint.getY());
            vectorPoint2.setZ(kPoint.getZ());
            vectorPoint2.setUnpickable(true);
            vectorPoint = vectorPoint2;
            kList.add(vectorPoint2);
        }
        KList kList2 = new KList("dot", "dots");
        kGroup.add(kList2);
        kList2.setWidth(2);
        kList2.setColor(KPalette.hotpink);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 4; ++i) {
            if (list.size() <= i) continue;
            kPoint = (KPoint)list.get(i);
            d += kPoint.getX();
            d2 += kPoint.getY();
            d3 += kPoint.getZ();
            if (i <= 0) continue;
            DotPoint dotPoint = new DotPoint("");
            dotPoint.setX(d / (double)(i + 1));
            dotPoint.setY(d2 / (double)(i + 1));
            dotPoint.setZ(d3 / (double)(i + 1));
            kList2.add(dotPoint);
        }
        return kGroup;
    }

    public void doTransform(Engine engine, Transform transform) {
        if (this.doMarkers.isSelected()) {
            if (this.doMeasureAll.isSelected()) {
                KGroup kGroup = this.makeMageMeasures(this.trackedPoints);
                kGroup.doTransform(engine, transform);
            } else {
                KList kList = this.makeNormalMarkers(this.trackedPoints, 2);
                kList.doTransform(engine, transform);
            }
        }
    }

    public void overpaintCanvas(Painter painter) {
        Engine2D engine2D = this.kCanvas.getEngine();
        if (engine2D == null) {
            return;
        }
        Dimension dimension = this.kCanvas.getCanvasSize();
        painter.setFont(engine2D.labelFont);
        Color color = engine2D.whiteBackground ? Color.black : Color.white;
        int n = painter.getLabelAscent("X");
        int n2 = painter.getLabelDescent("X");
        int n3 = n + 4;
        int n4 = dimension.height - n2 - 4;
        int n5 = n4 - (n + n2 + 4);
        int n6 = 4;
        int n7 = dimension.width / 2 + 4;
        Aspect aspect = this.kCanvas.getCurrentAspect();
        if (aspect != null) {
            this.setAspect(aspect.getName());
        } else {
            this.setAspect(null);
        }
        if (this.aspect != null) {
            painter.paintLabel(color, this.aspect, n6, n3, 0.0);
        }
        if (this.coords != null && this.doXYZ.isSelected()) {
            painter.paintLabel(color, this.coords, n7, n3, 0.0);
        }
        if (this.pointID != null) {
            int n8 = painter.getLabelWidth(this.pointID);
            if (n6 + n8 >= n7) {
                painter.paintLabel(color, this.pointID, n6, n5, 0.0);
                if (n6 + n8 >= dimension.width) {
                    SoftLog.out.println(this.pointID);
                }
            } else {
                painter.paintLabel(color, this.pointID, n6, n4, 0.0);
            }
        }
        if (this.distance != null) {
            painter.paintLabel(color, this.distance, n7, n4, 0.0);
        }
    }

    public void setID(String string) {
        this.pointID = string;
    }

    public void setDist(String string) {
        this.distance = string;
    }

    private void setAspect(String string) {
        this.aspect = string;
    }

    public void setCoords(String string) {
        this.coords = string;
        if (this.coords != null && this.doXYZ.isSelected()) {
            System.err.println(this.coords);
        }
    }
}

