/*
 * Decompiled with CFR 0.152.
 */
package king;

import java.lang.ref.WeakReference;
import king.KingMain;
import king.core.Kinemage;

public class KMessage {
    public static final long KING_STARTUP = 1L;
    public static final long KIN_LOADED = 2L;
    public static final long KIN_SWITCHED = 4L;
    public static final long KIN_CLOSED = 8L;
    public static final long ALL_CLOSED = 16L;
    public static final long PRE_KIN_SAVE = 32L;
    public static final long PREFS_CHANGED = 64L;
    public static final long VIEW_SELECTED = 256L;
    public static final long DISPLAY_OPTIONS = 512L;
    public static final long KING_SHUTDOWN = 1024L;
    protected Object source = null;
    protected Kinemage kinemage = null;
    protected int kinChanges = 0;
    protected long progChanges = 0L;

    public KMessage(Object object) {
        this(object, 0L);
    }

    public KMessage(Object object, long l) {
        if (object instanceof Kinemage) {
            throw new IllegalArgumentException("Source object for program-type events cannot be a Kinemage");
        }
        this.source = object;
        this.progChanges = l;
    }

    public KMessage(Kinemage kinemage, int n) {
        this.kinemage = kinemage;
        this.kinChanges = n;
    }

    public Object getSource() {
        return this.source;
    }

    public Kinemage getKinemage() {
        return this.kinemage;
    }

    public int getKinemageChanges() {
        return this.kinChanges;
    }

    public long getProgramChanges() {
        return this.progChanges;
    }

    public boolean testKin(int n) {
        return (this.kinChanges & n) != 0;
    }

    public boolean testProg(long l) {
        return (this.progChanges & l) != 0L;
    }

    public String toString() {
        return "[kinChanges=" + Integer.toHexString(this.kinChanges) + ",progChanges=" + Long.toHexString(this.progChanges) + "]";
    }

    public static class WeakSubscriber
    implements Subscriber {
        WeakReference<Subscriber> ref;
        KingMain kMain;

        public WeakSubscriber(KingMain kingMain, Subscriber subscriber) {
            this.kMain = kingMain;
            this.ref = new WeakReference<Subscriber>(subscriber);
        }

        public void deliverMessage(KMessage kMessage) {
            Subscriber subscriber = (Subscriber)this.ref.get();
            if (subscriber == null) {
                this.kMain.unsubscribe(this);
            } else {
                subscriber.deliverMessage(kMessage);
            }
        }
    }

    public static interface Subscriber {
        public void deliverMessage(KMessage var1);
    }
}

