/*
 * Decompiled with CFR 0.152.
 */
package hless;

import boundrotamers.NDFloatTable;
import hless.Atom;
import hless.Model;
import hless.PdbReader;
import hless.Props;
import hless.Residue;
import hless.Triple;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class Ramachandran {
    static final DecimalFormat df = new DecimalFormat("0.00");
    static final String PROTEIN_RES = "GLY,ALA,VAL,LEU,ILE,PRO,PHE,TYR,TRP,SER,THR,CYS,MET,MSE,LYS,HIS,ARG,ASP,ASN,GLN,GLU";
    Model model;
    LinkedHashMap data;
    boolean tablesOK = false;
    NDFloatTable genTable = null;
    NDFloatTable glyTable = null;
    NDFloatTable proTable = null;
    NDFloatTable preproTable = null;
    double genOuter = 0.0;
    double genInner = 0.0;
    double glyOuter = 0.0;
    double glyInner = 0.0;
    double proOuter = 0.0;
    double proInner = 0.0;
    double preproOuter = 0.0;
    double preproInner = 0.0;
    LineNumberReader pdbSource = null;
    PrintWriter kinSink = null;
    PrintWriter summarySink = null;
    File imgSink = null;
    boolean makeKin = true;
    boolean showRaw = false;
    boolean showSummary = true;
    boolean summarizeInHTML = false;
    boolean outliersKin = false;
    String outliersColor;
    String toScore = null;

    public Ramachandran(Model model) {
        this.model = model;
        this.data = new LinkedHashMap(1001);
    }

    public boolean loadTables(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, InputStream inputStream4) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            this.genTable = new NDFloatTable(dataInputStream);
            dataInputStream = new DataInputStream(new BufferedInputStream(inputStream2));
            this.glyTable = new NDFloatTable(dataInputStream);
            dataInputStream = new DataInputStream(new BufferedInputStream(inputStream3));
            this.proTable = new NDFloatTable(dataInputStream);
            dataInputStream = new DataInputStream(new BufferedInputStream(inputStream4));
            this.preproTable = new NDFloatTable(dataInputStream);
            this.tablesOK = true;
        }
        catch (IOException iOException) {
            System.err.println("refit.Ramachandran: Couldn't load data tables. (I/O)");
            this.tablesOK = false;
        }
        return this.tablesOK;
    }

    public boolean loadTablesFromJar() {
        InputStream inputStream = this.getClass().getResourceAsStream("/rc/rama/general.ndft");
        InputStream inputStream2 = this.getClass().getResourceAsStream("/rc/rama/glycine.ndft");
        InputStream inputStream3 = this.getClass().getResourceAsStream("/rc/rama/proline.ndft");
        InputStream inputStream4 = this.getClass().getResourceAsStream("/rc/rama/prepro.ndft");
        if (inputStream != null && inputStream2 != null && inputStream3 != null && inputStream4 != null) {
            this.tablesOK = this.loadTables(inputStream, inputStream2, inputStream3, inputStream4);
            try {
                inputStream.close();
                inputStream2.close();
                inputStream3.close();
                inputStream4.close();
            }
            catch (IOException iOException) {}
        } else {
            System.err.println("refit.Ramachandran: Couldn't load data tables. (not found)");
            this.tablesOK = false;
        }
        return this.tablesOK;
    }

    public void unloadTables() {
        this.tablesOK = false;
        this.genTable = null;
        this.glyTable = null;
        this.proTable = null;
        this.preproTable = null;
        System.gc();
    }

    public void loadLevels(Properties properties) {
        Props props = new Props(properties);
        this.genOuter = props.getFloat("general0", 0.0f);
        this.genInner = props.getFloat("general1", 0.0f);
        this.glyOuter = props.getFloat("glycine0", 0.0f);
        this.glyInner = props.getFloat("glycine1", 0.0f);
        this.proOuter = props.getFloat("proline0", 0.0f);
        this.proInner = props.getFloat("proline1", 0.0f);
        this.preproOuter = props.getFloat("prepro0", 0.0f);
        this.preproInner = props.getFloat("prepro1", 0.0f);
    }

    public boolean loadLevelsFromJar() {
        InputStream inputStream = this.getClass().getResourceAsStream("/rc/rama/rama-levels.props");
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            Props props = new Props();
            try {
                props.load(bufferedInputStream);
                this.loadLevels(props);
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("refit.Ramachandran: Couldn't read 'rama-levels.props'. (I/O)");
                return false;
            }
            return true;
        }
        System.err.println("refit.Ramachandran: Couldn't find 'rama-levels.props' in JAR file.");
        return false;
    }

    public void score() {
        if (!this.tablesOK) {
            return;
        }
        float[] fArray = new float[2];
        Iterator iterator = this.model.residueIterator();
        while (iterator.hasNext()) {
            double d;
            Residue residue = (Residue)iterator.next();
            double[] dArray = residue.getPhiPsi();
            if (dArray == null || PROTEIN_RES.indexOf(residue.name.substring(6, 9)) == -1) continue;
            RamaData ramaData = new RamaData(dArray[0], dArray[1]);
            this.data.put(residue, ramaData);
            fArray[0] = (float)dArray[0];
            fArray[1] = (float)dArray[1];
            if (residue.name.endsWith("GLY")) {
                ramaData.type = "Glycine";
                ramaData.numscore = d = (double)this.glyTable.valueAt(fArray);
                if (d >= this.glyInner) {
                    ramaData.score = "Favored";
                    continue;
                }
                if (d >= this.glyOuter) {
                    ramaData.score = "Allowed";
                    continue;
                }
                ramaData.score = "OUTLIER";
                continue;
            }
            if (residue.name.endsWith("PRO")) {
                ramaData.type = "Proline";
                ramaData.numscore = d = (double)this.proTable.valueAt(fArray);
                if (d >= this.proInner) {
                    ramaData.score = "Favored";
                    continue;
                }
                if (d >= this.proOuter) {
                    ramaData.score = "Allowed";
                    continue;
                }
                ramaData.score = "OUTLIER";
                continue;
            }
            if (residue.isPrepro()) {
                ramaData.type = "Pre-proline";
                ramaData.numscore = d = (double)this.preproTable.valueAt(fArray);
                if (d >= this.preproInner) {
                    ramaData.score = "Favored";
                    continue;
                }
                if (d >= this.preproOuter) {
                    ramaData.score = "Allowed";
                    continue;
                }
                ramaData.score = "OUTLIER";
                continue;
            }
            ramaData.type = "General case";
            ramaData.numscore = d = (double)this.genTable.valueAt(fArray);
            if (d >= this.genInner) {
                ramaData.score = "Favored";
                continue;
            }
            if (d >= this.genOuter) {
                ramaData.score = "Allowed";
                continue;
            }
            ramaData.score = "OUTLIER";
        }
    }

    public RamaData scoreString(String string) {
        float f;
        float f2;
        String string2;
        if (!this.tablesOK) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,;:");
        try {
            string2 = stringTokenizer.nextToken().toUpperCase();
            f2 = Float.parseFloat(stringTokenizer.nextToken());
            f = Float.parseFloat(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("score: not enough tokens");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("score: misformatted number");
        }
        float[] fArray = new float[]{f2, f};
        RamaData ramaData = new RamaData(f2, f);
        if (string2.equals("GLY")) {
            double d;
            ramaData.type = "Glycine";
            ramaData.numscore = d = (double)this.glyTable.valueAt(fArray);
            ramaData.score = d >= this.glyInner ? "Favored" : (d >= this.glyOuter ? "Allowed" : "OUTLIER");
        } else if (string2.equals("PRO")) {
            double d;
            ramaData.type = "Proline";
            ramaData.numscore = d = (double)this.proTable.valueAt(fArray);
            ramaData.score = d >= this.proInner ? "Favored" : (d >= this.proOuter ? "Allowed" : "OUTLIER");
        } else if (string2.equals("PREPRO")) {
            double d;
            ramaData.type = "Pre-proline";
            ramaData.numscore = d = (double)this.preproTable.valueAt(fArray);
            ramaData.score = d >= this.preproInner ? "Favored" : (d >= this.preproOuter ? "Allowed" : "OUTLIER");
        } else if (PROTEIN_RES.indexOf(string2) != -1) {
            double d;
            ramaData.type = "General case";
            ramaData.numscore = d = (double)this.genTable.valueAt(fArray);
            ramaData.score = d >= this.genInner ? "Favored" : (d >= this.genOuter ? "Allowed" : "OUTLIER");
        }
        return ramaData;
    }

    public void plotKinemage(PrintWriter printWriter) {
        printWriter.println("@text");
        printWriter.println("Use the animate buttons or the 'A' key to cycle through the various Ramachandran plots.");
        printWriter.println();
        this.textSummary(printWriter);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("General case", "magenta");
        hashMap.put("Glycine", "sea");
        hashMap.put("Proline", "orange");
        hashMap.put("Pre-proline", "sky");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/rc/rama/rama-start.kin")));
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("@dotlist")) {
                printWriter.println(string);
            }
            this.writeOutliers(printWriter, hashMap);
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("@dotlist")) {
                printWriter.println(string);
            }
            this.writeClass(printWriter, "General case", hashMap.get("General case").toString());
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("@dotlist")) {
                printWriter.println(string);
            }
            this.writeClass(printWriter, "Glycine", hashMap.get("Glycine").toString());
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("@dotlist")) {
                printWriter.println(string);
            }
            this.writeClass(printWriter, "Proline", hashMap.get("Proline").toString());
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("@dotlist")) {
                printWriter.println(string);
            }
            this.writeClass(printWriter, "Pre-proline", hashMap.get("Pre-proline").toString());
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            bufferedReader.close();
            printWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("refit.Ramachandran: Couldn't read 'rama-start.kin'. (I/O)");
        }
    }

    void writeClass(PrintWriter printWriter, String string, String string2) {
        RamaData ramaData;
        Residue residue;
        StringBuffer stringBuffer = new StringBuffer("@labellist {outlier labels} color= white master= {Outlier Lbls}\n");
        printWriter.println("@balllist {Good data} color= white radius= 1.5 master= {Data pts} nohilite");
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
            ramaData = (RamaData)this.data.get(residue);
            if (ramaData.type != string || ramaData.score != "Favored" && ramaData.score != "Allowed") continue;
            printWriter.println("{" + residue.name + "} " + df.format(ramaData.phi) + " " + df.format(ramaData.psi) + " 0.0");
        }
        printWriter.println("@balllist {Bad data} color= " + string2 + " radius= 3.0 master= {Data pts} nohilite");
        iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
            ramaData = (RamaData)this.data.get(residue);
            if (ramaData.type != string || ramaData.score != "OUTLIER") continue;
            printWriter.println("{" + residue.name + "} " + df.format(ramaData.phi) + " " + df.format(ramaData.psi) + " 0.0");
            stringBuffer.append("{" + residue.name + "} " + df.format(ramaData.phi + 3.0) + " " + df.format(ramaData.psi) + " 0.0\n");
        }
        printWriter.println(stringBuffer.toString());
    }

    void writeOutliers(PrintWriter printWriter, Map map) {
        RamaData ramaData;
        Residue residue;
        StringBuffer stringBuffer = new StringBuffer("@labellist {outlier labels} color= white master= {Outlier Lbls}\n");
        printWriter.println("@balllist {Good data} color= white radius= 1.5 master= {Data pts} nohilite");
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
            ramaData = (RamaData)this.data.get(residue);
            if (ramaData.score != "Favored" && ramaData.score != "Allowed") continue;
            printWriter.println("{" + residue.name + "} " + df.format(ramaData.phi) + " " + df.format(ramaData.psi) + " 0.0");
        }
        printWriter.println("@balllist {Bad data} color= white radius= 3.0 master= {Data pts} nohilite");
        iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
            ramaData = (RamaData)this.data.get(residue);
            if (ramaData.score != "OUTLIER") continue;
            String string = map.get(ramaData.type).toString();
            printWriter.println("{" + residue.name + "} " + string + " " + df.format(ramaData.phi) + " " + df.format(ramaData.psi) + " 0.0");
            stringBuffer.append("{" + residue.name + "} " + df.format(ramaData.phi + 3.0) + " " + df.format(ramaData.psi) + " 0.0\n");
        }
        printWriter.println(stringBuffer.toString());
    }

    public void drawOutlierCaTrace(PrintWriter printWriter) {
        Triple triple = new Triple();
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        printWriter.println("@vectorlist {bad Rama Ca} width= 4 color= " + this.outliersColor);
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            Residue residue = (Residue)iterator.next();
            RamaData ramaData = (RamaData)this.data.get(residue);
            if (ramaData.score != "OUTLIER") continue;
            Atom atom = residue.prev.findAtom(" CA ");
            if (atom == null) {
                atom = residue.findAtom(" N  ");
            }
            Atom atom2 = residue.findAtom(" CA ");
            Atom atom3 = residue.next.findAtom(" CA ");
            if (atom3 == null) {
                atom3 = residue.findAtom(" C  ");
            }
            if (atom == null || atom3 == null) {
                System.err.println("Unable to draw Ca-Ca for " + residue);
                continue;
            }
            triple = Triple.midpoint(atom, atom2);
            printWriter.println("{" + residue.prev.name + " CA}P " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
            triple = atom2;
            printWriter.println("{" + residue.name + " CA} " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
            triple = Triple.midpoint(atom3, atom2);
            printWriter.println("{" + residue.next.name + " CA} " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
        }
    }

    public void textRaw(PrintWriter printWriter) {
        printWriter.println("#residue:score%:phi:psi:evaluation:type");
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            Residue residue = (Residue)iterator.next();
            RamaData ramaData = (RamaData)this.data.get(residue);
            if (ramaData.score == "Not evaluated") continue;
            printWriter.println(residue.name + ":" + df.format(ramaData.numscore * 100.0) + ":" + df.format(ramaData.phi) + ":" + df.format(ramaData.psi) + ":" + ramaData.score + ":" + ramaData.type);
        }
    }

    public void textSummary(PrintWriter printWriter) {
        RamaData ramaData;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        DecimalFormat decimalFormat = new DecimalFormat("0");
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            ramaData = (RamaData)iterator.next();
            if (ramaData.score == "Favored") {
                d += 1.0;
                continue;
            }
            if (ramaData.score == "Allowed") {
                d2 += 1.0;
                continue;
            }
            if (ramaData.score != "OUTLIER") continue;
            d3 += 1.0;
        }
        double d4 = d + d2 + d3;
        printWriter.println(decimalFormat.format(d4) + " residues were evaluated in total for general, glycine, proline, and pre-pro.");
        printWriter.println(df.format(100.0 * d / d4) + "% of all residues were in favored (98%) regions. (" + decimalFormat.format(d) + " residues)");
        printWriter.println(df.format(100.0 * (d2 + d) / d4) + "% of all residues were in allowed (>99.8%) regions. (" + decimalFormat.format(d2 + d) + " residues)");
        if (d3 > 0.0) {
            printWriter.println("There were " + decimalFormat.format(d3) + " outliers:");
            Iterator iterator2 = this.data.keySet().iterator();
            while (iterator2.hasNext()) {
                Residue residue = (Residue)iterator2.next();
                ramaData = (RamaData)this.data.get(residue);
                if (ramaData.score != "OUTLIER") continue;
                printWriter.println("    " + residue.name + ": (phi,psi) = (" + df.format(ramaData.phi) + ", " + df.format(ramaData.psi) + ")");
            }
        } else {
            printWriter.println("There were no outliers.");
        }
        printWriter.println();
        printWriter.println("For more information, see Lovell, et al. (2003) Proteins: Struct Func Gen 50:437-450");
    }

    public void htmlSummary(PrintWriter printWriter) {
        RamaData ramaData;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        DecimalFormat decimalFormat = new DecimalFormat("0");
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            ramaData = (RamaData)iterator.next();
            if (ramaData.score == "Favored") {
                d += 1.0;
                continue;
            }
            if (ramaData.score == "Allowed") {
                d2 += 1.0;
                continue;
            }
            if (ramaData.score != "OUTLIER") continue;
            d3 += 1.0;
        }
        double d4 = d + d2 + d3;
        printWriter.println("<p>" + decimalFormat.format(d4) + " residues were evaluated in total for general, glycine, proline, and pre-pro.");
        printWriter.println("<ul>");
        printWriter.println("<li>" + df.format(100.0 * d / d4) + "% of all residues were in favored (98%) regions. (" + decimalFormat.format(d) + " residues)</li>");
        printWriter.println("<li>" + df.format(100.0 * (d2 + d) / d4) + "% of all residues were in allowed (>99.8%) regions. (" + decimalFormat.format(d2 + d) + " residues)</li>");
        printWriter.println("</ul>");
        if (d3 > 0.0) {
            printWriter.println("<p>There were " + decimalFormat.format(d3) + " outliers:");
            printWriter.println("<br><table border=1 cellpadding=4><tr align=center><td><b>Residue</b></td><td><b>phi</b></td><td><b>psi</b></td><td><b>class</b></td></tr>");
            Iterator iterator2 = this.data.keySet().iterator();
            while (iterator2.hasNext()) {
                Residue residue = (Residue)iterator2.next();
                ramaData = (RamaData)this.data.get(residue);
                if (ramaData.score != "OUTLIER") continue;
                printWriter.println("<tr align=right><td align=left>" + residue.name + "</td><td>" + df.format(ramaData.phi) + "</td><td>" + df.format(ramaData.psi) + "</td><td>" + ramaData.type + "</td></tr>");
            }
            printWriter.println("</table");
        } else {
            printWriter.println("<p>There were no outliers.");
        }
        printWriter.println("<p>For more information, see Lovell, <i>et al</i>. (2003) Proteins: Struct Func Gen <b>50</b>:437-450");
    }

    public boolean isOutlier(Residue residue, float[] fArray) {
        if (!this.tablesOK) {
            return false;
        }
        if (fArray == null || PROTEIN_RES.indexOf(residue.name.substring(6, 9)) == -1) {
            return false;
        }
        if (residue.name.endsWith("GLY")) {
            double d = this.glyTable.valueAt(fArray);
            return !(d >= this.glyOuter);
        }
        if (residue.name.endsWith("PRO")) {
            double d = this.proTable.valueAt(fArray);
            return !(d >= this.proOuter);
        }
        if (residue.isPrepro()) {
            double d = this.preproTable.valueAt(fArray);
            return !(d >= this.preproOuter);
        }
        double d = this.genTable.valueAt(fArray);
        return !(d >= this.genOuter);
    }

    void plotOnImage() throws IOException {
        System.setProperty("java.awt.headless", "true");
        String string = this.imgSink.getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        BufferedImage bufferedImage = ImageIO.read(this.getClass().getResourceAsStream("/rc/rama/rama-start.1024.png"));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.plotClass(graphics2D, new Rectangle(52, 35, 430, 430), "General case", new Color(0xCC00CC));
        this.plotClass(graphics2D, new Rectangle(563, 36, 429, 429), "Glycine", new Color(52326));
        this.plotClass(graphics2D, new Rectangle(53, 553, 429, 429), "Proline", new Color(0xCC6600));
        this.plotClass(graphics2D, new Rectangle(563, 553, 429, 429), "Pre-proline", new Color(0x3366CC));
        this.plotSummary(graphics2D);
        if (!ImageIO.write((RenderedImage)bufferedImage, string, this.imgSink)) {
            throw new IOException("Output in '" + string + "' format is not supported");
        }
    }

    void plotClass(Graphics2D graphics2D, Rectangle rectangle, String string, Color color) {
        int n;
        int n2;
        RamaData ramaData;
        Residue residue;
        Color color2 = new Color(0x333333);
        Color color3 = new Color(0);
        graphics2D.setColor(color2);
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
            ramaData = (RamaData)this.data.get(residue);
            if (ramaData.type != string || ramaData.score != "Favored" && ramaData.score != "Allowed") continue;
            n2 = rectangle.x + (int)((double)rectangle.width * (ramaData.phi + 180.0) / 360.0);
            n = rectangle.y + (int)((double)rectangle.height * (-ramaData.psi + 180.0) / 360.0);
            graphics2D.drawOval(n2 - 2, n - 2, 4, 4);
        }
        graphics2D.setFont(new Font("Serif", 0, 10));
        iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
            ramaData = (RamaData)this.data.get(residue);
            if (ramaData.type != string || ramaData.score != "OUTLIER") continue;
            n2 = rectangle.x + (int)((double)rectangle.width * (ramaData.phi + 180.0) / 360.0);
            n = rectangle.y + (int)((double)rectangle.height * (-ramaData.psi + 180.0) / 360.0);
            graphics2D.setColor(color);
            graphics2D.fillOval(n2 - 3, n - 3, 6, 6);
            graphics2D.setColor(color3);
            graphics2D.drawString(residue.name.trim(), n2 + 4, n + 4);
        }
    }

    public void plotSummary(Graphics2D graphics2D) {
        RamaData ramaData;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        DecimalFormat decimalFormat = new DecimalFormat("0");
        graphics2D.setFont(new Font("Serif", 0, 12));
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            ramaData = (RamaData)iterator.next();
            if (ramaData.score == "Favored") {
                d += 1.0;
                continue;
            }
            if (ramaData.score == "Allowed") {
                d2 += 1.0;
                continue;
            }
            if (ramaData.score != "OUTLIER") continue;
            d3 += 1.0;
        }
        double d4 = d + d2 + d3;
        int n = 53;
        int n2 = 1040;
        int n3 = 1270;
        int n4 = 300;
        int n5 = 15;
        graphics2D.drawString(decimalFormat.format(d4) + " residues were evaluated in total for general, glycine, proline, and pre-pro.", n, n2);
        graphics2D.drawString(df.format(100.0 * d / d4) + "% of all residues were in favored (98%) regions. (" + decimalFormat.format(d) + " residues)", n, n2 += n5);
        graphics2D.drawString(df.format(100.0 * (d2 + d) / d4) + "% of all residues were in allowed (>99.8%) regions. (" + decimalFormat.format(d2 + d) + " residues)", n, n2 += n5);
        n2 += 2 * n5;
        if (d3 > 0.0) {
            graphics2D.drawString("There were " + decimalFormat.format(d3) + " outliers:", n, n2);
            int n6 = n2 += n5;
            Iterator iterator2 = this.data.keySet().iterator();
            while (iterator2.hasNext()) {
                Residue residue = (Residue)iterator2.next();
                ramaData = (RamaData)this.data.get(residue);
                if (ramaData.score != "OUTLIER") continue;
                graphics2D.drawString(residue.name + ": (phi,psi) = (" + df.format(ramaData.phi) + ", " + df.format(ramaData.psi) + ")", n, n2);
                if ((n2 += n5) <= n3) continue;
                n2 = n6;
                n += n4;
            }
        } else {
            graphics2D.drawString("There were no outliers.", n, n2);
        }
    }

    public void Main() {
        if (!this.loadTablesFromJar()) {
            System.exit(1);
        }
        if (!this.loadLevelsFromJar()) {
            System.exit(1);
        }
        if (this.toScore != null) {
            RamaData ramaData = this.scoreString(this.toScore);
            DecimalFormat decimalFormat = new DecimalFormat("0.#####");
            System.out.println(decimalFormat.format(ramaData.numscore) + ":" + ramaData.score + ":" + ramaData.type);
        } else {
            PdbReader pdbReader = new PdbReader(this.model);
            try {
                pdbReader.read(this.pdbSource);
                this.pdbSource.close();
            }
            catch (IOException iOException) {
                System.err.println("*** Couldn't read in PDB file. (I/O)");
                System.exit(1);
            }
            this.score();
            if (this.makeKin) {
                if (this.outliersKin) {
                    this.drawOutlierCaTrace(this.kinSink);
                } else {
                    this.plotKinemage(this.kinSink);
                }
            }
            if (this.showRaw) {
                this.textRaw(this.summarySink);
            }
            if (this.showSummary) {
                if (this.summarizeInHTML) {
                    this.htmlSummary(this.summarySink);
                } else {
                    this.textSummary(this.summarySink);
                }
            }
            if (this.imgSink != null) {
                try {
                    this.plotOnImage();
                }
                catch (HeadlessException headlessException) {
                    headlessException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.kinSink.flush();
        this.summarySink.flush();
        this.kinSink.close();
        this.summarySink.close();
    }

    public static void main(String[] stringArray) {
        Ramachandran ramachandran = new Ramachandran(new Model());
        try {
            ramachandran.parseArguments(stringArray);
            ramachandran.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ramachandran.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--")) {
                bl = false;
                linkedList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("-") && bl) {
                int n = stringArray[i].indexOf(61);
                if (n != -1) {
                    linkedList.add(stringArray[i].substring(0, n));
                    linkedList.add(stringArray[i].substring(n + 1));
                    continue;
                }
                linkedList.add(stringArray[i]);
                continue;
            }
            linkedList.add(stringArray[i]);
        }
        ListIterator listIterator = linkedList.listIterator();
        try {
            this.interpretArguments(listIterator);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("'" + listIterator.previous() + "' expected an argument");
        }
    }

    int getInt(Iterator iterator) {
        String string = iterator.next().toString();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not an integer");
        }
    }

    double getDouble(Iterator iterator) {
        String string = iterator.next().toString();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not a real number");
        }
    }

    LineNumberReader getReader(String string) {
        LineNumberReader lineNumberReader = null;
        if (string.equals("-")) {
            lineNumberReader = new LineNumberReader(new InputStreamReader(System.in));
        } else {
            try {
                lineNumberReader = new LineNumberReader(new FileReader(string));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("'" + string + "' is not a readable file or stream.");
            }
        }
        return lineNumberReader;
    }

    BufferedWriter getWriter(String string) {
        BufferedWriter bufferedWriter = null;
        if (string.equals("-")) {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        } else {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("'" + string + "' is not a writable file or stream.");
            }
        }
        return bufferedWriter;
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("/rc/Ramachandran.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in '/rc/Ramachandran.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("hless.Ramachandran, version 0.47 (build 0_0)");
        System.err.println("Copyright (C) 2002-2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArguments(Iterator iterator) {
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!string.startsWith("-") || !bl || string.equals("-")) {
                if (this.pdbSource == null) {
                    this.pdbSource = this.getReader(string);
                    continue;
                }
                if (this.kinSink == null) {
                    this.kinSink = new PrintWriter(this.getWriter(string));
                    continue;
                }
                if (this.summarySink != null) continue;
                this.summarySink = new PrintWriter(this.getWriter(string));
                continue;
            }
            if (string.equals("--")) {
                bl = false;
                continue;
            }
            if (string.equals("-help") || string.equals("-h")) {
                this.showHelp(true);
                System.exit(0);
                continue;
            }
            if (string.equals("-html")) {
                this.summarizeInHTML = true;
                continue;
            }
            if (string.equals("-raw")) {
                this.showRaw = true;
                this.showSummary = false;
                continue;
            }
            if (string.equals("-nosummary")) {
                this.showSummary = false;
                continue;
            }
            if (string.equals("-nokin")) {
                this.makeKin = false;
                continue;
            }
            if (string.equals("-score")) {
                this.toScore = iterator.next().toString();
                continue;
            }
            if (string.equals("-outliers")) {
                this.outliersKin = true;
                this.outliersColor = iterator.next().toString();
                continue;
            }
            if (string.equals("-img")) {
                this.imgSink = new File(iterator.next().toString());
                continue;
            }
            if (string.equals("-dummy_option")) continue;
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid argument.");
        }
        if (this.pdbSource == null) {
            this.pdbSource = this.getReader("-");
        }
        if (this.kinSink == null) {
            this.kinSink = new PrintWriter(this.getWriter("-"));
        }
        if (this.summarySink == null) {
            this.summarySink = new PrintWriter(this.getWriter("-"));
        }
    }

    public static class RamaData {
        public static final String FAVORED = "Favored";
        public static final String ALLOWED = "Allowed";
        public static final String OUTLIER = "OUTLIER";
        public static final String NOSCORE = "Not evaluated";
        public static final String GENERAL = "General case";
        public static final String GLYCINE = "Glycine";
        public static final String PROLINE = "Proline";
        public static final String PREPRO = "Pre-proline";
        public static final String NOTYPE = "Unknown type";
        public double phi;
        public double psi;
        public double numscore = 0.0;
        public String score = "Not evaluated";
        public String type = "Unknown type";

        public RamaData(double d, double d2) {
            this.phi = d;
            this.psi = d2;
        }
    }
}

