/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;

public class DirectoryWriter
implements DataEntryWriter {
    private final File baseDirectory;

    public DirectoryWriter(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        File directory = this.getFile(dataEntry);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Can't create directory [" + directory.getPath() + "]");
        }
        return true;
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.getFile(dataEntry1).equals(this.getFile(dataEntry2));
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        File file = this.getFile(dataEntry);
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new IOException("Can't create directory [" + parentDirectory.getPath() + "]");
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "DirectoryWriter (base directory [" + this.baseDirectory + "])");
    }

    private File getFile(DataEntry dataEntry) {
        return new File(this.baseDirectory, dataEntry.getName().replace('/', File.separatorChar));
    }
}

