/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.io.PrintWriter;
import java.util.List;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class WarningPrinter {
    private final PrintWriter printWriter;
    private final StringMatcher classFilter;
    private int warningCount;

    public WarningPrinter(PrintWriter printWriter) {
        this.printWriter = printWriter;
        this.classFilter = null;
    }

    public WarningPrinter(PrintWriter printWriter, List classFilter) {
        this.printWriter = printWriter;
        this.classFilter = classFilter == null ? null : new ListParser(new ClassNameParser()).parse(classFilter);
    }

    public void print(String className, String warning) {
        if (this.accepts(className)) {
            this.print(warning);
        }
    }

    public boolean accepts(String className) {
        return this.classFilter == null || !this.classFilter.matches(className);
    }

    public void print(String className1, String className2, String warning) {
        if (this.accepts(className1, className2)) {
            this.print(warning);
        }
    }

    public boolean accepts(String className1, String className2) {
        return this.classFilter == null || !this.classFilter.matches(className1) && !this.classFilter.matches(className2);
    }

    private void print(String warning) {
        this.printWriter.println(warning);
        ++this.warningCount;
    }

    public void note(String className, String message) {
        if (this.accepts(className)) {
            this.printWriter.println(message);
        }
    }

    public void note(String className1, String className2, String message) {
        if (this.accepts(className1, className2)) {
            this.printWriter.println(message);
        }
    }

    public int getWarningCount() {
        return this.warningCount;
    }
}

