/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.LocalTransactionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jca.cci.connection.ConnectionFactoryUtils;
import org.springframework.jca.cci.connection.ConnectionHolder;
import org.springframework.jca.cci.connection.TransactionAwareConnectionFactoryProxy;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CciLocalTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private ConnectionFactory connectionFactory;

    public CciLocalTransactionManager() {
    }

    public CciLocalTransactionManager(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(ConnectionFactory cf) {
        this.connectionFactory = cf instanceof TransactionAwareConnectionFactoryProxy ? ((TransactionAwareConnectionFactoryProxy)cf).getTargetConnectionFactory() : cf;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void afterPropertiesSet() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
    }

    public Object getResourceFactory() {
        return this.getConnectionFactory();
    }

    protected Object doGetTransaction() {
        CciLocalTransactionObject txObject = new CciLocalTransactionObject();
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getConnectionFactory());
        txObject.setConnectionHolder(conHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        return txObject.getConnectionHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        Connection con = null;
        try {
            con = this.getConnectionFactory().getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Acquired Connection [" + con + "] for local CCI transaction");
            }
            txObject.setConnectionHolder(new ConnectionHolder(con));
            txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
            con.getLocalTransaction().begin();
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getConnectionHolder().setTimeoutInSeconds(timeout);
            }
            TransactionSynchronizationManager.bindResource(this.getConnectionFactory(), txObject.getConnectionHolder());
        }
        catch (NotSupportedException ex) {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
            throw new CannotCreateTransactionException("CCI Connection does not support local transactions", ex);
        }
        catch (LocalTransactionException ex) {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
            throw new CannotCreateTransactionException("Could not begin local CCI transaction", ex);
        }
        catch (ResourceException ex) {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
            throw new TransactionSystemException("Unexpected failure on begin of CCI local transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        txObject.setConnectionHolder(null);
        return TransactionSynchronizationManager.unbindResource(this.getConnectionFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        ConnectionHolder conHolder = (ConnectionHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.getConnectionFactory(), conHolder);
    }

    protected boolean isRollbackOnly(Object transaction) throws TransactionException {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        return txObject.getConnectionHolder().isRollbackOnly();
    }

    protected void doCommit(DefaultTransactionStatus status) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)status.getTransaction();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug("Committing CCI local transaction on Connection [" + con + "]");
        }
        try {
            con.getLocalTransaction().commit();
        }
        catch (LocalTransactionException ex) {
            throw new TransactionSystemException("Could not commit CCI local transaction", ex);
        }
        catch (ResourceException ex) {
            throw new TransactionSystemException("Unexpected failure on commit of CCI local transaction", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)status.getTransaction();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug("Rolling back CCI local transaction on Connection [" + con + "]");
        }
        try {
            con.getLocalTransaction().rollback();
        }
        catch (LocalTransactionException ex) {
            throw new TransactionSystemException("Could not roll back CCI local transaction", ex);
        }
        catch (ResourceException ex) {
            throw new TransactionSystemException("Unexpected failure on rollback of CCI local transaction", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Setting CCI local transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only");
        }
        txObject.getConnectionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.getConnectionFactory());
        txObject.getConnectionHolder().clear();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Releasing CCI Connection [" + con + "] after transaction");
        }
        ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
    }

    private static class CciLocalTransactionObject {
        private ConnectionHolder connectionHolder;

        private CciLocalTransactionObject() {
        }

        public void setConnectionHolder(ConnectionHolder connectionHolder) {
            this.connectionHolder = connectionHolder;
        }

        public ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

